/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.award.budget.AwardBudgetForm;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCommonService;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.rates.BudgetRatesService;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.budget.web.struts.action.BudgetAction;
import org.kuali.kra.budget.web.struts.action.BudgetTDCValidator;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarcyActionHelper;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetVersionsAction
extends BudgetAction {
    private static final String TOGGLE_TAB = "toggleTab";
    private static final String CONFIRM_SYNCH_BUDGET_RATE_BUDGET_DOCUMENT = "confirmSynchBudgetRateForBudgetDocument";
    private static final String NO_SYNCH_BUDGET_RATE_BUDGET_DOCUMENT = "noSynchBudgetRateForBudgetDocument";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("rateClassMap", (Object)this.getBudgetRatesService().getBudgetRateClassMap("O"));
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        if (TOGGLE_TAB.equals(budgetForm.getMethodToCall())) {
            BudgetTDCValidator tdcValidator = new BudgetTDCValidator(request);
            tdcValidator.validateGeneratingWarnings(parentDocument);
        }
        if (!StringUtils.equals((String)budgetForm.getMethodToCall(), (String)"save") && budgetForm.isSaveAfterCopy()) {
            List overviews = parentDocument.getBudgetDocumentVersions();
            BudgetVersionOverview copiedOverview = ((BudgetDocumentVersion)overviews.get(overviews.size() - 1)).getBudgetVersionOverview();
            String copiedName = copiedOverview.getDocumentDescription();
            copiedOverview.setDocumentDescription("copied placeholder");
            BufferedLogger.debug((Object[])new Object[]{"validating ", copiedName});
            boolean valid = this.getBudgetService().isBudgetVersionNameValid(parentDocument, copiedName);
            copiedOverview.setDocumentDescription(copiedName);
            budgetForm.setSaveAfterCopy(!valid);
            if (!valid) {
                return mapping.findForward("basic");
            }
            budgetForm.getBudgetDocument().getParentDocument().updateDocumentDescriptions(overviews);
        }
        return super.execute(mapping, form, request, response);
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Award award;
        ActionForward forward = super.docHandler(mapping, form, request, response);
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        BudgetParent budgetParent = parentDocument.getBudgetParent();
        budgetForm.setFinalBudgetVersion(this.getFinalBudgetVersion(parentDocument.getBudgetDocumentVersions()));
        this.setBudgetStatuses(parentDocument);
        AwardBudgetService awardBudgetService = (AwardBudgetService)KraServiceLocator.getService(AwardBudgetService.class);
        BudgetService budgetService = (BudgetService)KraServiceLocator.getService(BudgetService.class);
        Collection savedBudgetRates = budgetService.getSavedBudgetRates(budget);
        Collection allPropRates = budgetService.getSavedBudgetRates(budget);
        if (this.isAwardBudget(budgetDocument) && awardBudgetService.checkRateChange(savedBudgetRates, award = (Award)budgetDocument.getParentDocument().getBudgetParent())) {
            return this.confirm(this.syncAwardBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.synchAwardRates.text"), "confirmSynchAwardRates", "noSynchAwardRates");
        }
        if (budgetService.checkActivityTypeChange(allPropRates, budgetParent.getActivityTypeCode())) {
            budget.setRateClassTypesReloaded(true);
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.synchBudgetRate.text"), CONFIRM_SYNCH_BUDGET_RATE_BUDGET_DOCUMENT, NO_SYNCH_BUDGET_RATE_BUDGET_DOCUMENT);
        }
        if (CollectionUtils.isEmpty((Collection)allPropRates)) {
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.noRatesSynch.text"), CONFIRM_SYNCH_BUDGET_RATE_BUDGET_DOCUMENT, NO_SYNCH_BUDGET_RATE_BUDGET_DOCUMENT);
        }
        BudgetTDCValidator tdcValidator = new BudgetTDCValidator(request);
        tdcValidator.validateGeneratingWarnings(parentDocument);
        return forward;
    }

    public ActionForward addBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        BudgetDocument newBudgetDoc = this.getBudgetService().addBudgetVersion(parentDocument, budgetForm.getNewBudgetVersionName());
        budgetForm.setNewBudgetVersionName("");
        return mapping.findForward("basic");
    }

    private BudgetParentDocument getBudgetParentDocument(BudgetForm budgetForm) {
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        return parentDocument;
    }

    private BudgetService getBudgetService() {
        return (BudgetService)KraServiceLocator.getService(BudgetService.class);
    }

    public ActionForward openBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetService budgetService = (BudgetService)KraServiceLocator.getService(BudgetService.class);
        if (!"TRUE".equals(budgetForm.getEditingMode().get("viewOnly"))) {
            this.save(mapping, form, request, response);
        }
        BudgetDocument budgetDoc = budgetForm.getBudgetDocument();
        Budget budget = budgetDoc.getBudget();
        BudgetParentDocument budgetParentDocument = this.getBudgetParentDocument(budgetForm);
        BudgetParent budgetParent = budgetParentDocument.getBudgetParent();
        BudgetDocumentVersion budgetDocumentToOpen = budgetParentDocument.getBudgetDocumentVersion(this.getSelectedLine(request));
        BudgetVersionOverview budgetToOpen = budgetDocumentToOpen.getBudgetVersionOverview();
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        BudgetDocument budgetDocument = (BudgetDocument)documentService.getByDocumentHeaderId(budgetToOpen.getDocumentNumber());
        Budget budgetOpen = budgetDocument.getBudget();
        String routeHeaderId = budgetDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        Collection allPropRates = budgetService.getSavedBudgetRates(budgetOpen);
        if (this.getBudgetRateService().performSyncFlag(budgetDocument)) {
            budget.setRateClassTypesReloaded(true);
        }
        if (budgetService.checkActivityTypeChange(allPropRates, budgetParent.getActivityTypeCode())) {
            budget.setRateClassTypesReloaded(true);
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.synchBudgetRate.text"), "confirmSynchBudgetRate", "noSynchBudgetRate");
        }
        if (CollectionUtils.isEmpty((Collection)allPropRates)) {
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.noRatesSynch.text"), "confirmSynchBudgetRate", "noSynchBudgetRate");
        }
        String forward = this.buildForwardUrl(routeHeaderId);
        return new ActionForward(forward, true);
    }

    protected StrutsConfirmation syncBudgetRateConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String message) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "confirmSynchBudgetRate", message, new String[]{""});
    }

    public ActionForward confirmSynchBudgetRateForBudgetDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        return this.synchBudgetRate(budgetDocument, true);
    }

    public ActionForward noSynchBudgetRateForBudgetDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        return this.synchBudgetRate(budgetDocument, false);
    }

    protected ActionForward synchBudgetRate(BudgetDocument budgetDocument, boolean confirm) throws Exception {
        Budget budgetOpen = budgetDocument.getBudget();
        String routeHeaderId = budgetDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        budgetOpen.setActivityTypeCode(budgetDocument.getParentDocument().getBudgetParent().getActivityTypeCode());
        budgetOpen.setRateClassTypesReloaded(true);
        String forward = this.buildForwardUrl(routeHeaderId);
        if (confirm) {
            forward = forward.replace("budgetParameters.do?", "budgetParameters.do?syncBudgetRate=Y&");
        }
        return new ActionForward(forward, true);
    }

    public ActionForward confirmSynchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = this.getSelectedBudgetDocument(request, budgetForm);
        return this.synchBudgetRate(budgetDocument, true);
    }

    private BudgetDocument getSelectedBudgetDocument(HttpServletRequest request, BudgetForm budgetForm) throws WorkflowException {
        BudgetDocument budgetDoc = budgetForm.getBudgetDocument();
        BudgetParentDocument budgetParentDocument = budgetDoc.getParentDocument();
        BudgetDocumentVersion budgetDocumentToOpen = budgetParentDocument.getBudgetDocumentVersion(this.getSelectedLine(request));
        BudgetVersionOverview budgetToOpen = budgetDocumentToOpen.getBudgetVersionOverview();
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        BudgetDocument budgetDocument = (BudgetDocument)documentService.getByDocumentHeaderId(budgetToOpen.getDocumentNumber());
        return budgetDocument;
    }

    public ActionForward noSynchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = this.getSelectedBudgetDocument(request, budgetForm);
        return this.synchBudgetRate(budgetDocument, false);
    }

    private BudgetRatesService getBudgetRateService() {
        return (BudgetRatesService)KraServiceLocator.getService(BudgetRatesService.class);
    }

    public ActionForward copyBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetVersionOverview versionToCopy = this.getSelectedVersion(budgetForm, request);
        BudgetParentDocument parentDocument = budgetForm.getBudgetDocument().getParentDocument();
        BudgetCommonService budgetService = this.getBudgetCommonService(parentDocument);
        if (!budgetService.validateAddingNewBudget(parentDocument)) {
            return mapping.findForward("basic");
        }
        if (StringUtils.isNotBlank((String)request.getParameter("questionIndex"))) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("1".equals(buttonClicked)) {
                budgetForm.setSaveAfterCopy(true);
                return this.copyBudgetPeriodOne(mapping, form, request, response);
            }
            if ("0".equals(buttonClicked)) {
                budgetForm.setSaveAfterCopy(true);
                return this.copyBudgetAllPeriods(mapping, form, request, response);
            }
            return mapping.findForward("basic");
        }
        return this.performQuestionWithoutInput(mapping, form, request, response, "copyBudgetQuestion", "A new version of the budget will be created based on version " + versionToCopy.getBudgetVersionNumber() + ".", "copyPeriodsQuestion", budgetForm.getMethodToCall(), "");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        boolean valid = true;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        Budget budget = budgetDocument.getBudget();
        if (parentDocument instanceof ProposalDevelopmentDocument && !new ProposalHierarcyActionHelper().checkParentChildStatusMatch((ProposalDevelopmentDocument)parentDocument)) {
            return mapping.findForward("basic");
        }
        try {
            valid &= this.getBudgetService().validateBudgetAuditRuleBeforeSaveBudgetVersion(parentDocument);
        }
        catch (Exception ex) {
            BufferedLogger.info((Object[])new Object[]{"Audit rule check failed ", ex.getStackTrace()});
        }
        if (!valid) {
            Integer budgetVersionNumber = budgetForm.getFinalBudgetVersion();
            if (budgetVersionNumber == null || budgetVersionNumber == -1) {
                budgetVersionNumber = budget.getBudgetVersionNumber();
            }
            GlobalVariables.getMessageMap().putError("document.parentDocument.budgetDocumentVersion[" + (budgetVersionNumber - 1) + "].budgetVersionOverview.budgetStatus", "clear.audit.error.before.change.status.to.complete", new String[0]);
        }
        if (budgetForm.isSaveAfterCopy()) {
            List overviews = parentDocument.getBudgetDocumentVersions();
            BudgetVersionOverview copiedOverview = ((BudgetDocumentVersion)overviews.get(overviews.size() - 1)).getBudgetVersionOverview();
            String copiedName = copiedOverview.getDocumentDescription();
            copiedOverview.setDocumentDescription("copied placeholder");
            BufferedLogger.debug((Object[])new Object[]{"validating ", copiedName});
            valid = this.getBudgetService().isBudgetVersionNameValid(parentDocument, copiedName);
            copiedOverview.setDocumentDescription(copiedName);
            budgetForm.setSaveAfterCopy(!valid);
        }
        if (!valid) {
            Iterator i$ = parentDocument.getBudgetDocumentVersions().iterator();
            if (i$.hasNext()) {
                BudgetDocumentVersion budgetDocumentVersion = (BudgetDocumentVersion)i$.next();
                BudgetVersionOverview budgetVersion = budgetDocumentVersion.getBudgetVersionOverview();
                String budgetStatusIncompleteCode = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetStatusIncompleteCode");
                budgetVersion.setBudgetStatus(budgetStatusIncompleteCode);
                if (form instanceof AwardBudgetForm) {
                    new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((AwardBudgetForm)form), true);
                } else {
                    new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((BudgetForm)form), true);
                }
                return mapping.findForward("budgetActions");
            }
            return mapping.findForward("basic");
        }
        this.updateThisBudget(budgetDocument);
        this.setBudgetParentStatus(parentDocument);
        ActionForward forward = super.save(mapping, form, request, response);
        this.setBudgetStatuses(parentDocument);
        return forward;
    }

    public ActionForward copyBudgetPeriodOne(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if ("copyBudgetQuestion".equals(question)) {
            this.copyBudget(form, request, true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward copyBudgetAllPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if ("copyBudgetQuestion".equals(question)) {
            this.copyBudget(form, request, false);
        }
        return mapping.findForward("basic");
    }

    private void updateThisBudget(BudgetDocument budgetDocument) {
        Budget budget = budgetDocument.getBudget();
        for (BudgetDocumentVersion documentVersion : budgetDocument.getParentDocument().getBudgetDocumentVersions()) {
            BudgetVersionOverview version = documentVersion.getBudgetVersionOverview();
            if (!budget.getBudgetVersionNumber().equals(version.getBudgetVersionNumber())) continue;
            budget.setFinalVersionFlag(Boolean.valueOf(version.isFinalVersionFlag()).booleanValue());
            budget.setBudgetStatus(version.getBudgetStatus());
        }
    }

    private BudgetVersionOverview getSelectedVersion(BudgetForm budgetForm, HttpServletRequest request) {
        return budgetForm.getBudgetDocument().getParentDocument().getBudgetDocumentVersion(this.getSelectedLine(request)).getBudgetVersionOverview();
    }

    private void copyBudget(ActionForm form, HttpServletRequest request, boolean copyPeriodOneOnly) throws WorkflowException {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDoc = budgetForm.getBudgetDocument();
        BudgetParentDocument pdDoc = budgetDoc.getParentDocument();
        BudgetVersionOverview budgetToCopy = this.getSelectedVersion(budgetForm, request);
        this.copyBudget(pdDoc, budgetToCopy, copyPeriodOneOnly);
    }

    public ActionForward rebudget(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        AwardDocument parentDocument = (AwardDocument)budgetDocument.getParentDocument();
        AwardBudgetDocument newBudgetDoc = this.getAwardBudgetService().rebudget(parentDocument, budgetForm.getNewBudgetVersionName());
        if (newBudgetDoc != null) {
            budgetForm.setNewBudgetVersionName("");
        }
        return mapping.findForward("basic");
    }

    private AwardBudgetService getAwardBudgetService() {
        return (AwardBudgetService)KraServiceLocator.getService(AwardBudgetService.class);
    }

    private ProposalDevelopmentService getProposalDevelopmentService() {
        return (ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class);
    }

    private BudgetRatesService getBudgetRatesService() {
        return (BudgetRatesService)KraServiceLocator.getService(BudgetRatesService.class);
    }
}

