/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.BudgetCostShare;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.distributionincome.BudgetUnrecoveredFandA;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetFormulatedCostDetail;
import org.kuali.kra.budget.nonpersonnel.BudgetJustificationWrapper;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.HierarchyPersonnelSummary;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.costshare.CostShareFunctions;
import org.kuali.kra.costshare.CostShareService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularIdc;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularSummary;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarchyException;
import org.kuali.kra.proposaldevelopment.hierarchy.bo.HierarchyProposalSummary;
import org.kuali.kra.proposaldevelopment.hierarchy.service.ProposalHierarchyService;
import org.kuali.kra.web.struts.form.BudgetVersionFormBase;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.util.ActionFormUtilMap;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetForm
extends BudgetVersionFormBase
implements CostShareFunctions {
    private static final long serialVersionUID = -8853937659597422800L;
    private static final String KR_EXTERNALIZABLE_IMAGES_URI_KEY = "kr.externalizable.images.url";
    public static final String VERSION_NUMBER_KEY = "DataDictionary.Budget.attributes.budgetVersionNumber";
    public static final String BUDGET_NAME_KEY = "DataDictionary.KraAttributeReferenceDummy.attributes.budgetName";
    private String newBudgetPersons;
    private String newBudgetRolodexes;
    private String newTbnPersons;
    private BudgetPeriod newBudgetPeriod;
    private List<BudgetLineItem> newBudgetLineItems;
    private Integer newBudgetPeriodNumber = 0;
    private BudgetCostShare newBudgetCostShare;
    private BudgetProjectIncome newBudgetProjectIncome;
    private BudgetUnrecoveredFandA newBudgetUnrecoveredFandA;
    private BudgetModularIdc newBudgetModularIdc;
    private BudgetModularSummary budgetModularSummary;
    private BudgetJustificationWrapper budgetJustificationWrapper;
    private BudgetDecimal costSharingAmount;
    private List<ExtraButton> extraTopButtons;
    private Integer viewBudgetView;
    private Integer viewBudgetPeriod;
    private String viewLocation;
    private Integer modularSelectedPeriod;
    private boolean documentNextValueRefresh;
    private boolean saveAfterCopy;
    private String personnelBudgetViewMode;
    private BudgetLineItem selectedBudgetLineItem;
    private BudgetPersonnelDetails newBudgetPersonnelDetails;
    private Integer selectedBudgetLineItemIndex;
    private String prevOnOffCampusFlag;
    private boolean updateFinalVersion;
    private String ohRateClassCodePrevValue;
    private String urRateClassCodePrevValue;
    private String[] selectedBudgetPrintFormId;
    private String syncBudgetRate;
    private BudgetSubAwards newSubAward;
    private Integer personnelDetailLine;
    private String newGroupName;
    private String[] selectedToPrintComment;
    private transient boolean viewDivFlag = false;
    private transient boolean viewDivBooleanFlag = true;
    private transient Integer personIndex = 0;
    private transient String enableBudgetSalaryByPeriod;
    private BudgetFormulatedCostDetail newBudgetFormulatedCost;
    private transient ProposalHierarchyService proposalHierarchyService;
    private List<HierarchyPersonnelSummary> hierarchyPersonnelSummaries;
    private List<HierarchyProposalSummary> hierarchyProposalSummaries;

    public String[] getSelectedToPrintComment() {
        return this.selectedToPrintComment;
    }

    public void setSelectedToPrintComment(String[] selectedToPrintComment) {
        this.selectedToPrintComment = selectedToPrintComment;
    }

    public List<HierarchyPersonnelSummary> getHierarchyPersonnelSummaries() {
        return this.hierarchyPersonnelSummaries;
    }

    public void setHierarchyPersonnelSummaries(List<HierarchyPersonnelSummary> hierarchyPersonnelSummaries) {
        this.hierarchyPersonnelSummaries = hierarchyPersonnelSummaries;
    }

    public void setHierarchyProposalSummaries(List<HierarchyProposalSummary> hierarchyProposalSummaries) {
        this.hierarchyProposalSummaries = hierarchyProposalSummaries;
    }

    public List<HierarchyProposalSummary> getHierarchyProposalSummaries() {
        return this.hierarchyProposalSummaries;
    }

    public String getOhRateClassCodePrevValue() {
        return this.ohRateClassCodePrevValue;
    }

    public void setOhRateClassCodePrevValue(String ohRateClassCodePrevValue) {
        this.ohRateClassCodePrevValue = ohRateClassCodePrevValue;
    }

    public boolean isDocumentNextValueRefresh() {
        return this.documentNextValueRefresh;
    }

    public void setDocumentNextValueRefresh(boolean documentNextValueRefresh) {
        this.documentNextValueRefresh = documentNextValueRefresh;
    }

    public Integer getViewBudgetPeriod() {
        return this.viewBudgetPeriod;
    }

    public void setViewBudgetPeriod(Integer viewBudgetPeriod) {
        this.viewBudgetPeriod = viewBudgetPeriod;
    }

    public String getViewLocation() {
        return this.viewLocation;
    }

    public void setViewLocation(String viewLocation) {
        this.viewLocation = viewLocation;
    }

    protected String getDefaultDocumentTypeName() {
        return "BudgetDocument";
    }

    public void initialize() {
        Budget budget = this.getBudgetDocument().getBudget();
        BudgetPeriod newBudgetPeriod = budget.getNewBudgetPeriod();
        newBudgetPeriod.setBudget(budget);
        this.setNewBudgetPeriod(newBudgetPeriod);
        this.configureExtraTopButtons();
        this.newBudgetProjectIncome = new BudgetProjectIncome();
        this.newBudgetCostShare = new BudgetCostShare();
        this.newBudgetUnrecoveredFandA = new BudgetUnrecoveredFandA();
        this.newBudgetLineItems = new ArrayList();
        this.newBudgetPersonnelDetails = budget.getNewBudgetPersonnelLineItem();
        this.setDocumentNextValueRefresh(true);
        this.budgetJustificationWrapper = new BudgetJustificationWrapper(this.getBudgetDocument().getBudget().getBudgetJustification());
        this.newSubAward = new BudgetSubAwards();
        this.newBudgetModularIdc = new BudgetModularIdc();
        this.newBudgetFormulatedCost = new BudgetFormulatedCostDetail();
        this.getDocInfo().add(new HeaderField(BUDGET_NAME_KEY, ""));
        this.getDocInfo().add(new HeaderField(VERSION_NUMBER_KEY, ""));
        this.setHierarchyProposalSummaries(new ArrayList());
        Collections.sort(this.getBudgetDocument().getBudget().getBudgetSubAwards());
    }

    public BudgetDocument getBudgetDocument() {
        return (BudgetDocument)this.getDocument();
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        for (Object displayedErrorsKey : this.getDisplayedErrors().keySet()) {
            this.getDisplayedErrors().put(displayedErrorsKey, false);
        }
    }

    public BudgetPeriod getNewBudgetPeriod() {
        return this.newBudgetPeriod;
    }

    public void setNewBudgetPeriod(BudgetPeriod newBudgetPeriod) {
        Integer budgetPeriod = 1;
        Budget budget = this.getBudgetDocument().getBudget();
        if (budget.getBudgetPeriods() != null) {
            budgetPeriod = this.getBudgetDocument().getBudget().getBudgetPeriods().size() + 1;
        }
        newBudgetPeriod.setBudgetPeriod(budgetPeriod);
        newBudgetPeriod.setBudget(budget);
        this.newBudgetPeriod = newBudgetPeriod;
    }

    public List<ExtraButton> getExtraButtons() {
        this.extraButtons.clear();
        String externalImageURL = "kra.externalizable.images.url";
        String generatePeriodImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_generatePeriods.gif";
        String calculatePeriodImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_calculatePeriods.gif";
        String defaultImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_defaultPeriods.gif";
        this.addExtraButton("methodToCall.generateAllPeriods", generatePeriodImage, "Generate All Periods");
        this.addExtraButton("methodToCall.questionCalculateAllPeriods", calculatePeriodImage, "Calculate All Periods");
        this.addExtraButton("methodToCall.defaultPeriods", defaultImage, "Default Periods");
        return this.extraButtons;
    }

    public List<ExtraButton> getExtraPersonnelBudgetButtons() {
        this.extraButtons.clear();
        String externalImageURL = "kra.externalizable.images.url";
        String returnToExpensesImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_returnToExpenses.gif";
        this.addExtraButton("methodToCall.returnToExpenses", returnToExpensesImage, "Return To Expenses");
        String calculateImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_calculate.gif";
        this.addExtraButton("methodToCall.calculateLineItem", calculateImage, "Calculate");
        return this.extraButtons;
    }

    public List<ExtraButton> getExtraExpensesButtons() {
        this.extraButtons.clear();
        String externalImageURL = "kra.externalizable.images.url";
        String calculateCurrentPeriodImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_calculateCurrent2.gif";
        this.addExtraButton("methodToCall.calculateCurrentPeriod", calculateCurrentPeriodImage, "Calculate Current Period");
        return this.extraButtons;
    }

    public List<ExtraButton> getRatesExtraButtons() {
        this.extraButtons.clear();
        String externalImageURL = "kra.externalizable.images.url";
        String syncAllImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_syncallrates.gif";
        String resetAllImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_resetallrates.gif";
        this.addExtraButton("methodToCall.syncAllRates", syncAllImage, "Sync All Rates");
        this.addExtraButton("methodToCall.resetAllRates", resetAllImage, "Reset All Rates");
        return this.extraButtons;
    }

    public List<ExtraButton> getExtraPersonnelButtons() {
        this.extraButtons.clear();
        String externalImageURL = "kra.externalizable.images.url";
        String calculateCurrentPeriodImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_calculateCurrent2.gif";
        this.addExtraButton("methodToCall.calculateCurrentPeriod", calculateCurrentPeriodImage, "Calculate Current Period");
        String viewPersonnelSalariesImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "buttonsmall_viewpersal.gif";
        this.addExtraButton("methodToCall.viewPersonnelSalaries", viewPersonnelSalariesImage, "View Personnel Salaries", "excludeSubmitRestriction=true");
        return this.extraButtons;
    }

    public List<ExtraButton> getExtraTotalsTopButtons() {
        this.extraTopButtons.clear();
        this.extraTopButtons.add(this.configureReturnToParentTopButton());
        ExtraButton customExpandAllButton = new ExtraButton();
        String expandAllImage = this.lookupKualiConfigurationService().getPropertyValueAsString(KR_EXTERNALIZABLE_IMAGES_URI_KEY) + "tinybutton-expandall.gif";
        customExpandAllButton.setExtraButtonProperty("methodToCall.showAllTabs");
        customExpandAllButton.setExtraButtonSource(expandAllImage);
        customExpandAllButton.setExtraButtonAltText("show all panel content");
        customExpandAllButton.setExtraButtonOnclick("javascript: showAllPanels(); return false;");
        ExtraButton customCollapseAllButton = new ExtraButton();
        String hideAllImage = this.lookupKualiConfigurationService().getPropertyValueAsString(KR_EXTERNALIZABLE_IMAGES_URI_KEY) + "tinybutton-collapseall.gif";
        customCollapseAllButton.setExtraButtonProperty("methodToCall.hideAllTabs");
        customCollapseAllButton.setExtraButtonSource(hideAllImage);
        customCollapseAllButton.setExtraButtonAltText("hide all panel content");
        customCollapseAllButton.setExtraButtonOnclick("javascript: expandAll('false', false); return false");
        this.extraTopButtons.add(customExpandAllButton);
        this.extraTopButtons.add(customCollapseAllButton);
        return this.extraTopButtons;
    }

    private ExtraButton configureReturnToParentTopButton() {
        BudgetParentDocument budgetParentDocument = this.getBudgetDocument().getParentDocument();
        return budgetParentDocument != null ? this.getBudgetDocument().getParentDocument().configureReturnToParentTopButton() : new ExtraButton();
    }

    protected void addExtraButton(String property, String source, String altText) {
        this.addExtraButton(property, source, altText, null);
    }

    protected void addExtraButton(String property, String source, String altText, String extraButtonOnclick) {
        ExtraButton newButton = new ExtraButton();
        newButton.setExtraButtonProperty(property);
        newButton.setExtraButtonSource(source);
        newButton.setExtraButtonAltText(altText);
        if (extraButtonOnclick != null) {
            newButton.setExtraButtonOnclick(extraButtonOnclick);
        }
        this.extraButtons.add(newButton);
    }

    public List<ExtraButton> getExtraTopButtons() {
        return this.extraTopButtons;
    }

    public boolean isCostSharingEditFormVisible() {
        BudgetDocument budgetDocument = this.getBudgetDocument();
        Budget budget = budgetDocument != null ? budgetDocument.getBudget() : null;
        return budget != null && budget.isCostSharingApplicable() != false && budget.isCostSharingAvailable();
    }

    public boolean isUnrecoveredFandAEditFormVisible() {
        BudgetDocument budgetDocument = this.getBudgetDocument();
        Budget budget = budgetDocument != null ? budgetDocument.getBudget() : null;
        return budget != null && budget.isUnrecoveredFandAApplicable() != false && budget.isUnrecoveredFandAAvailable();
    }

    public void setExtraTopButtons(List<ExtraButton> extraTopButtons) {
        this.extraTopButtons = extraTopButtons;
    }

    public String getNewBudgetPersons() {
        return this.newBudgetPersons;
    }

    public void setNewBudgetPersons(String newBudgetPersons) {
        this.newBudgetPersons = newBudgetPersons;
    }

    public String getNewBudgetRolodexes() {
        return this.newBudgetRolodexes;
    }

    public BudgetProjectIncome getNewBudgetProjectIncome() {
        return this.newBudgetProjectIncome;
    }

    public Integer getNewBudgetPeriodNumber() {
        return this.newBudgetPeriodNumber;
    }

    public void setNewBudgetPeriodNumber(Integer newBudgetPeriodNo) {
        this.newBudgetPeriodNumber = newBudgetPeriodNo;
    }

    public void setNewBudgetProjectIncome(BudgetProjectIncome newBudgetProjectIncome) {
        this.newBudgetProjectIncome = newBudgetProjectIncome;
    }

    public void setNewBudgetRolodexes(String newBudgetRolodexes) {
        this.newBudgetRolodexes = newBudgetRolodexes;
    }

    public String getNewTbnPersons() {
        return this.newTbnPersons;
    }

    public void setNewTbnPersons(String newTbnPersons) {
        this.newTbnPersons = newTbnPersons;
    }

    public void suppressButtonsForTotalPage() {
        if (this.getDocumentActions().containsKey("canCopy")) {
            this.documentActions.remove("canCopy");
        }
        if (this.getDocumentActions().containsKey("canReload")) {
            this.documentActions.remove("canReload");
        }
    }

    public BudgetCostShare getNewBudgetCostShare() {
        return this.newBudgetCostShare;
    }

    public void setNewBudgetCostShare(BudgetCostShare newBudgetCostShare) {
        this.newBudgetCostShare = newBudgetCostShare;
    }

    public BudgetUnrecoveredFandA getNewBudgetUnrecoveredFandA() {
        return this.newBudgetUnrecoveredFandA;
    }

    public void setNewBudgetUnrecoveredFandA(BudgetUnrecoveredFandA newBudgetUnrecoveredFandA) {
        this.newBudgetUnrecoveredFandA = newBudgetUnrecoveredFandA;
    }

    public Integer getModularSelectedPeriod() {
        return this.modularSelectedPeriod;
    }

    public void setModularSelectedPeriod(Integer modularSelectedPeriod) {
        this.modularSelectedPeriod = modularSelectedPeriod;
    }

    public BudgetModularIdc getNewBudgetModularIdc() {
        return this.newBudgetModularIdc;
    }

    public void setNewBudgetModularIdc(BudgetModularIdc newBudgetModularIdc) {
        this.newBudgetModularIdc = newBudgetModularIdc;
    }

    public BudgetModularSummary getBudgetModularSummary() {
        return this.budgetModularSummary;
    }

    public BudgetJustificationWrapper getBudgetJustification() {
        return this.budgetJustificationWrapper;
    }

    public void setBudgetModularSummary(BudgetModularSummary budgetModularSummary) {
        this.budgetModularSummary = budgetModularSummary;
    }

    public BudgetDecimal getCostSharingAmount() {
        return this.costSharingAmount;
    }

    public void setCostSharingAmount(BudgetDecimal costSharingAmount) {
        this.costSharingAmount = costSharingAmount;
    }

    public Integer getViewBudgetView() {
        return this.viewBudgetView;
    }

    public void setViewBudgetView(Integer viewBudgetView) {
        this.viewBudgetView = viewBudgetView;
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        if ("resetRates".equals(this.getMethodToCall()) || "resetAllRates".equals(this.getMethodToCall())) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            this.getUnconvertedValues().clear();
        }
        if (this.getActionFormUtilMap() != null && this.getActionFormUtilMap() instanceof ActionFormUtilMap) {
            ((ActionFormUtilMap)this.getActionFormUtilMap()).setCacheValueFinderResults(false);
        }
    }

    public List<BudgetLineItem> getNewBudgetLineItems() {
        return this.newBudgetLineItems;
    }

    public void setNewBudgetLineItems(List<BudgetLineItem> newBudgetLineItems) {
        this.newBudgetLineItems = newBudgetLineItems;
    }

    public String getPersonnelBudgetViewMode() {
        return this.personnelBudgetViewMode;
    }

    public void setPersonnelBudgetViewMode(String personnelBudgetViewMode) {
        this.personnelBudgetViewMode = personnelBudgetViewMode;
    }

    public BudgetLineItem getSelectedBudgetLineItem() {
        return this.selectedBudgetLineItem;
    }

    public void setSelectedBudgetLineItem(BudgetLineItem selectedBudgetLineItem) {
        this.selectedBudgetLineItem = selectedBudgetLineItem;
    }

    public BudgetPersonnelDetails getNewBudgetPersonnelDetails() {
        return this.newBudgetPersonnelDetails;
    }

    public void setNewBudgetPersonnelDetails(BudgetPersonnelDetails newBudgetPersonnelDetails) {
        this.newBudgetPersonnelDetails = newBudgetPersonnelDetails;
    }

    public Integer getSelectedBudgetLineItemIndex() {
        return this.selectedBudgetLineItemIndex;
    }

    public void setSelectedBudgetLineItemIndex(Integer selectedBudgetLineItemIndex) {
        this.selectedBudgetLineItemIndex = selectedBudgetLineItemIndex;
    }

    private void configureExtraTopButtons() {
        this.extraTopButtons = new ArrayList();
        this.extraTopButtons.add(this.configureReturnToParentTopButton());
    }

    public List<ExtraButton> getExtraActionsButtons() {
        return new ArrayList<ExtraButton>();
    }

    protected String buildExtraButtonSourceURI(String buttonFileName) {
        return this.lookupKualiConfigurationService().getPropertyValueAsString("kra.externalizable.images.url") + buttonFileName;
    }

    private ConfigurationService lookupKualiConfigurationService() {
        return KRADServiceLocator.getKualiConfigurationService();
    }

    public String getPrevOnOffCampusFlag() {
        return this.prevOnOffCampusFlag;
    }

    public void setPrevOnOffCampusFlag(String prevOnOffCampusFlag) {
        this.prevOnOffCampusFlag = prevOnOffCampusFlag;
    }

    public boolean isUpdateFinalVersion() {
        return this.updateFinalVersion;
    }

    public void setUpdateFinalVersion(boolean updateFinalVersion) {
        this.updateFinalVersion = updateFinalVersion;
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        BudgetDocument budgetDocument = this.getBudgetDocument();
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        WorkflowDocument parentWorkflowDocument = null;
        try {
            if (parentDocument != null) {
                parentWorkflowDocument = parentDocument.getDocumentHeader().getWorkflowDocument();
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            if (parentDocument != null && parentWorkflowDocument == null) {
                Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(parentDocument.getDocumentNumber());
                parentWorkflowDocument = retrievedDocument.getDocumentHeader().getWorkflowDocument();
            }
        }
        catch (WorkflowException e) {
            // empty catch block
        }
        this.getDocInfo().clear();
        this.getDocInfo().add(this.getHeaderDocNumber());
        this.getDocInfo().add(this.getHeaderDocStatus(parentWorkflowDocument));
        this.getDocInfo().add(this.getHeaderDocInitiator(parentWorkflowDocument));
        this.getDocInfo().add(this.getHeaderDocCreateDate(parentWorkflowDocument));
        String budgetName = "";
        String budgetVersionNumber = "";
        if (budgetDocument != null && parentDocument != null) {
            Budget budget = budgetDocument.getBudget();
            List budgetDocumentVersions = parentDocument.getBudgetDocumentVersions();
            for (BudgetDocumentVersion budgetDocumentVersion : budgetDocumentVersions) {
                BudgetVersionOverview budgetVersion = budgetDocumentVersion.getBudgetVersionOverview();
                if (budgetVersion == null || budgetVersion.getBudgetVersionNumber() == null || budgetVersion.getBudgetVersionNumber().intValue() != budget.getBudgetVersionNumber().intValue()) continue;
                budgetName = budgetVersion.getDocumentDescription();
                break;
            }
            if (budget.getBudgetVersionNumber() != null) {
                budgetVersionNumber = Integer.toString(budget.getBudgetVersionNumber());
            }
        }
        this.getDocInfo().add(new HeaderField(BUDGET_NAME_KEY, budgetName));
        this.getDocInfo().add(new HeaderField(VERSION_NUMBER_KEY, budgetVersionNumber));
    }

    protected HeaderField getHeaderDocNumber() {
        BudgetParentDocument parentDocument = this.getBudgetDocument().getParentDocument();
        return new HeaderField("DataDictionary.DocumentHeader.attributes.documentNumber", parentDocument != null ? parentDocument.getDocumentNumber() : null);
    }

    protected HeaderField getHeaderDocStatus(WorkflowDocument parentWorkflowDocument) {
        return new HeaderField("DataDictionary.AttributeReferenceDummy.attributes.workflowDocumentStatus", parentWorkflowDocument != null ? parentWorkflowDocument.getStatus().getLabel() : null);
    }

    protected HeaderField getHeaderDocInitiator(WorkflowDocument parentWorkflowDocument) {
        KcPerson initiator = null;
        if (parentWorkflowDocument != null) {
            initiator = KcPerson.fromPersonId((String)parentWorkflowDocument.getInitiatorPrincipalId());
        }
        return new HeaderField("DataDictionary.AttributeReferenceDummy.attributes.initiatorNetworkId", initiator != null ? initiator.getUserName() : null);
    }

    protected HeaderField getHeaderDocCreateDate(WorkflowDocument parentWorkflowDocument) {
        String createDateStr = null;
        if (parentWorkflowDocument != null && parentWorkflowDocument.getDateCreated() != null) {
            createDateStr = CoreApiServiceLocator.getDateTimeService().toString(parentWorkflowDocument.getDateCreated().toDate(), "hh:mm a MM/dd/yyyy");
        }
        return new HeaderField("DataDictionary.AttributeReferenceDummy.attributes.createDate", createDateStr);
    }

    public String getUrRateClassCodePrevValue() {
        return this.urRateClassCodePrevValue;
    }

    public void setUrRateClassCodePrevValue(String urRateClassCodePrevValue) {
        this.urRateClassCodePrevValue = urRateClassCodePrevValue;
    }

    public String[] getSelectedBudgetPrintFormId() {
        return this.selectedBudgetPrintFormId;
    }

    public void setSelectedBudgetPrintFormId(String[] selectedBudgetPrintFormId) {
        this.selectedBudgetPrintFormId = selectedBudgetPrintFormId;
    }

    public String getSyncBudgetRate() {
        return this.syncBudgetRate;
    }

    public void setSyncBudgetRate(String syncBudgetRate) {
        this.syncBudgetRate = syncBudgetRate;
    }

    public BudgetSubAwards getNewSubAward() {
        return this.newSubAward;
    }

    public void setNewSubAward(BudgetSubAwards newSubAward) {
        this.newSubAward = newSubAward;
    }

    public Integer getPersonnelDetailLine() {
        return this.personnelDetailLine;
    }

    public void setPersonnelDetailLine(Integer personnelDetailLine) {
        this.personnelDetailLine = personnelDetailLine;
    }

    public boolean isSaveAfterCopy() {
        return this.saveAfterCopy;
    }

    public void setSaveAfterCopy(boolean val) {
        this.saveAfterCopy = val;
    }

    public String getNewGroupName() {
        return this.newGroupName;
    }

    public void setNewGroupName(String newGroupName) {
        this.newGroupName = newGroupName;
    }

    public String getActionPrefix() {
        return "budget";
    }

    protected void setSaveDocumentControl(Map editMode) {
        if (this.hasModifyBudgetPermission(editMode) && !this.getDocumentActions().containsKey("canSave")) {
            this.getDocumentActions().put("canSave", "true");
            return;
        }
        if (!this.hasModifyBudgetPermission(editMode) && this.getDocumentActions().containsKey("canSave")) {
            this.getDocumentActions().remove("canSave");
        }
    }

    public boolean toBudgetVersionsPage() {
        return "versions".equals(this.navigateTo) || "BudgetVersionsAction".equals(this.actionName);
    }

    protected String getLockRegion() {
        return "BUDGET";
    }

    public HeaderNavigation[] getHeaderNavigationTabs() {
        HeaderNavigation[] tabs = super.getHeaderNavigationTabs();
        BudgetParentDocument parentDocument = this.getBudgetDocument().getParentDocument();
        boolean hideRatesTab = false;
        boolean hideHierarchyTab = true;
        if (parentDocument != null && parentDocument.getClass() == ProposalDevelopmentDocument.class) {
            boolean bl = hideHierarchyTab = !((ProposalDevelopmentDocument)parentDocument).getDevelopmentProposal().isInHierarchy();
        }
        if (parentDocument instanceof ProposalDevelopmentDocument && ((ProposalDevelopmentDocument)parentDocument).getDevelopmentProposal().isParent()) {
            hideRatesTab = true;
        }
        if (hideRatesTab || hideHierarchyTab) {
            ArrayList<HeaderNavigation> newTabs = new ArrayList<HeaderNavigation>();
            for (HeaderNavigation tab : tabs) {
                if (tab.getHeaderTabNavigateTo().equals("rates") && hideRatesTab || tab.getHeaderTabNavigateTo().equals("hierarchy") && hideHierarchyTab) continue;
                newTabs.add(tab);
            }
            tabs = newTabs.toArray(new HeaderNavigation[newTabs.size()]);
        }
        return tabs;
    }

    public String getProjectPeriodLabel() {
        String label = ((CostShareService)KraServiceLocator.getService(CostShareService.class)).getCostShareLabel();
        return label;
    }

    public boolean getCanModifyBudgetRates() {
        boolean retVal = this.getEditingMode().containsKey("modifyProposalBudgetRates");
        return retVal;
    }

    public void setViewDivBooleanFlag(boolean viewDivBooleanFlag) {
        this.viewDivBooleanFlag = viewDivBooleanFlag;
    }

    public boolean isViewDivBooleanFlag() {
        return this.viewDivBooleanFlag;
    }

    public void setViewDivFlag(boolean viewDivFlag) {
        this.viewDivFlag = viewDivFlag;
    }

    public boolean isViewDivFlag() {
        return this.viewDivFlag;
    }

    public void setPersonIndex(Integer personIndex) {
        this.personIndex = personIndex;
    }

    public Integer getPersonIndex() {
        return this.personIndex;
    }

    public void setEnableBudgetSalaryByPeriod(String enableBudgetSalaryByPeriod) {
        this.enableBudgetSalaryByPeriod = enableBudgetSalaryByPeriod;
    }

    public String getEnableBudgetSalaryByPeriod() {
        return this.enableBudgetSalaryByPeriod;
    }

    public Date getBudgetStartDate() {
        return this.getBudgetDocument().getBudgetStartDate();
    }

    public Date getBudgetEndDate() {
        return this.getBudgetDocument().getBudgetEndDate();
    }

    public BudgetFormulatedCostDetail getNewBudgetFormulatedCost() {
        return this.newBudgetFormulatedCost;
    }

    public void setNewBudgetFormulatedCost(BudgetFormulatedCostDetail newBudgetFormulatedCost) {
        this.newBudgetFormulatedCost = newBudgetFormulatedCost;
    }

    protected ProposalHierarchyService getProposalHierarchyService() {
        if (this.proposalHierarchyService == null) {
            this.proposalHierarchyService = (ProposalHierarchyService)KraServiceLocator.getService(ProposalHierarchyService.class);
        }
        return this.proposalHierarchyService;
    }

    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }

    public boolean isSyncableBudget() throws ProposalHierarchyException {
        BudgetDocument budget = this.getProposalHierarchyService().getSyncableBudget((DevelopmentProposal)this.getBudgetDocument().getParentDocument().getBudgetParent());
        return budget != null && StringUtils.equals((String)budget.getDocumentNumber(), (String)this.getBudgetDocument().getDocumentNumber());
    }
}

