/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.CoiDisclosureForm;
import org.kuali.kra.coi.actions.CoiDisclosureActionService;
import org.kuali.kra.coi.disclosure.CoiDisclosureService;
import org.kuali.kra.coi.disclosure.DisclosureHelper;
import org.kuali.kra.coi.disclosure.MasterDisclosureBean;
import org.kuali.kra.coi.notification.CoiNotification;
import org.kuali.kra.coi.notification.CoiNotificationContext;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.krms.KrmsRulesContext;
import org.kuali.kra.krms.service.KrmsRulesExecutionService;
import org.kuali.kra.rule.event.KraDocumentEventBaseExtension;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.KraTransactionalDocumentActionBase;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;

public abstract class CoiAction
extends KraTransactionalDocumentActionBase {
    protected static final String MASTER_DISCLOSURE = "masterDisclosure";
    protected static final String UPDATE_DISCLOSURE = "updateDisclosure";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        if (coiDisclosureForm.isAuditActivated()) {
            coiDisclosureForm.setUnitRulesMessages(this.getUnitRulesMessages(coiDisclosureForm.getCoiDisclosureDocument()));
        }
        if (KNSGlobalVariables.getAuditErrorMap().isEmpty()) {
            new AuditActionHelper().auditConditionally((KualiDocumentFormBase)coiDisclosureForm);
        }
        return super.execute(mapping, form, request, response);
    }

    public ActionForward disclosure(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        this.prepareDisclosure(coiDisclosureForm);
        return mapping.findForward("disclosure");
    }

    public ActionForward coiDisclosure(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        this.prepareDisclosure(coiDisclosureForm);
        return this.getDisclosureActionForward(coiDisclosureForm, mapping);
    }

    private void prepareDisclosure(CoiDisclosureForm coiDisclosureForm) {
        coiDisclosureForm.getDisclosureHelper().prepareView();
        coiDisclosureForm.getDisclosureQuestionnaireHelper().prepareView(false);
        coiDisclosureForm.getScreeningQuestionnaireHelper().prepareView(false);
        coiDisclosureForm.getCoiNotesAndAttachmentsHelper().prepareView();
    }

    public ActionForward committee(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("committee");
    }

    public ActionForward certification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("certification");
    }

    public ActionForward noteAndAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((CoiDisclosureForm)form).getCoiNotesAndAttachmentsHelper().prepareView();
        return mapping.findForward("noteAndAttachment");
    }

    public ActionForward disclosureActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("disclosureActions");
    }

    protected CoiDisclosureService getCoiDisclosureService() {
        return (CoiDisclosureService)KraServiceLocator.getService(CoiDisclosureService.class);
    }

    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    protected CoiDisclosureActionService getCoiDisclosureActionService() {
        return (CoiDisclosureActionService)KraServiceLocator.getService(CoiDisclosureActionService.class);
    }

    protected boolean checkRule(KraDocumentEventBaseExtension event) {
        return event.getRule().processRules(event);
    }

    public void postSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForward forward, CoiDisclosureForm coiDisclosureForm, CoiNotificationContext context) {
        if (coiDisclosureForm.getNotificationHelper().getPromptUserForNotificationEditor((NotificationContext)context)) {
            coiDisclosureForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
            forward = mapping.findForward("coiDisclosureNotificationEditor");
        } else {
            this.getNotificationService().sendNotificationAndPersist((NotificationContext)context, (KcNotification)new CoiNotification(), (KraPersistableBusinessObjectBase)coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure());
        }
        return forward;
    }

    protected KcNotificationService getNotificationService() {
        return (KcNotificationService)KraServiceLocator.getService(KcNotificationService.class);
    }

    protected final boolean applyRules(KualiDocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    protected List<String> getUnitRulesMessages(CoiDisclosureDocument coiDisclosureDoc) {
        KrmsRulesExecutionService rulesService = (KrmsRulesExecutionService)KraServiceLocator.getService(KrmsRulesExecutionService.class);
        return rulesService.processUnitValidations(coiDisclosureDoc.getCoiDisclosure().getLeadUnitNumber(), (KrmsRulesContext)coiDisclosureDoc);
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        coiDisclosureForm.setUnitRulesMessages(this.getUnitRulesMessages(coiDisclosureForm.getCoiDisclosureDocument()));
        new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)coiDisclosureForm, true);
        return this.getDisclosureActionForward(coiDisclosureForm, mapping);
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        coiDisclosureForm.clearUnitRulesMessages();
        new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)coiDisclosureForm, false);
        return this.getDisclosureActionForward(coiDisclosureForm, mapping);
    }

    protected ActionForward getDisclosureActionForward(CoiDisclosureForm coiDisclosureForm, ActionMapping mapping) {
        ActionForward actionForward = mapping.findForward("basic");
        CoiDisclosure coiDisclosure = coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure();
        if (coiDisclosure.isUpdateEvent() || coiDisclosure.isAnnualEvent() && coiDisclosure.isAnnualUpdate()) {
            actionForward = mapping.findForward(UPDATE_DISCLOSURE);
        }
        return actionForward;
    }

    public ActionForward viewProjectDisclosuresByFinancialEntity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        DisclosureHelper disclosureHelper = coiDisclosureForm.getDisclosureHelper();
        CoiDisclosure coiDisclosure = coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure();
        MasterDisclosureBean masterDisclosureBean = disclosureHelper.getMasterDisclosureBean();
        this.getCoiDisclosureService().createDisclosuresGroupedByFinancialEntity(coiDisclosure, masterDisclosureBean);
        return mapping.findForward("basic");
    }

    public ActionForward viewProjectDisclosuresByEvent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        DisclosureHelper disclosureHelper = coiDisclosureForm.getDisclosureHelper();
        MasterDisclosureBean masterDisclosureBean = disclosureHelper.getMasterDisclosureBean();
        this.getCoiDisclosureService().createDisclosuresGroupedByEvent(masterDisclosureBean);
        return mapping.findForward("basic");
    }

    public ActionForward viewUndisclosedProjectsByFinancialEntity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setUndisclosedProjects(false, form);
        return mapping.findForward("basic");
    }

    public ActionForward viewUndisclosedProjectsByEvent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setUndisclosedProjects(true, form);
        return mapping.findForward("basic");
    }

    private void setUndisclosedProjects(boolean isGroupedByEvent, ActionForm form) {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        coiDisclosureForm.getDisclosureHelper().setDisclosureGroupedByEvent(isGroupedByEvent);
        List groupedUndisclosedProjects = new ArrayList();
        groupedUndisclosedProjects = isGroupedByEvent ? this.getCoiDisclosureService().getUndisclosedProjectsGroupedByEvent(this.getCoiDisclosureProjects(coiDisclosureForm)) : this.getCoiDisclosureService().getUndisclosedProjectsGroupedByFinancialEntity(this.getCoiDisclosureProjects(coiDisclosureForm));
        coiDisclosureForm.getDisclosureHelper().setAllDisclosuresGroupedByProjects(groupedUndisclosedProjects);
    }

    protected List<CoiDisclProject> getCoiDisclosureProjects(CoiDisclosureForm coiDisclosureForm) {
        CoiDisclosureDocument coiDisclosureDocument = (CoiDisclosureDocument)coiDisclosureForm.getDocument();
        CoiDisclosure coiDisclosure = coiDisclosureDocument.getCoiDisclosure();
        return coiDisclosure.getCoiDisclProjects();
    }
}

