/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.coi.CoiDiscDetail;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureEventType;
import org.kuali.kra.coi.CoiDispositionStatus;
import org.kuali.kra.coi.Disclosurable;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.protocol.IacucProtocolType;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.protocol.ProtocolType;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalType;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;

public class CoiDisclProject
extends KraPersistableBusinessObjectBase
implements Disclosurable {
    private static final long serialVersionUID = -870946478393121916L;
    private Long coiDisclProjectsId;
    private Long coiDisclosureId;
    private String coiDisclosureNumber;
    private Integer sequenceNumber;
    private String coiProjectId;
    private String coiProjectTitle;
    private String moduleItemKey;
    private String shortTextField1;
    private String longTextField1;
    private String shortTextField2;
    private String disclosureEventType;
    private String longTextField2;
    private Date dateField1;
    private Date dateField2;
    private KualiDecimal numberField1;
    private KualiDecimal numberField2;
    private String shortTextField3;
    private String longTextField3;
    private String selectBox1;
    private Integer disclosureDispositionCode;
    private String disclosureStatusCode;
    private ProposalType proposalType;
    private ProtocolType protocolType;
    private IacucProtocolType iacucProtocolType;
    private Protocol protocol;
    private IacucProtocol iacucProtocol;
    private DevelopmentProposal proposal;
    private InstitutionalProposal institutionalProposal;
    private Award award;
    private CoiDisclosureEventType coiDisclosureEventType;
    private Long originalCoiDisclosureId;
    private CoiDisclosure originalCoiDisclosure;
    @SkipVersioning
    private CoiDisclosure coiDisclosure;
    @SkipVersioning
    private List<CoiDiscDetail> coiDiscDetails;
    @SkipVersioning
    private transient List<LabelValuePair> headerItems;
    @SkipVersioning
    private CoiDispositionStatus coiDispositionStatus;

    public CoiDisclProject(String coiDisclosureNumber, Integer sequenceNumber) {
        this.coiDisclosureNumber = coiDisclosureNumber;
        this.sequenceNumber = sequenceNumber;
        this.headerItems = new ArrayList();
    }

    public CoiDisclProject() {
        this.headerItems = new ArrayList();
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getCoiDiscDetails());
        return managedLists;
    }

    public Long getCoiDisclProjectsId() {
        return this.coiDisclProjectsId;
    }

    public void setCoiDisclProjectsId(Long coiDisclProjectsId) {
        this.coiDisclProjectsId = coiDisclProjectsId;
    }

    public Long getCoiDisclosureId() {
        return this.coiDisclosureId;
    }

    public void setCoiDisclosureId(Long coiDisclosureId) {
        this.coiDisclosureId = coiDisclosureId;
    }

    public String getCoiDisclosureNumber() {
        return this.coiDisclosureNumber;
    }

    public void setCoiDisclosureNumber(String coiDisclosureNumber) {
        this.coiDisclosureNumber = coiDisclosureNumber;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getCoiProjectId() {
        return this.coiProjectId;
    }

    public void setCoiProjectId(String coiProjectId) {
        this.coiProjectId = coiProjectId;
    }

    public String getCoiProjectTitle() {
        return this.coiProjectTitle;
    }

    public void setCoiProjectTitle(String coiProjectTitle) {
        this.coiProjectTitle = coiProjectTitle;
    }

    public String getModuleItemKey() {
        return this.moduleItemKey;
    }

    public void setModuleItemKey(String moduleItemKey) {
        this.moduleItemKey = moduleItemKey;
    }

    public CoiDisclosure getCoiDisclosure() {
        return this.coiDisclosure;
    }

    public void setCoiDisclosure(CoiDisclosure coiDisclosure) {
        this.coiDisclosure = coiDisclosure;
    }

    public ProposalType getProposalType() {
        return this.proposalType;
    }

    public void setProposalType(ProposalType proposalType) {
        this.proposalType = proposalType;
    }

    public List<CoiDiscDetail> getCoiDiscDetails() {
        return this.coiDiscDetails;
    }

    public void setCoiDiscDetails(List<CoiDiscDetail> coiDiscDetails) {
        this.coiDiscDetails = coiDiscDetails;
    }

    public String getDisclosureEventType() {
        return this.disclosureEventType;
    }

    public void setDisclosureEventType(String disclosureEventType) {
        this.disclosureEventType = disclosureEventType;
    }

    public String getShortTextField1() {
        return this.shortTextField1;
    }

    public void setShortTextField1(String shortTextField1) {
        this.shortTextField1 = shortTextField1;
    }

    public String getLongTextField1() {
        return this.longTextField1;
    }

    public void setLongTextField1(String longTextField1) {
        this.longTextField1 = longTextField1;
    }

    public String getShortTextField2() {
        return this.shortTextField2;
    }

    public void setShortTextField2(String shortTextField2) {
        this.shortTextField2 = shortTextField2;
    }

    public String getLongTextField2() {
        return this.longTextField2;
    }

    public void setLongTextField2(String longTextField2) {
        this.longTextField2 = longTextField2;
    }

    public Date getDateField1() {
        return this.dateField1;
    }

    public void setDateField1(Date dateField1) {
        this.dateField1 = dateField1;
    }

    public Date getDateField2() {
        return this.dateField2;
    }

    public void setDateField2(Date dateField2) {
        this.dateField2 = dateField2;
    }

    public KualiDecimal getNumberField1() {
        return this.numberField1;
    }

    public void setNumberField1(KualiDecimal numberField1) {
        this.numberField1 = numberField1;
    }

    public KualiDecimal getNumberField2() {
        return this.numberField2;
    }

    public void setNumberField2(KualiDecimal numberField2) {
        this.numberField2 = numberField2;
    }

    public String getShortTextField3() {
        return this.shortTextField3;
    }

    public void setShortTextField3(String shortTextField3) {
        this.shortTextField3 = shortTextField3;
    }

    public String getLongTextField3() {
        return this.longTextField3;
    }

    public void setLongTextField3(String longTextField3) {
        this.longTextField3 = longTextField3;
    }

    public String getSelectBox1() {
        return this.selectBox1;
    }

    public void setSelectBox1(String selectBox1) {
        this.selectBox1 = selectBox1;
    }

    public String getProjectIdLabel() {
        String label = "Project Id";
        if (this.isAwardEvent()) {
            label = "Award Number";
        } else if (this.isProtocolEvent()) {
            label = "Protocol Number";
        } else if (this.isIacucProtocolEvent()) {
            label = "IACUC Protocol Number";
        } else if (this.isProposalEvent()) {
            label = "Proposal Number";
        }
        return label;
    }

    public String getProjectTitleLabel() {
        String label = "Project Title";
        if (this.isAwardEvent()) {
            label = "Award Title";
        } else if (this.isProtocolEvent() || this.isIacucProtocolEvent()) {
            label = "Protocol Name";
        }
        return label;
    }

    public String getProjectTypeLabel() {
        String label = "Project Type";
        if (this.isProtocolEvent() || this.isIacucProtocolEvent()) {
            label = "Protocol type";
        }
        return label;
    }

    public String getProjectStartDateLabel() {
        String label = "Project Start Date";
        if (this.isAwardEvent()) {
            label = "Award Date";
        }
        return label;
    }

    public String getEventDescription() {
        String description = "Proposal";
        if (this.isAwardEvent() || this.isManualAwardEvent()) {
            description = "Award";
        } else if (this.isProtocolEvent() || this.isManualProtocolEvent()) {
            description = "Protocol";
        } else if (this.isIacucProtocolEvent() || this.isManualIacucProtocolEvent()) {
            description = "IACUC Protocol";
        } else if (this.isManualTravelEvent()) {
            description = "Travel";
        }
        return description;
    }

    public ProtocolType getProtocolType() {
        if (StringUtils.isNotBlank((String)this.selectBox1) && this.protocolType == null) {
            this.refreshReferenceObject("protocolType");
        }
        return this.protocolType;
    }

    public void setProtocolType(ProtocolType protocolType) {
        this.protocolType = protocolType;
    }

    public IacucProtocolType getIacucProtocolType() {
        if (StringUtils.isNotBlank((String)this.selectBox1) && this.protocolType == null) {
            this.refreshReferenceObject("iacucProtocolType");
        }
        return this.iacucProtocolType;
    }

    public void setIacucProtocolType(IacucProtocolType iacucProtocolType) {
        this.iacucProtocolType = iacucProtocolType;
    }

    public String getCompleteMessage() {
        int completeCount = 0;
        if (CollectionUtils.isNotEmpty((Collection)this.getCoiDiscDetails())) {
            for (CoiDiscDetail coiDiscDetail : this.getCoiDiscDetails()) {
                if (coiDiscDetail.getEntityDispositionCode() == null || coiDiscDetail.getEntityDispositionCode() <= 0) continue;
                ++completeCount;
            }
        }
        return completeCount + "/" + this.getCoiDiscDetails().size() + " Reviews Complete";
    }

    public boolean isComplete() {
        boolean isComplete = true;
        if (CollectionUtils.isNotEmpty((Collection)this.getCoiDiscDetails())) {
            for (CoiDiscDetail coiDiscDetail : this.getCoiDiscDetails()) {
                if (coiDiscDetail.getEntityDispositionCode() != null && coiDiscDetail.getEntityDispositionCode() != 0) continue;
                isComplete = false;
                break;
            }
        }
        return isComplete;
    }

    public String getProjectName() {
        return this.getCoiProjectTitle();
    }

    public String getProjectId() {
        return this.getCoiProjectId();
    }

    public boolean isProposalEvent() {
        return StringUtils.equals((String)"2", (String)this.disclosureEventType);
    }

    public boolean isInstitutionalProposalEvent() {
        return StringUtils.equals((String)"10", (String)this.disclosureEventType);
    }

    public boolean isAwardEvent() {
        return StringUtils.equals((String)"1", (String)this.disclosureEventType);
    }

    public boolean isProtocolEvent() {
        return StringUtils.equals((String)"3", (String)this.disclosureEventType);
    }

    public boolean isIacucProtocolEvent() {
        return StringUtils.equals((String)"4", (String)this.disclosureEventType);
    }

    public boolean isManualProposalEvent() {
        return StringUtils.equals((String)"12", (String)this.disclosureEventType);
    }

    public boolean isManualAwardEvent() {
        return StringUtils.equals((String)"11", (String)this.disclosureEventType);
    }

    public boolean isManualProtocolEvent() {
        return StringUtils.equals((String)"13", (String)this.disclosureEventType);
    }

    public boolean isManualIacucProtocolEvent() {
        return StringUtils.equals((String)"16", (String)this.disclosureEventType);
    }

    public boolean isManualTravelEvent() {
        return StringUtils.equals((String)"15", (String)this.disclosureEventType);
    }

    public boolean isManualEvent() {
        return this.isManualAwardEvent() || this.isManualProposalEvent() || this.isManualProtocolEvent() || this.isManualIacucProtocolEvent() || this.isManualTravelEvent();
    }

    public Protocol getProtocol() {
        if (this.protocol == null) {
            this.refreshReferenceObject("protocol");
        }
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public IacucProtocol getIacucProtocol() {
        if (this.iacucProtocol == null) {
            this.refreshReferenceObject("iacucProtocol");
        }
        return this.iacucProtocol;
    }

    public void setIacucProtocol(IacucProtocol iacucProtocol) {
        this.iacucProtocol = iacucProtocol;
    }

    public DevelopmentProposal getProposal() {
        if (this.proposal == null) {
            this.refreshReferenceObject("proposal");
        }
        return this.proposal;
    }

    public void setProposal(DevelopmentProposal proposal) {
        this.proposal = proposal;
    }

    public Award getAward() {
        if (this.award == null) {
            this.refreshReferenceObject("award");
        }
        return this.award;
    }

    public void setAward(Award award) {
        this.award = award;
    }

    public CoiDisclosureEventType getCoiDisclosureEventType() {
        return this.coiDisclosureEventType;
    }

    public void setCoiDisclosureEventType(CoiDisclosureEventType coiDisclosureEventType) {
        this.coiDisclosureEventType = coiDisclosureEventType;
    }

    public InstitutionalProposal getInstitutionalProposal() {
        if (this.institutionalProposal == null) {
            this.refreshReferenceObject("institutionalProposal");
        }
        return this.institutionalProposal;
    }

    public void setInstitutionalProposal(InstitutionalProposal institutionalProposal) {
        this.institutionalProposal = institutionalProposal;
    }

    public List<LabelValuePair> getHeaderItems() {
        if (this.headerItems == null && this.coiProjectId != null) {
            this.initHeaderItems();
        }
        return this.headerItems;
    }

    public void setHeaderItems(List<LabelValuePair> headerItems) {
        this.headerItems = headerItems;
    }

    public void initHeaderItems() {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyyy");
        this.headerItems = new ArrayList();
        if (this.coiDisclosureEventType == null) {
            this.refreshReferenceObject("coiDisclosureEventType");
        }
        this.headerItems.add(new LabelValuePair(this, this.coiDisclosureEventType.getProjectTitleLabel(), this.coiProjectTitle));
        if (this.coiDisclosureEventType.isUseSelectBox1()) {
            this.headerItems.add(new LabelValuePair(this, this.coiDisclosureEventType.getSelectBox1Label(), this.getSelectDesc()));
        }
        if (this.coiDisclosureEventType.isUseLongTextField1()) {
            this.headerItems.add(new LabelValuePair(this, this.coiDisclosureEventType.getLongTextField1Label(), this.longTextField1));
        }
        if (this.coiDisclosureEventType.isUseShortTextField1()) {
            this.headerItems.add(new LabelValuePair(this, this.coiDisclosureEventType.getShortTextField1Label(), this.shortTextField1));
        }
        if (this.coiDisclosureEventType.isUseLongTextField2()) {
            this.headerItems.add(new LabelValuePair(this, this.coiDisclosureEventType.getLongTextField2Label(), this.longTextField2));
        }
        if (this.coiDisclosureEventType.isUseShortTextField2()) {
            this.headerItems.add(new LabelValuePair(this, this.coiDisclosureEventType.getShortTextField2Label(), this.shortTextField2));
        }
        if (this.coiDisclosureEventType.isUseLongTextField3()) {
            this.headerItems.add(new LabelValuePair(this, this.coiDisclosureEventType.getLongTextField3Label(), this.longTextField3));
        }
        if (this.coiDisclosureEventType.isUseShortTextField3()) {
            this.headerItems.add(new LabelValuePair(this, this.coiDisclosureEventType.getShortTextField3Label(), this.shortTextField3));
        }
        if (this.coiDisclosureEventType.isUseNumberField1()) {
            this.headerItems.add(new LabelValuePair(this, this.coiDisclosureEventType.getNumberField1Label(), this.numberField1 == null ? "" : this.numberField1.toString()));
        }
        if (this.coiDisclosureEventType.isUseNumberField2()) {
            this.headerItems.add(new LabelValuePair(this, this.coiDisclosureEventType.getNumberField2Label(), this.numberField2 == null ? "" : this.numberField2.toString()));
        }
        if (this.coiDisclosureEventType.isUseDateField1()) {
            this.headerItems.add(new LabelValuePair(this, this.coiDisclosureEventType.getDateField1Label(), this.dateField1 == null ? "" : df.format(this.dateField1)));
        }
        if (this.coiDisclosureEventType.isUseDateField2()) {
            this.headerItems.add(new LabelValuePair(this, this.coiDisclosureEventType.getDateField2Label(), this.dateField2 == null ? "" : df.format(this.dateField2)));
        }
    }

    private String getSelectDesc() {
        String description = "";
        try {
            Class<?> valuesFinderClass;
            KeyValuesFinder keyValuesFinder;
            List keyValues;
            String valuesFinder = this.coiDisclosureEventType.getSelectBox1ValuesFinder();
            if (StringUtils.isNotBlank((String)valuesFinder) && !CollectionUtils.isEmpty((Collection)(keyValues = (keyValuesFinder = (KeyValuesFinder)(valuesFinderClass = Class.forName(valuesFinder)).newInstance()).getKeyValues()))) {
                for (KeyValue keyValue : keyValues) {
                    if (!keyValue.getKey().equals(this.selectBox1)) continue;
                    description = keyValue.getValue();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return description;
    }

    public Long getOriginalCoiDisclosureId() {
        return this.originalCoiDisclosureId;
    }

    public void setOriginalCoiDisclosureId(Long originalCoiDisclosureId) {
        this.originalCoiDisclosureId = originalCoiDisclosureId;
    }

    public Integer getDisclosureDispositionCode() {
        return this.disclosureDispositionCode;
    }

    public void setDisclosureDispositionCode(Integer disclosureDispositionCode) {
        this.disclosureDispositionCode = disclosureDispositionCode;
    }

    public void setDisclosureDispositionCode(String disclosureDispositionCode) {
        this.disclosureDispositionCode = Integer.valueOf(disclosureDispositionCode);
    }

    public String getDisclosureStatusCode() {
        return this.disclosureStatusCode;
    }

    public void setDisclosureStatusCode(String disclosureStatusCode) {
        this.disclosureStatusCode = disclosureStatusCode;
    }

    public void setCoiDispositionStatus(CoiDispositionStatus coiDispositionStatus) {
        this.coiDispositionStatus = coiDispositionStatus;
    }

    public CoiDispositionStatus getCoiDispositionStatus() {
        if (!(this.disclosureDispositionCode == null || this.coiDispositionStatus != null && StringUtils.equals((String)this.coiDispositionStatus.getCoiDispositionCode(), (String)this.disclosureDispositionCode.toString()))) {
            this.refreshReferenceObject("coiDispositionStatus");
        }
        return this.coiDispositionStatus;
    }

    public CoiDisclosure getOriginalCoiDisclosure() {
        if (this.originalCoiDisclosureId != null && this.originalCoiDisclosure == null) {
            this.refreshReferenceObject("originalCoiDisclosure");
        }
        return this.originalCoiDisclosure;
    }

    public void setOriginalCoiDisclosure(CoiDisclosure originalCoiDisclosure) {
        this.originalCoiDisclosure = originalCoiDisclosure;
    }
}

