/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.coi.CoiDiscDetail;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.CoiDisclosureEventType;
import org.kuali.kra.coi.CoiDisclosureStatus;
import org.kuali.kra.coi.CoiDispositionStatus;
import org.kuali.kra.coi.CoiReviewStatus;
import org.kuali.kra.coi.CoiUserRole;
import org.kuali.kra.coi.disclosure.CoiDisclosureService;
import org.kuali.kra.coi.disclosure.DisclosurePerson;
import org.kuali.kra.coi.disclosure.DisclosurePersonUnit;
import org.kuali.kra.coi.notesandattachments.attachments.CoiDisclosureAttachment;
import org.kuali.kra.coi.notesandattachments.attachments.CoiDisclosureAttachmentFilter;
import org.kuali.kra.coi.notesandattachments.notes.CoiDisclosureNotepad;
import org.kuali.kra.coi.notification.CoiNotification;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.util.DateUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class CoiDisclosure
extends KraPersistableBusinessObjectBase
implements SequenceOwner<CoiDisclosure>,
Permissionable {
    private static final long serialVersionUID = 1056040995591476518L;
    public static final String MANUAL_DISCL_MODULE_CODE = "14";
    public static final String PROPOSAL_DISCL_MODULE_CODE = "11";
    public static final String INSTITUTIONAL_PROPOSAL_DISCL_MODULE_CODE = "15";
    public static final String PROTOCOL_DISCL_MODULE_CODE = "12";
    public static final String AWARD_DISCL_MODULE_CODE = "1";
    public static final String ANNUAL_DISCL_MODULE_CODE = "13";
    public static final String CERTIFIED = "certified";
    private Long coiDisclosureId;
    private String coiDisclosureNumber;
    private Integer sequenceNumber;
    private String personId;
    private String certificationText;
    private String certifiedBy;
    private Timestamp certificationTimestamp;
    private String disclosureDispositionCode;
    private String disclosureStatusCode;
    private Date expirationDate;
    private boolean currentDisclosure;
    private boolean annualUpdate;
    private String eventTypeCode;
    private String moduleItemKey;
    private Integer discActiveStatus;
    private CoiDisclosureDocument coiDisclosureDocument;
    private List<DisclosurePerson> disclosurePersons;
    private List<CoiDisclosureAttachment> coiDisclosureAttachments;
    private List<CoiDisclosureNotepad> coiDisclosureNotepads;
    private transient ParameterService parameterService;
    private transient boolean certifiedFlag;
    private static final String DISCLOSURE_CERT_STMT = "COI_CERTIFICATION_STATEMENT";
    private static final String DISCLOSURE_CERT_ACK = "COI_CERTIFICATION_ACKNOWLEDGEMENT";
    private static final String SUBMIT_ACK_THANKYOU = "message.disclosure.submit.thankyou";
    private transient String certificationStatement;
    private transient String acknowledgementStatement;
    private static String submitThankyouStatement = null;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy");
    private CoiDisclosureStatus coiDisclosureStatus;
    private CoiDispositionStatus coiDispositionStatus;
    private CoiDisclosureEventType coiDisclosureEventType;
    private transient String coiDisclProjectId;
    private transient String coiDisclProjectTitle;
    @SkipVersioning
    private List<CoiDisclProject> coiDisclProjects;
    private List<CoiUserRole> coiUserRoles;
    private transient DateTimeService dateTimeService;
    private CoiDisclosureAttachmentFilter newAttachmentFilter;
    private KraPersistableBusinessObjectBase eventBo;
    private transient String reporterCreated;
    private transient KcPersonService kcPersonService;
    private transient BusinessObjectService businessObjectService;
    List<CoiNotification> disclosureNotifications;
    private String reviewStatusCode;
    private CoiReviewStatus coiReviewStatus;
    private transient String disclosureStatusReviewStatus;

    public CoiDisclosure() {
        this.setSequenceNumber(Integer.valueOf(1));
        this.initCoiDisclosureNumber();
        this.getDisclosureReporter();
        this.initializeCoiAttachmentFilter();
        this.coiUserRoles = new ArrayList();
        this.initializeCoiReviewStatus();
    }

    public KcPerson getPerson() {
        if (this.personId != null) {
            return this.getKcPersonService().getKcPersonByPersonId(this.personId);
        }
        return new KcPerson();
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public List<CoiDisclosureNotepad> getCoiDisclosureNotepads() {
        if (this.coiDisclosureNotepads == null) {
            this.coiDisclosureNotepads = new ArrayList();
        }
        Collections.sort(this.coiDisclosureNotepads, Collections.reverseOrder());
        return this.coiDisclosureNotepads;
    }

    public void setCoiDisclosureNotepads(List<CoiDisclosureNotepad> coiDisclosureNotepads) {
        this.coiDisclosureNotepads = coiDisclosureNotepads;
    }

    public Long getCoiDisclosureId() {
        return this.coiDisclosureId;
    }

    public void setCoiDisclosureId(Long coiDisclosureId) {
        this.coiDisclosureId = coiDisclosureId;
    }

    public String getCoiDisclosureNumber() {
        return this.coiDisclosureNumber;
    }

    public void setCoiDisclosureNumber(String coiDisclosureNumber) {
        this.coiDisclosureNumber = coiDisclosureNumber;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getCertificationText() {
        return this.certificationText;
    }

    public void setCertificationText(String certificationText) {
        this.certificationText = certificationText;
    }

    public String getCertifiedBy() {
        return this.certifiedBy;
    }

    public void setCertifiedBy(String certifiedBy) {
        this.certifiedBy = certifiedBy;
    }

    public Timestamp getCertificationTimestamp() {
        return this.certificationTimestamp;
    }

    public String getCertificationTimestampString() {
        if (this.getCertificationTimestamp() == null) {
            return null;
        }
        return this.dateFormatter.format(this.getCertificationTimestamp());
    }

    public void setCertificationTimestamp(Timestamp certificationTimestamp) {
        this.certificationTimestamp = certificationTimestamp;
    }

    public void certifyDisclosure() {
        this.certifiedFlag = true;
        this.setCertificationTimestamp(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        this.setCertificationText(new String(this.acknowledgementStatement));
        this.setCertifiedBy(GlobalVariables.getUserSession().getPrincipalName());
    }

    public String getDisclosureDispositionCode() {
        return this.disclosureDispositionCode;
    }

    public void setDisclosureDispositionCode(String disclosureDispositionCode) {
        this.disclosureDispositionCode = disclosureDispositionCode;
    }

    public String getDisclosureStatusCode() {
        return this.disclosureStatusCode;
    }

    public void setDisclosureStatusCode(String disclosureStatusCode) {
        this.disclosureStatusCode = disclosureStatusCode;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Integer getDiscActiveStatus() {
        return this.discActiveStatus;
    }

    public void setDiscActiveStatus(Integer discActiveStatus) {
        this.discActiveStatus = discActiveStatus;
    }

    public CoiDisclosureDocument getCoiDisclosureDocument() {
        return this.coiDisclosureDocument;
    }

    public void setCoiDisclosureDocument(CoiDisclosureDocument coiDisclosureDocument) {
        this.coiDisclosureDocument = coiDisclosureDocument;
    }

    public List<DisclosurePerson> getDisclosurePersons() {
        return this.disclosurePersons;
    }

    public void setDisclosurePersons(List<DisclosurePerson> disclosurePersons) {
        this.disclosurePersons = disclosurePersons;
    }

    public DisclosurePerson getDisclosureReporter() {
        if (CollectionUtils.isEmpty((Collection)this.disclosurePersons)) {
            this.disclosurePersons = new ArrayList();
            this.disclosurePersons.add(this.getCoiDisclosureService().getDisclosureReporter(GlobalVariables.getUserSession().getPrincipalId(), this.getCoiDisclosureId()));
        }
        return (DisclosurePerson)this.disclosurePersons.get(0);
    }

    public void initSelectedUnit() {
        int i = 0;
        for (DisclosurePersonUnit disclosurePersonUnit : ((DisclosurePerson)this.disclosurePersons.get(0)).getDisclosurePersonUnits()) {
            if (disclosurePersonUnit.isLeadUnitFlag()) {
                ((DisclosurePerson)this.disclosurePersons.get(0)).setSelectedUnit(i);
                break;
            }
            ++i;
        }
    }

    public String getLeadUnitNumber() {
        for (DisclosurePersonUnit disclosurePersonUnit : ((DisclosurePerson)this.disclosurePersons.get(0)).getDisclosurePersonUnits()) {
            if (!disclosurePersonUnit.isLeadUnitFlag()) continue;
            return disclosurePersonUnit.getUnitNumber();
        }
        return null;
    }

    private CoiDisclosureService getCoiDisclosureService() {
        return (CoiDisclosureService)KraServiceLocator.getService(CoiDisclosureService.class);
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        ArrayList disclosurePersonUnits = new ArrayList();
        for (DisclosurePerson disclosurePerson : this.getDisclosurePersons()) {
            disclosurePersonUnits.addAll(disclosurePerson.getDisclosurePersonUnits());
        }
        managedLists.add(disclosurePersonUnits);
        managedLists.add(this.getDisclosurePersons());
        managedLists.add(this.getCoiUserRoles());
        managedLists.add(this.getCoiDisclosureAttachments());
        managedLists.add(this.getCoiDisclosureNotepads());
        ArrayList details = new ArrayList();
        for (CoiDisclProject coiDisclProject : this.getCoiDisclProjects()) {
            details.addAll(coiDisclProject.getCoiDiscDetails());
        }
        managedLists.add(details);
        managedLists.add(this.getCoiDisclProjects());
        return managedLists;
    }

    public void initRequiredFields() {
        this.setDisclosureDispositionCode("100");
        this.setDisclosureStatusCode(AWARD_DISCL_MODULE_CODE);
        this.setReviewStatusCode(AWARD_DISCL_MODULE_CODE);
        this.setPersonId(this.getDisclosureReporter().getPersonId());
        this.initCoiDisclosureNumber();
        this.setExpirationDate(new Date(DateUtils.addDays((java.util.Date)new Date(System.currentTimeMillis()), (int)365).getTime()));
    }

    public void initCoiDisclosureNumber() {
        if (StringUtils.isBlank((String)this.getCoiDisclosureNumber())) {
            Long nextNumber = ((SequenceAccessorService)KraServiceLocator.getService(SequenceAccessorService.class)).getNextAvailableSequenceNumber("SEQ_COI_DISCL_NUMBER");
            this.setCoiDisclosureNumber(nextNumber.toString());
        }
    }

    public boolean getCertifiedFlag() {
        return this.certifiedFlag;
    }

    public void setCertifiedFlag(boolean certifiedFlag) {
        this.certifiedFlag = certifiedFlag;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public String getCertificationStatement() {
        if (this.certificationStatement == null) {
            this.certificationStatement = this.getParameterService().getParameterValueAsString("KC-COIDISCLOSURE", "Document", DISCLOSURE_CERT_STMT);
        }
        return this.certificationStatement;
    }

    public String getAcknowledgementStatement() {
        if (this.acknowledgementStatement == null) {
            this.acknowledgementStatement = this.getParameterService().getParameterValueAsString("KC-COIDISCLOSURE", "Document", DISCLOSURE_CERT_ACK);
        }
        return this.acknowledgementStatement;
    }

    public List<CoiDisclProject> getCoiDisclProjects() {
        if (this.coiDisclProjects == null) {
            this.coiDisclProjects = new ArrayList();
        }
        return this.coiDisclProjects;
    }

    public void setCoiDisclProjects(List<CoiDisclProject> coiDisclProjects) {
        this.coiDisclProjects = coiDisclProjects;
    }

    public String getSubmitThankyouStatement() {
        if (submitThankyouStatement == null) {
            ConfigurationService kualiConfiguration = KRADServiceLocator.getKualiConfigurationService();
            submitThankyouStatement = kualiConfiguration.getPropertyValueAsString(SUBMIT_ACK_THANKYOU);
        }
        return submitThankyouStatement;
    }

    public boolean isProposalEvent() {
        return StringUtils.equals((String)"2", (String)this.getEventTypeCode());
    }

    public boolean isInstitutionalProposalEvent() {
        return StringUtils.equals((String)"10", (String)this.getEventTypeCode());
    }

    public boolean isNonManualProjectEvent() {
        return this.isAwardEvent() || this.isProposalEvent() || this.isProtocolEvent() || this.isInstitutionalProposalEvent();
    }

    public boolean isProtocolEvent() {
        return StringUtils.equals((String)"3", (String)this.getEventTypeCode());
    }

    public boolean isIacucProtocolEvent() {
        return StringUtils.equals((String)"4", (String)this.getEventTypeCode());
    }

    public boolean isAwardEvent() {
        return StringUtils.equals((String)AWARD_DISCL_MODULE_CODE, (String)this.getEventTypeCode());
    }

    public boolean isAnnualEvent() {
        return StringUtils.equals((String)MANUAL_DISCL_MODULE_CODE, (String)this.getEventTypeCode());
    }

    public boolean isUpdateEvent() {
        return StringUtils.equals((String)"6", (String)this.getEventTypeCode());
    }

    public boolean isExcludedFromAnnual() {
        return this.coiDisclosureEventType.isExcludeFromMasterDisclosure();
    }

    public boolean isManualEvent() {
        return !StringUtils.equals((String)MANUAL_DISCL_MODULE_CODE, (String)this.getEventTypeCode()) && !StringUtils.equals((String)AWARD_DISCL_MODULE_CODE, (String)this.getEventTypeCode()) && !StringUtils.equals((String)"2", (String)this.getEventTypeCode()) && !StringUtils.equals((String)"10", (String)this.getEventTypeCode()) && !StringUtils.equals((String)"3", (String)this.getEventTypeCode()) && !StringUtils.equals((String)"4", (String)this.getEventTypeCode()) && !StringUtils.equals((String)"5", (String)this.getEventTypeCode()) && !StringUtils.equals((String)"6", (String)this.getEventTypeCode()) && !StringUtils.equals((String)"7", (String)this.getEventTypeCode());
    }

    public boolean isSystemEvent() {
        return StringUtils.equals((String)"2", (String)this.getEventTypeCode()) || StringUtils.equals((String)AWARD_DISCL_MODULE_CODE, (String)this.getEventTypeCode()) || StringUtils.equals((String)"10", (String)this.getEventTypeCode()) || StringUtils.equals((String)"3", (String)this.getEventTypeCode()) || StringUtils.equals((String)"4", (String)this.getEventTypeCode());
    }

    public String getCompleteMessage() {
        String completeMessage = "Disclosure is complete";
        int completeCount = 0;
        int detailSize = 0;
        if (CollectionUtils.isNotEmpty((Collection)this.getCoiDisclProjects())) {
            for (CoiDisclProject coiDisclProject : this.getCoiDisclProjects()) {
                if (!CollectionUtils.isNotEmpty((Collection)coiDisclProject.getCoiDiscDetails())) continue;
                detailSize += coiDisclProject.getCoiDiscDetails().size();
                for (CoiDiscDetail coiDiscDetail : coiDisclProject.getCoiDiscDetails()) {
                    if (coiDiscDetail.getEntityDispositionCode() == null || coiDiscDetail.getEntityDispositionCode() <= 0) continue;
                    ++completeCount;
                }
            }
        }
        return completeCount + "/" + detailSize + " Reviews Complete";
    }

    protected void updateUserFields(KraPersistableBusinessObjectBase bo) {
        bo.setUpdateUser(GlobalVariables.getUserSession().getPrincipalName());
        bo.setUpdateTimestamp(this.getDateTimeService().getCurrentTimestamp());
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = CoreApiServiceLocator.getDateTimeService();
        }
        return this.dateTimeService;
    }

    public <T extends CoiDisclosureAttachment> void addAttachmentsByType(T attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("the attachment is null");
        }
        this.updateUserFields(attachment);
        attachment.setCoiDisclosureId(this.coiDisclosureId);
        attachment.setCoiDisclosureNumber(this.coiDisclosureNumber);
        if (attachment instanceof CoiDisclosureAttachment) {
            assert (attachment != null) : "the attachment is null";
            if (attachment instanceof CoiDisclosureAttachment) {
                String ATTACHMENT_DRAFTED = AWARD_DISCL_MODULE_CODE;
                attachment.setDocumentStatusCode(ATTACHMENT_DRAFTED);
                attachment.setDocumentId(Integer.valueOf(this.getNextDocumentId(this.coiDisclosureDocument.getCoiDisclosure().getCoiDisclosureAttachments())));
            }
        } else {
            throw new IllegalArgumentException("unsupported type: " + attachment.getClass().getName());
        }
        this.coiDisclosureDocument.getCoiDisclosure().addCoiDisclosureAttachment(attachment);
        this.addAttachment(attachment);
    }

    private int getNextDocumentId(List<? extends CoiDisclosureAttachment> attachments) {
        int nextDocumentId = 0;
        for (CoiDisclosureAttachment coiDisclosureAttachment : attachments) {
            if (coiDisclosureAttachment.getDocumentId() <= nextDocumentId) continue;
            nextDocumentId = coiDisclosureAttachment.getDocumentId();
        }
        return ++nextDocumentId;
    }

    public void addAttachment(CoiDisclosureAttachment attachment) {
        this.getCoiDisclosureAttachments().add(attachment);
    }

    public List<CoiDisclosureAttachment> getCoiDisclosureAttachments() {
        if (this.coiDisclosureAttachments == null) {
            this.coiDisclosureAttachments = new ArrayList();
        }
        return this.coiDisclosureAttachments;
    }

    public void setCoiDisclosureAttachments(List<CoiDisclosureAttachment> coiDisclosureAttachments) {
        this.coiDisclosureAttachments = coiDisclosureAttachments;
    }

    protected void addCoiDisclosureAttachment(CoiDisclosureAttachment coiDisclosureAttachment) {
        CoiDisclosureAttachment.addAttachmentToCollection((CoiDisclosureAttachment)coiDisclosureAttachment, (List)this.getCoiDisclosureAttachments());
    }

    public void initializeCoiAttachmentFilter() {
        this.newAttachmentFilter = new CoiDisclosureAttachmentFilter();
        try {
            String defaultSortBy = this.getParameterService().getParameterValueAsString(CoiDisclosureDocument.class, "coiAttachmentDefaultSort");
            if (StringUtils.isNotBlank((String)defaultSortBy)) {
                this.newAttachmentFilter.setSortBy(defaultSortBy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initializeCoiReviewStatus() {
        this.setReviewStatusCode(AWARD_DISCL_MODULE_CODE);
        this.refreshReferenceObject("coiReviewStatus");
    }

    public void setCoiDisclosureAttachmentFilter(CoiDisclosureAttachmentFilter newAttachmentFilter) {
        this.newAttachmentFilter = newAttachmentFilter;
    }

    public CoiDisclosureAttachmentFilter getCoiDisclosureAttachmentFilter() {
        return this.newAttachmentFilter;
    }

    public List<CoiDisclosureAttachment> getFilteredAttachments() {
        ArrayList<CoiDisclosureAttachment> filteredAttachments = new ArrayList();
        CoiDisclosureAttachmentFilter attachmentFilter = this.getCoiDisclosureAttachmentFilter();
        if (attachmentFilter == null || !StringUtils.isNotBlank((String)attachmentFilter.getFilterBy())) {
            filteredAttachments = this.getCoiDisclosureAttachments();
        }
        if (attachmentFilter != null && StringUtils.isNotBlank((String)attachmentFilter.getSortBy())) {
            Collections.sort(filteredAttachments, attachmentFilter.getCoiDisclosureAttachmentComparator());
        }
        return filteredAttachments;
    }

    public boolean isComplete() {
        boolean isComplete = true;
        if (CollectionUtils.isNotEmpty((Collection)this.getCoiDisclProjects())) {
            for (CoiDisclProject coiDisclProject : this.getCoiDisclProjects()) {
                if (CollectionUtils.isNotEmpty((Collection)coiDisclProject.getCoiDiscDetails())) {
                    for (CoiDiscDetail coiDiscDetail : coiDisclProject.getCoiDiscDetails()) {
                        if (coiDiscDetail.getEntityDispositionCode() != null && coiDiscDetail.getEntityDispositionCode() != 0) continue;
                        isComplete = false;
                        break;
                    }
                }
                if (isComplete) continue;
                break;
            }
        }
        return isComplete;
    }

    public void setSequenceOwner(CoiDisclosure newlyVersionedOwner) {
    }

    public CoiDisclosure getSequenceOwner() {
        return this;
    }

    public void resetPersistenceState() {
        this.coiDisclosureId = null;
    }

    public void incrementSequenceNumber() {
        CoiDisclosure coiDisclosure = this;
        Integer n = coiDisclosure.sequenceNumber;
        Integer n2 = coiDisclosure.sequenceNumber = Integer.valueOf(coiDisclosure.sequenceNumber + 1);
    }

    public Integer getOwnerSequenceNumber() {
        return null;
    }

    public String getVersionNameField() {
        return "coiDisclosureNumber";
    }

    public KraPersistableBusinessObjectBase getEventBo() {
        return this.eventBo;
    }

    public void setEventBo(KraPersistableBusinessObjectBase eventBo) {
        this.eventBo = eventBo;
    }

    public String getDocumentNumberForPermission() {
        return this.coiDisclosureNumber;
    }

    public String getDocumentKey() {
        return "coiDisclosure";
    }

    public List<String> getRoleNames() {
        return null;
    }

    public String getNamespace() {
        return "KC-COIDISCLOSURE";
    }

    public String getDocumentUnitNumber() {
        return this.getLeadUnitNumber();
    }

    public String getDocumentRoleTypeCode() {
        return "KC-COIDISCLOSURE";
    }

    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        if (this.getCoiDisclosureId() != null) {
            qualifiedRoleAttributes.put("coiDisclosureId", this.getCoiDisclosureId().toString());
        }
    }

    public String getEventTypeCode() {
        return this.eventTypeCode;
    }

    public void setEventTypeCode(String eventTypeCode) {
        this.eventTypeCode = eventTypeCode;
    }

    public String getModuleItemKey() {
        return this.moduleItemKey;
    }

    public void setModuleItemKey(String moduleItemKey) {
        this.moduleItemKey = moduleItemKey;
    }

    public boolean isCurrentDisclosure() {
        return this.currentDisclosure;
    }

    public void setCurrentDisclosure(boolean currentDisclosure) {
        this.currentDisclosure = currentDisclosure;
    }

    public boolean isOpenForNotesAndAttachments() {
        return !this.isApprovedDisclosure() && !this.isDisapprovedDisclosure();
    }

    public boolean isApprovedDisclosure() {
        return StringUtils.equals((String)"3", (String)this.getDisclosureStatusCode());
    }

    public boolean isSubmitted() {
        return ObjectUtils.isNotNull((Object)this.getCertificationTimestamp());
    }

    public boolean isDisapprovedDisclosure() {
        return StringUtils.equals((String)"4", (String)this.getDisclosureStatusCode());
    }

    public CoiDispositionStatus getCoiDispositionStatus() {
        if (StringUtils.isNotEmpty((String)this.disclosureDispositionCode) && this.coiDispositionStatus == null) {
            this.refreshReferenceObject("coiDispositionStatus");
        }
        return this.coiDispositionStatus;
    }

    public void setCoiDispositionStatus(CoiDispositionStatus coiDispositionStatus) {
        this.coiDispositionStatus = coiDispositionStatus;
    }

    public CoiDisclosureStatus getCoiDisclosureStatus() {
        this.refreshReferenceObject("coiDisclosureStatus");
        return this.coiDisclosureStatus;
    }

    public boolean isUnderReview() {
        CoiDisclosureStatus currentStatus = this.getCoiDisclosureStatus();
        return StringUtils.equals((String)"2", (String)currentStatus.getCoiDisclosureStatusCode());
    }

    public boolean isSubmittedForReview() {
        CoiDisclosureStatus currentStatus = this.getCoiDisclosureStatus();
        return StringUtils.equals((String)"2", (String)currentStatus.getCoiDisclosureStatusCode());
    }

    public void setCoiDisclosureStatus(CoiDisclosureStatus coiDisclosureStatus) {
        this.coiDisclosureStatus = coiDisclosureStatus;
    }

    public CoiDisclosureEventType getCoiDisclosureEventType() {
        if (StringUtils.isNotBlank((String)this.eventTypeCode) && this.coiDisclosureEventType == null || !StringUtils.equals((String)this.eventTypeCode, (String)this.coiDisclosureEventType.getEventTypeCode())) {
            this.refreshReferenceObject("coiDisclosureEventType");
        }
        return this.coiDisclosureEventType;
    }

    public void setCoiDisclosureEventType(CoiDisclosureEventType coiDisclosureEventType) {
        this.coiDisclosureEventType = coiDisclosureEventType;
    }

    public List<CoiUserRole> getCoiUserRoles() {
        return this.coiUserRoles;
    }

    public void setCoiUserRoles(List<CoiUserRole> coiUserRoles) {
        this.coiUserRoles = coiUserRoles;
    }

    public boolean isAnnualUpdate() {
        return this.annualUpdate;
    }

    public void setAnnualUpdate(boolean annualUpdate) {
        this.annualUpdate = annualUpdate;
    }

    public String getReporterCreated() {
        return this.reporterCreated;
    }

    public void setReporterCreated(String reporterCreated) {
        this.reporterCreated = reporterCreated;
    }

    public String getCoiDisclProjectId() {
        return this.coiDisclProjectId;
    }

    public void setCoiDisclProjectId(String coiDisclProjectId) {
        this.coiDisclProjectId = coiDisclProjectId;
    }

    public String getCoiDisclProjectTitle() {
        return this.coiDisclProjectTitle;
    }

    public void setCoiDisclProjectTitle(String coiDisclProjectTitle) {
        this.coiDisclProjectTitle = coiDisclProjectTitle;
    }

    public List<CoiNotification> getDisclosureNotifications() {
        if (this.disclosureNotifications == null) {
            this.disclosureNotifications = new ArrayList();
        }
        return this.disclosureNotifications;
    }

    public List<CoiNotification> getFilteredDisclosureNotifications() {
        return this.filterNotifications(this.getDisclosureNotifications());
    }

    public List<CoiNotification> filterNotifications(List<CoiNotification> unfilteredList) {
        String currentUser = GlobalVariables.getUserSession().getPrincipalName().trim();
        if (!StringUtils.equals((String)currentUser, (String)this.getReporterUserName())) {
            return unfilteredList;
        }
        ArrayList<CoiNotification> filteredList = new ArrayList<CoiNotification>();
        block0: for (CoiNotification notification : unfilteredList) {
            if (currentUser.equals(notification.getCreateUser())) {
                filteredList.add(notification);
                continue;
            }
            for (String recipient : notification.getRecipients().split(",")) {
                if (!currentUser.equals(recipient.trim())) continue;
                filteredList.add(notification);
                continue block0;
            }
        }
        return filteredList;
    }

    public List<CoiNotification> getNotificationsByDocId() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("documentNumber", this.getCoiDisclosureDocument().getDocumentNumber());
        return (List)this.getBusinessObjectService().findMatching(CoiNotification.class, fieldValues);
    }

    public List<CoiNotification> getFilteredNotificationsByDocId() {
        return this.filterNotifications(this.getNotificationsByDocId());
    }

    public void setDisclosureNotifications(List<CoiNotification> disclosureNotifications) {
        this.disclosureNotifications = disclosureNotifications;
    }

    public void addNotification(CoiNotification notification) {
        this.getDisclosureNotifications().add(notification);
    }

    public String getReporterUserName() {
        DisclosurePerson reporter = this.getDisclosureReporter();
        return this.getKcPersonService().getKcPersonByPersonId(reporter.getPersonId()).getUserName();
    }

    public String getReviewStatusCode() {
        return this.reviewStatusCode;
    }

    public void setReviewStatusCode(String reviewStatusCode) {
        this.reviewStatusCode = reviewStatusCode;
    }

    public CoiReviewStatus getCoiReviewStatus() {
        if (StringUtils.isNotEmpty((String)this.reviewStatusCode) && this.coiReviewStatus == null) {
            this.refreshReferenceObject("coiReviewStatus");
        }
        return this.coiReviewStatus;
    }

    public void setCoiReviewStatus(CoiReviewStatus coiReviewStatus) {
        this.coiReviewStatus = coiReviewStatus;
    }

    public String getDisclosureStatusReviewStatus() {
        return this.disclosureStatusReviewStatus;
    }

    public boolean isDisclosureSaved() {
        return this.coiDisclosureId != null;
    }
}

