/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.krms.KrmsRulesContext;
import org.kuali.kra.krms.service.KcKrmsFactBuilderService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krms.api.engine.Facts;

@ParameterConstants.NAMESPACE(namespace="KC-COIDISCLOSURE")
@ParameterConstants.COMPONENT(component="Document")
public class CoiDisclosureDocument
extends ResearchDocumentBase
implements Copyable,
SessionDocument,
KrmsRulesContext {
    public static final String DOCUMENT_TYPE_CODE = "COI";
    private List<CoiDisclosure> coiDisclosureList = new ArrayList();

    public CoiDisclosureDocument() {
        CoiDisclosure newCoiDisclosure = new CoiDisclosure();
        newCoiDisclosure.setCoiDisclosureDocument(this);
        this.coiDisclosureList.add(newCoiDisclosure);
    }

    public List<CoiDisclosure> getCoiDisclosureList() {
        return this.coiDisclosureList;
    }

    public void setCoiDisclosureList(List<CoiDisclosure> coiDisclosureList) {
        this.coiDisclosureList = coiDisclosureList;
    }

    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public CoiDisclosure getCoiDisclosure() {
        if (this.coiDisclosureList.size() == 0) {
            return null;
        }
        return (CoiDisclosure)this.coiDisclosureList.get(0);
    }

    public void setCoiDisclosure(CoiDisclosure coiDisclosure) {
        this.coiDisclosureList.set(0, coiDisclosure);
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        if (this.getCoiDisclosure() != null) {
            managedLists.addAll(this.getCoiDisclosure().buildListOfDeletionAwareLists());
        }
        managedLists.add(this.coiDisclosureList);
        return managedLists;
    }

    public boolean isProcessComplete() {
        boolean isComplete = true;
        if (StringUtils.equalsIgnoreCase((String)this.getCoiDisclosure().getCoiDisclosureStatus().getCoiDisclosureStatusCode(), (String)"2")) {
            isComplete = true;
        } else if (!this.getDocumentHeader().getWorkflowDocument().isFinal() && !this.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
            isComplete = false;
        }
        return isComplete;
    }

    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("namespaceCode", "KC-COIDISCLOSURE");
        qualifiers.put("name", "KC Annual COI Disclosure Context");
    }

    public void addFacts(Facts.Builder factsBuilder) {
        KcKrmsFactBuilderService fbService = (KcKrmsFactBuilderService)KraServiceLocator.getService((String)"coiDisclosureFactBuilderService");
        fbService.addFacts(factsBuilder, (ResearchDocumentBase)this);
    }

    public void populateAgendaQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("Unit Number", this.getCoiDisclosure().getLeadUnitNumber());
    }

    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return new ArrayList();
    }

    public String getCustomLockDescriptor(Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        String updatedTimestamp = "";
        if (this.getUpdateTimestamp() != null) {
            updatedTimestamp = new SimpleDateFormat("MM/dd/yyyy KK:mm a").format(this.getUpdateTimestamp());
        }
        if (StringUtils.isNotEmpty((String)activeLockRegion)) {
            return this.getCoiDisclosure().getCoiDisclosureNumber() + "-" + activeLockRegion + "-" + GlobalVariables.getUserSession().getPrincipalName() + "-" + updatedTimestamp;
        }
        return null;
    }

    public boolean useCustomLockDescriptors() {
        return true;
    }
}

