/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.coi.CoiNoteType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;

public class CoiNoteTypeMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    private static final String COI_NOTE_TYPE_SORT_ID_FIELD_NAME = "sortId";
    private static final String DESCRIPTION_FIELD_NAME = "description";
    private transient BusinessObjectService businessObjectService;

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    private boolean checkUniqueness(MaintenanceDocument document) {
        boolean isValid = true;
        CoiNoteType newCoiNoteType = (CoiNoteType)document.getNewMaintainableObject().getDataObject();
        isValid &= this.checkSortIdUniqueness(newCoiNoteType);
        return isValid &= this.checkDescriptionUniqueness(newCoiNoteType);
    }

    private boolean checkSortIdUniqueness(CoiNoteType newCoiNoteType) {
        boolean isValid = true;
        Integer groupSortId = newCoiNoteType.getSortId();
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put(COI_NOTE_TYPE_SORT_ID_FIELD_NAME, groupSortId);
        Collection matchingRelTypes = this.getBusinessObjectService().findMatching(CoiNoteType.class, fieldValues);
        for (CoiNoteType noteType : matchingRelTypes) {
            if (ObjectUtils.equals((Object)noteType.getNoteTypeCode(), (Object)newCoiNoteType.getNoteTypeCode())) continue;
            isValid = false;
            this.putFieldError(COI_NOTE_TYPE_SORT_ID_FIELD_NAME, "error.duplicate.property", new String[]{"Sort Id"});
            break;
        }
        return isValid;
    }

    private boolean checkDescriptionUniqueness(CoiNoteType newFinIntEntityRelType) {
        boolean isValid = true;
        String description = newFinIntEntityRelType.getDescription();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(DESCRIPTION_FIELD_NAME, description);
        Collection matchingRelTypes = this.getBusinessObjectService().findMatching(CoiNoteType.class, fieldValues);
        for (CoiNoteType noteType : matchingRelTypes) {
            if (ObjectUtils.equals((Object)noteType.getNoteTypeCode(), (Object)newFinIntEntityRelType.getNoteTypeCode())) continue;
            isValid = false;
            this.putFieldError(DESCRIPTION_FIELD_NAME, "error.duplicate.property", new String[]{"Description"});
            break;
        }
        return isValid;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

