/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.actions;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.coi.CoiDiscDetail;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.CoiDisclosureForm;
import org.kuali.kra.coi.CoiDisclosureHistory;
import org.kuali.kra.coi.CoiUserRole;
import org.kuali.kra.coi.actions.CoiDisclosureActionService;
import org.kuali.kra.coi.certification.SubmitDisclosureAction;
import org.kuali.kra.coi.notesandattachments.attachments.CoiDisclosureAttachment;
import org.kuali.kra.coi.notesandattachments.notes.CoiDisclosureNotepad;
import org.kuali.kra.coi.notification.AssignReviewerNotificationRenderer;
import org.kuali.kra.coi.notification.CoiNotification;
import org.kuali.kra.coi.notification.CoiNotificationContext;
import org.kuali.kra.coi.notification.CoiNotificationRenderer;
import org.kuali.kra.coi.notification.DisclosureCertifiedNotificationRenderer;
import org.kuali.kra.coi.notification.DisclosureCertifiedNotificationRequestBean;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.common.notification.web.struts.form.NotificationHelper;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class CoiDisclosureActionServiceImpl
implements CoiDisclosureActionService {
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private KcNotificationService kcNotificationService;
    private static final Log LOG = LogFactory.getLog(CoiDisclosureActionServiceImpl.class);
    private QuestionnaireAnswerService questionnaireAnswerService;
    private static final String MODULE_ITEM_CODE = "moduleItemCode";
    private static final String MODULE_ITEM_KEY = "moduleItemKey";
    private static final String MODULE_SUB_ITEM_KEY = "moduleSubItemKey";
    private static final String MODULE_NAMESPACE = "KC-COIDISCLOSURE";

    public void approveDisclosure(CoiDisclosure coiDisclosure, String coiDispositionCode) throws WorkflowException {
        CoiDisclosure masterCoiDisclosure = this.getMasterDisclosure(coiDisclosure.getCoiDisclosureNumber());
        ArrayList<Object> disclosures = new ArrayList<Object>();
        coiDisclosure.setDisclosureDispositionCode(coiDispositionCode);
        coiDisclosure.setDisclosureStatusCode("3");
        this.updateCoiDisclProjectStatus(coiDisclosure, "3");
        disclosures.add(coiDisclosure);
        if (!coiDisclosure.isUpdateEvent() && !coiDisclosure.isAnnualEvent()) {
            this.fixAnswerHeader(coiDisclosure);
        }
        if (masterCoiDisclosure != null) {
            if (coiDisclosure.isUpdateEvent() || coiDisclosure.isAnnualEvent() && coiDisclosure.isAnnualUpdate()) {
                this.syncCollections(masterCoiDisclosure, coiDisclosure);
            } else {
                this.copyCollections(masterCoiDisclosure, coiDisclosure);
            }
            masterCoiDisclosure.setCurrentDisclosure(false);
            disclosures.add(masterCoiDisclosure);
        }
        this.setDisclosureReviewStatus(coiDisclosure, "5");
        coiDisclosure.setCurrentDisclosure(true);
        this.documentService.approveDocument((Document)coiDisclosure.getCoiDisclosureDocument(), "Document approved.", new ArrayList());
        disclosures.add(this.createDisclosureHistory(coiDisclosure));
        this.businessObjectService.save(disclosures);
        this.sendNotification(coiDisclosure, "204", "Approved");
    }

    public void disapproveDisclosure(CoiDisclosure coiDisclosure, String coiDispositionCode) throws Exception {
        coiDisclosure.setDisclosureDispositionCode(coiDispositionCode);
        coiDisclosure.setDisclosureStatusCode("4");
        this.updateCoiDisclProjectStatus(coiDisclosure, "4");
        this.setDisclosureReviewStatus(coiDisclosure, "5");
        this.businessObjectService.save((PersistableBusinessObject)coiDisclosure);
        this.businessObjectService.save((PersistableBusinessObject)this.createDisclosureHistory(coiDisclosure));
        this.documentService.disapproveDocument((Document)coiDisclosure.getCoiDisclosureDocument(), "Document approved.");
        this.sendNotification(coiDisclosure, "304", "Disapproved");
    }

    public KcNotificationService getKcNotificationService() {
        return this.kcNotificationService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }

    public ActionForward addCoiUserRole(ActionMapping mapping, ActionForm form, CoiDisclosure coiDisclosure, CoiUserRole coiUserRole) {
        ActionForward forward = mapping.findForward("basic");
        coiDisclosure.getCoiUserRoles().add(coiUserRole);
        this.setDisclosureReviewStatus(coiDisclosure, "3");
        this.businessObjectService.save((PersistableBusinessObject)coiDisclosure);
        return this.sendNotification(mapping, form, forward, coiUserRole, "Assigned");
    }

    public ActionForward deleteCoiUserRole(ActionMapping mapping, ActionForm form, CoiDisclosure coiDisclosure, int index) {
        ActionForward forward = mapping.findForward("basic");
        if (index >= 0 && index < coiDisclosure.getCoiUserRoles().size()) {
            CoiUserRole coiUserRole = (CoiUserRole)coiDisclosure.getCoiUserRoles().remove(index);
            this.resetDisclosureReviewStatus(coiDisclosure);
            this.businessObjectService.save((PersistableBusinessObject)coiDisclosure);
            return this.sendNotification(mapping, form, forward, coiUserRole, "Removed");
        }
        return forward;
    }

    private CoiDisclosure getMasterDisclosure(String coiDisclosureNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("coiDisclosureNumber", coiDisclosureNumber);
        fieldValues.put("currentDisclosure", "Y");
        List disclosures = (List)this.businessObjectService.findMatching(CoiDisclosure.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)disclosures)) {
            return (CoiDisclosure)disclosures.get(0);
        }
        return null;
    }

    private void copyCollections(CoiDisclosure masterCoiDisclosure, CoiDisclosure coiDisclosure) {
        this.copyDisclosureProjects(masterCoiDisclosure, coiDisclosure);
        this.copyDisclosureNotePads(masterCoiDisclosure, coiDisclosure);
        this.copyDisclosureAttachments(masterCoiDisclosure, coiDisclosure);
        this.copyDisclosureQuestionnaire(masterCoiDisclosure, coiDisclosure);
    }

    protected void fixAnswerHeader(CoiDisclosure coiDisclosure) {
        String moduleSubKey = ((CoiDisclProject)coiDisclosure.getCoiDisclProjects().get(0)).getCoiProjectId();
        for (AnswerHeader answerHeader : this.retrieveAnswerHeaders(coiDisclosure)) {
            answerHeader.setModuleSubItemKey(moduleSubKey);
            this.businessObjectService.save((PersistableBusinessObject)answerHeader);
        }
    }

    private void copyDisclosureQuestionnaire(CoiDisclosure masterCoiDisclosure, CoiDisclosure coiDisclosure) {
        try {
            CoiDisclosureDocument coiDisclosureDocument = (CoiDisclosureDocument)((DocumentService)KraServiceLocator.getService(DocumentService.class)).getByDocumentHeaderId(masterCoiDisclosure.getCoiDisclosureDocument().getDocumentNumber());
            masterCoiDisclosure.setCoiDisclosureDocument(coiDisclosureDocument);
        }
        catch (Exception e) {
            // empty catch block
        }
        List newAnswerHeaders = this.versioningQuestionnaireAnswer(masterCoiDisclosure);
        if (!newAnswerHeaders.isEmpty()) {
            for (AnswerHeader answerHeader : newAnswerHeaders) {
                answerHeader.setModuleItemKey(coiDisclosure.getCoiDisclosureId().toString());
            }
            this.businessObjectService.save(newAnswerHeaders);
        }
    }

    private List<AnswerHeader> versioningQuestionnaireAnswer(CoiDisclosure coiDisclosure) {
        ArrayList<AnswerHeader> newAnswerHeaders = new ArrayList<AnswerHeader>();
        for (AnswerHeader answerHeader : this.retrieveAnswerHeaders(coiDisclosure)) {
            AnswerHeader copiedAnswerHeader = (AnswerHeader)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)answerHeader);
            copiedAnswerHeader.setAnswerHeaderId(null);
            for (Answer answer : copiedAnswerHeader.getAnswers()) {
                answer.setId(null);
            }
            newAnswerHeaders.add(copiedAnswerHeader);
        }
        return newAnswerHeaders;
    }

    private List<AnswerHeader> retrieveAnswerHeaders(CoiDisclosure coiDisclosure) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_ITEM_CODE, "8");
        fieldValues.put(MODULE_ITEM_KEY, coiDisclosure.getCoiDisclosureId().toString());
        return (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
    }

    private void copyDisclosureDetails(List<CoiDiscDetail> originalDiscDetails, CoiDisclProject copiedDisclProject) {
        ArrayList<CoiDiscDetail> copiedDiscDetails = new ArrayList<CoiDiscDetail>();
        for (CoiDiscDetail coiDiscDetail : originalDiscDetails) {
            CoiDiscDetail copiedDiscDetail = (CoiDiscDetail)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)coiDiscDetail);
            copiedDiscDetail.setCopiedCoiDiscDetailId(copiedDiscDetail.getCoiDiscDetailId());
            copiedDiscDetail.setSequenceNumber(copiedDisclProject.getSequenceNumber());
            copiedDiscDetail.setCoiDiscDetailId(null);
            copiedDiscDetail.setCoiDisclProjectId(null);
            if (copiedDiscDetail.getOriginalCoiDisclosureId() == null) {
                copiedDiscDetail.setOriginalCoiDisclosureId(copiedDisclProject.getCoiDisclosureId());
            }
            copiedDiscDetails.add(copiedDiscDetail);
        }
        copiedDisclProject.setCoiDiscDetails(copiedDiscDetails);
        if (copiedDisclProject.getOriginalCoiDisclosureId() == null) {
            copiedDisclProject.setOriginalCoiDisclosureId(copiedDisclProject.getCoiDisclosureId());
        }
    }

    private void copyDisclosureProjects(CoiDisclosure masterCoiDisclosure, CoiDisclosure coiDisclosure) {
        ArrayList<CoiDisclProject> copiedDisclProjects = new ArrayList<CoiDisclProject>();
        for (CoiDisclProject coiDisclProject : masterCoiDisclosure.getCoiDisclProjects()) {
            List coiDiscDetails = coiDisclProject.getCoiDiscDetails();
            CoiDisclProject copiedDisclProject = (CoiDisclProject)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)coiDisclProject);
            copiedDisclProject.setSequenceNumber(coiDisclosure.getSequenceNumber());
            copiedDisclProject.setCoiDisclProjectsId(null);
            this.copyDisclosureDetails(coiDiscDetails, copiedDisclProject);
            copiedDisclProjects.add(copiedDisclProject);
            copiedDisclProject.setCoiDisclosureId(null);
        }
        coiDisclosure.getCoiDisclProjects().addAll(copiedDisclProjects);
    }

    private void copyDisclosureNotePads(CoiDisclosure masterCoiDisclosure, CoiDisclosure coiDisclosure) {
        for (CoiDisclosureNotepad coiDisclosureNotepad : masterCoiDisclosure.getCoiDisclosureNotepads()) {
            CoiDisclosureNotepad copiedCoiDisclosureNotepad = (CoiDisclosureNotepad)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)coiDisclosureNotepad);
            copiedCoiDisclosureNotepad.setSequenceNumber(coiDisclosure.getSequenceNumber());
            copiedCoiDisclosureNotepad.setId(null);
            if (copiedCoiDisclosureNotepad.getOriginalCoiDisclosureId() == null) {
                copiedCoiDisclosureNotepad.setOriginalCoiDisclosureId(masterCoiDisclosure.getCoiDisclosureId());
            }
            coiDisclosure.getCoiDisclosureNotepads().add(copiedCoiDisclosureNotepad);
        }
    }

    private void copyDisclosureAttachments(CoiDisclosure masterCoiDisclosure, CoiDisclosure coiDisclosure) {
        for (CoiDisclosureAttachment coiDisclosureAttachment : masterCoiDisclosure.getCoiDisclosureAttachments()) {
            CoiDisclosureAttachment copiedCoiDisclosureAttachment = (CoiDisclosureAttachment)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)coiDisclosureAttachment);
            copiedCoiDisclosureAttachment.setSequenceNumber(coiDisclosure.getSequenceNumber());
            copiedCoiDisclosureAttachment.setAttachmentId(null);
            copiedCoiDisclosureAttachment.setFile(coiDisclosureAttachment.getFile());
            copiedCoiDisclosureAttachment.setFileId(coiDisclosureAttachment.getFileId());
            if (copiedCoiDisclosureAttachment.getOriginalCoiDisclosureId() == null) {
                copiedCoiDisclosureAttachment.setOriginalCoiDisclosureId(masterCoiDisclosure.getCoiDisclosureId());
            }
            coiDisclosure.getCoiDisclosureAttachments().add(copiedCoiDisclosureAttachment);
        }
    }

    private boolean isDisclosureDetailExist(CoiDisclosure coiDisclosure, CoiDiscDetail coiDiscDetail) {
        boolean isExist = false;
        block0: for (CoiDisclProject disclProject : coiDisclosure.getCoiDisclProjects()) {
            for (CoiDiscDetail discDetail : disclProject.getCoiDiscDetails()) {
                if (!StringUtils.equals((String)discDetail.getProjectType(), (String)coiDiscDetail.getProjectType()) || !StringUtils.equals((String)discDetail.getProjectIdFk(), (String)coiDiscDetail.getProjectIdFk()) || !discDetail.getPersonFinIntDisclosureId().equals(coiDiscDetail.getPersonFinIntDisclosureId())) continue;
                isExist = true;
                continue block0;
            }
        }
        return isExist;
    }

    private CoiDisclosureHistory createDisclosureHistory(CoiDisclosure coiDisclosure) {
        CoiDisclosureHistory coiDisclosureHistory = new CoiDisclosureHistory();
        coiDisclosureHistory.setCoiDisclosureId(coiDisclosure.getCoiDisclosureId());
        coiDisclosureHistory.setCoiDisclosureNumber(coiDisclosure.getCoiDisclosureNumber());
        coiDisclosureHistory.setSequenceNumber(coiDisclosure.getSequenceNumber());
        coiDisclosureHistory.setDisclosureDispositionStatus(coiDisclosure.getDisclosureDispositionCode());
        coiDisclosureHistory.setDisclosureStatus(coiDisclosure.getDisclosureStatusCode());
        return coiDisclosureHistory;
    }

    public void submitToWorkflow(CoiDisclosureDocument coiDisclosureDocument, CoiDisclosureForm coiDisclosureForm, SubmitDisclosureAction submitDisclosureAction) {
        CoiDisclosure disclosure = coiDisclosureDocument.getCoiDisclosure();
        this.setDisclosureReviewStatus(disclosure, "2");
        try {
            this.documentService.routeDocument((Document)coiDisclosureDocument, "Disclosure has been certified and submitted.", new ArrayList());
        }
        catch (WorkflowException e) {
            String errorString = "WorkflowException certifying Disclosure for user col %s" + coiDisclosureDocument.getCoiDisclosure().getAuthorPersonName();
            LOG.error((Object)errorString, (Throwable)e);
            throw new RuntimeException(errorString, e);
        }
    }

    public ActionForward sendCertificationNotifications(CoiDisclosureDocument coiDisclosureDocument, CoiDisclosureForm coiDisclosureForm, SubmitDisclosureAction submitDisclosureAction, ActionMapping mapping) {
        DisclosureCertifiedNotificationRenderer renderer = new DisclosureCertifiedNotificationRenderer(coiDisclosureDocument.getCoiDisclosure(), "certified");
        DisclosureCertifiedNotificationRequestBean disclosureCertifiedNotificationBean = this.getDisclosureCertifiedRequestBean(coiDisclosureDocument.getCoiDisclosure(), submitDisclosureAction.getReviewers());
        CoiNotificationContext context = new CoiNotificationContext(coiDisclosureDocument.getCoiDisclosure(), disclosureCertifiedNotificationBean.getActionType(), disclosureCertifiedNotificationBean.getDescription(), (NotificationRenderer)renderer);
        return this.checkToSendNotification(mapping, mapping.findForward("basic"), coiDisclosureForm, renderer, context, disclosureCertifiedNotificationBean);
    }

    private DisclosureCertifiedNotificationRequestBean getDisclosureCertifiedRequestBean(CoiDisclosure coiDisclosure, List<CoiUserRole> userRoles) {
        DisclosureCertifiedNotificationRequestBean newBean = new DisclosureCertifiedNotificationRequestBean(coiDisclosure, userRoles);
        return newBean;
    }

    private ActionForward checkToSendNotification(ActionMapping mapping, ActionForward forward, CoiDisclosureForm coiDisclosureForm, DisclosureCertifiedNotificationRenderer renderer, CoiNotificationContext context, DisclosureCertifiedNotificationRequestBean notificationRequestBean) {
        if (coiDisclosureForm.getNotificationHelper().getPromptUserForNotificationEditor((NotificationContext)context)) {
            coiDisclosureForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
            return mapping.findForward("protocolNotificationEditor");
        }
        this.getKcNotificationService().sendNotificationAndPersist((NotificationContext)context, (KcNotification)new CoiNotification(), (KraPersistableBusinessObjectBase)coiDisclosureForm.getCoiDisclosureDocument().getCoiDisclosure());
        return null;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public void updateCoiDisclProjectStatus(CoiDisclosure coiDisclosure, String disclosureStatus) {
        List disclProjects = coiDisclosure.getCoiDisclProjects();
        for (CoiDisclProject tmpProj : disclProjects) {
            if (!StringUtils.equals((String)tmpProj.getDisclosureEventType(), (String)coiDisclosure.getCoiDisclosureEventType().getEventTypeCode()) || !StringUtils.equals((String)tmpProj.getModuleItemKey(), (String)coiDisclosure.getModuleItemKey())) continue;
            tmpProj.setDisclosureStatusCode(disclosureStatus);
        }
    }

    public void updateCoiDisclProjectDisposition(CoiDisclosure coiDisclosure, String dispositionCode) {
        List disclProjects = coiDisclosure.getCoiDisclProjects();
        Integer dispositionStatus = Integer.valueOf(dispositionCode);
        for (CoiDisclProject tmpProj : disclProjects) {
            if (tmpProj.getDisclosureDispositionCode() != null && dispositionStatus <= tmpProj.getDisclosureDispositionCode()) continue;
            tmpProj.setDisclosureDispositionCode(dispositionStatus);
        }
    }

    private void syncCollections(CoiDisclosure masterCoiDisclosure, CoiDisclosure updateDisclosure) {
        this.syncDisclosureProjects(masterCoiDisclosure, updateDisclosure);
        this.syncDisclosureNotepads(masterCoiDisclosure, updateDisclosure);
        this.syncDisclosureAttachments(masterCoiDisclosure, updateDisclosure);
        this.syncDisclosureQuestionnaire(masterCoiDisclosure, updateDisclosure);
    }

    private void syncDisclosureProjects(CoiDisclosure masterCoiDisclosure, CoiDisclosure updateDisclosure) {
        HashMap<String, CoiDisclProject> masterProjectMap = new HashMap<String, CoiDisclProject>();
        for (CoiDisclProject updateDisclProject : updateDisclosure.getCoiDisclProjects()) {
            masterProjectMap.put(this.getCoiDisclProjectMapKey(updateDisclProject), updateDisclProject);
        }
        for (CoiDisclProject masterDisclProject : masterCoiDisclosure.getCoiDisclProjects()) {
            if (masterProjectMap.containsKey(this.getCoiDisclProjectMapKey(masterDisclProject))) continue;
            CoiDisclProject copiedDisclProject = (CoiDisclProject)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)masterDisclProject);
            copiedDisclProject.setSequenceNumber(updateDisclosure.getSequenceNumber());
            copiedDisclProject.setCoiDisclProjectsId(null);
            copiedDisclProject.setCoiDisclosureId(updateDisclosure.getCoiDisclosureId());
            this.copyDisclosureDetails(masterDisclProject.getCoiDiscDetails(), copiedDisclProject);
            masterProjectMap.put(this.getCoiDisclProjectMapKey(masterDisclProject), copiedDisclProject);
        }
        ArrayList mergedProjectList = new ArrayList();
        mergedProjectList.addAll(masterProjectMap.values());
        updateDisclosure.setCoiDisclProjects(mergedProjectList);
    }

    private String getCoiDisclProjectMapKey(CoiDisclProject disclProject) {
        return disclProject.getCoiProjectId() + "^" + disclProject.getModuleItemKey() + "^" + disclProject.getDisclosureEventType();
    }

    private void syncDisclosureNotepads(CoiDisclosure masterCoiDisclosure, CoiDisclosure updateDisclosure) {
        ArrayList<CoiDisclosureNotepad> mergedNotepadList = new ArrayList<CoiDisclosureNotepad>();
        HashSet<Long> origDisclIds = new HashSet<Long>();
        for (CoiDisclosureNotepad updateNotepad : updateDisclosure.getCoiDisclosureNotepads()) {
            if (updateNotepad.getOriginalCoiDisclosureId() != null) {
                origDisclIds.add(updateNotepad.getOriginalCoiDisclosureId());
            }
            mergedNotepadList.add(updateNotepad);
        }
        for (CoiDisclosureNotepad masterNotepad : masterCoiDisclosure.getCoiDisclosureNotepads()) {
            if (masterNotepad.getOriginalCoiDisclosureId() != null && origDisclIds.contains(masterNotepad.getOriginalCoiDisclosureId())) continue;
            CoiDisclosureNotepad copiedCoiDisclosureNotepad = (CoiDisclosureNotepad)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)masterNotepad);
            copiedCoiDisclosureNotepad.setSequenceNumber(updateDisclosure.getSequenceNumber());
            copiedCoiDisclosureNotepad.setId(null);
            if (copiedCoiDisclosureNotepad.getOriginalCoiDisclosureId() == null) {
                copiedCoiDisclosureNotepad.setOriginalCoiDisclosureId(masterCoiDisclosure.getCoiDisclosureId());
            }
            mergedNotepadList.add(copiedCoiDisclosureNotepad);
        }
        updateDisclosure.setCoiDisclosureNotepads(mergedNotepadList);
    }

    private void syncDisclosureAttachments(CoiDisclosure masterCoiDisclosure, CoiDisclosure updateDisclosure) {
        ArrayList<CoiDisclosureAttachment> mergedAttachmentList = new ArrayList<CoiDisclosureAttachment>();
        HashSet<Long> origDisclIds = new HashSet<Long>();
        for (CoiDisclosureAttachment updateAttachment : updateDisclosure.getCoiDisclosureAttachments()) {
            if (updateAttachment.getOriginalCoiDisclosureId() != null) {
                origDisclIds.add(updateAttachment.getOriginalCoiDisclosureId());
            }
            mergedAttachmentList.add(updateAttachment);
        }
        for (CoiDisclosureAttachment masterAttachment : masterCoiDisclosure.getCoiDisclosureAttachments()) {
            if (masterAttachment.getOriginalCoiDisclosureId() != null && origDisclIds.contains(masterAttachment.getOriginalCoiDisclosureId())) continue;
            CoiDisclosureAttachment copiedCoiDisclosureAttachment = (CoiDisclosureAttachment)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)masterAttachment);
            copiedCoiDisclosureAttachment.setSequenceNumber(updateDisclosure.getSequenceNumber());
            copiedCoiDisclosureAttachment.setAttachmentId(null);
            copiedCoiDisclosureAttachment.setFile(masterAttachment.getFile());
            copiedCoiDisclosureAttachment.setFileId(masterAttachment.getFileId());
            if (copiedCoiDisclosureAttachment.getOriginalCoiDisclosureId() == null) {
                copiedCoiDisclosureAttachment.setOriginalCoiDisclosureId(masterCoiDisclosure.getCoiDisclosureId());
            }
            mergedAttachmentList.add(copiedCoiDisclosureAttachment);
        }
        updateDisclosure.setCoiDisclosureAttachments(mergedAttachmentList);
    }

    private void syncDisclosureQuestionnaire(CoiDisclosure masterCoiDisclosure, CoiDisclosure updateDisclosure) {
        List updateAnswerHeaders = this.retrieveAnswerHeaders(updateDisclosure);
        List masterAnswerHeaders = this.retrieveAnswerHeaders(masterCoiDisclosure);
        for (AnswerHeader masterHeader : masterAnswerHeaders) {
            boolean existsAlready = false;
            for (AnswerHeader updateHeader : updateAnswerHeaders) {
                if (!StringUtils.equals((String)updateHeader.getModuleSubItemCode(), (String)masterHeader.getModuleSubItemCode()) || !StringUtils.equals((String)updateHeader.getModuleSubItemKey(), (String)masterHeader.getModuleSubItemKey()) || !StringUtils.equals((String)updateHeader.getQuestionnaireRefIdFk(), (String)masterHeader.getQuestionnaireRefIdFk())) continue;
                existsAlready = true;
            }
            if (existsAlready) continue;
            AnswerHeader copiedAnswerHeader = (AnswerHeader)org.kuali.rice.krad.util.ObjectUtils.deepCopy((Serializable)masterHeader);
            copiedAnswerHeader.setAnswerHeaderId(null);
            copiedAnswerHeader.setModuleItemCode(updateDisclosure.getCoiDisclosureId().toString());
            for (Answer answer : copiedAnswerHeader.getAnswers()) {
                answer.setId(null);
            }
            updateAnswerHeaders.add(copiedAnswerHeader);
        }
        this.businessObjectService.save(updateAnswerHeaders);
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForm form, ActionForward forward, CoiUserRole coiUserRole, String actionTaken) {
        CoiDisclosureForm coiDisclosureForm = (CoiDisclosureForm)form;
        CoiDisclosureDocument coiDisclosureDocument = coiDisclosureForm.getCoiDisclosureDocument();
        CoiNotificationContext context = new CoiNotificationContext(coiDisclosureDocument.getCoiDisclosure(), "205", "Assign Reviewer", (NotificationRenderer)new AssignReviewerNotificationRenderer(coiDisclosureDocument.getCoiDisclosure(), actionTaken));
        NotificationHelper coiNotificationHelper = coiDisclosureForm.getNotificationHelper();
        coiNotificationHelper.initializeDefaultValues((NotificationContext)context);
        NotificationTypeRecipient notificationRecipient = new NotificationTypeRecipient();
        notificationRecipient.setPersonId(coiUserRole.getPerson().getPersonId());
        coiNotificationHelper.getNotificationRecipients().add(notificationRecipient);
        if (coiNotificationHelper.getPromptUserForNotificationEditor((NotificationContext)context)) {
            forward = mapping.findForward("coiDisclosureNotificationEditor");
        } else {
            this.getKcNotificationService().sendNotificationAndPersist((NotificationContext)context, (KcNotification)new CoiNotification(), coiNotificationHelper.getNotificationRecipients(), (KraPersistableBusinessObjectBase)coiDisclosureDocument.getCoiDisclosure());
        }
        return forward;
    }

    public void sendNotification(CoiDisclosure disclosure, String actionType, String actionTaken) {
        CoiNotificationContext context = new CoiNotificationContext(disclosure, actionType, actionTaken, (NotificationRenderer)new CoiNotificationRenderer(disclosure));
        this.getKcNotificationService().sendNotificationAndPersist((NotificationContext)context, (KcNotification)new CoiNotification(), (KraPersistableBusinessObjectBase)disclosure);
    }

    protected void setDisclosureReviewStatus(CoiDisclosure disclosure, String reviewStatusCode) {
        disclosure.setReviewStatusCode(reviewStatusCode);
        disclosure.refreshReferenceObject("coiReviewStatus");
    }

    protected void resetDisclosureReviewStatus(CoiDisclosure disclosure) {
        if (disclosure.getCoiUserRoles().size() == 0) {
            if (StringUtils.equals((String)disclosure.getCoiDisclosureStatus().getCoiDisclosureStatusCode(), (String)"2")) {
                this.setDisclosureReviewStatus(disclosure, "2");
            } else {
                this.setDisclosureReviewStatus(disclosure, "1");
            }
        }
    }

    public void tagUserRolesToCompleteReview(List<CoiUserRole> completeUserRoles) {
        String loggedInUser = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        for (CoiUserRole coiUserRole : completeUserRoles) {
            if (coiUserRole.getPerson().getPersonId().equals(loggedInUser)) continue;
            coiUserRole.setMarkedToCompleteReview(false);
        }
    }

    public void completeCoiReview(CoiDisclosure disclosure) {
        List coiUserRoles = disclosure.getCoiUserRoles();
        String reviewStatus = "4";
        for (CoiUserRole coiUserRole : coiUserRoles) {
            if (coiUserRole.isMarkedToCompleteReview()) {
                String newCoiRecomendedTypeCode;
                String oldCoiRecomendedTypeCode = coiUserRole.getOldCoiRecomendedTypeCode() == null ? "" : coiUserRole.getOldCoiRecomendedTypeCode();
                String string = newCoiRecomendedTypeCode = coiUserRole.getCoiRecomendedTypeCode() == null ? "" : coiUserRole.getCoiRecomendedTypeCode();
                if (!oldCoiRecomendedTypeCode.equals(newCoiRecomendedTypeCode)) {
                    if (org.kuali.rice.krad.util.ObjectUtils.isNotNull((Object)coiUserRole.getCoiRecomendedTypeCode())) {
                        coiUserRole.setReviewCompleted(true);
                        coiUserRole.setDateCompleted(new Date(System.currentTimeMillis()));
                    } else {
                        coiUserRole.setReviewCompleted(false);
                        coiUserRole.setDateCompleted(null);
                    }
                    coiUserRole.setEditable(true);
                }
                for (CoiDisclProject project : disclosure.getCoiDisclProjects()) {
                    for (CoiDiscDetail detail : project.getCoiDiscDetails()) {
                        if (!ObjectUtils.equals((Object)detail.getOldEntityDispositionCode(), (Object)detail.getEntityDispositionCode())) continue;
                        detail.setUpdateUser(GlobalVariables.getUserSession().getPerson().getPrincipalName());
                        this.businessObjectService.save((PersistableBusinessObject)detail);
                        detail.setOldEntityDispositionCode();
                    }
                }
            }
            if (coiUserRole.isReviewCompleted()) continue;
            reviewStatus = "3";
        }
        this.setDisclosureReviewStatus(disclosure, reviewStatus);
        this.businessObjectService.save((PersistableBusinessObject)disclosure);
    }

    public void updateDisclosureReviewStatus(CoiDisclosure coiDisclosure) {
        this.businessObjectService.save((PersistableBusinessObject)coiDisclosure);
        coiDisclosure.refreshReferenceObject("coiReviewStatus");
    }

    public boolean isDisclosureReviewComplete(List<CoiUserRole> completeUserRoles) {
        boolean allReviewsComplete = true;
        for (CoiUserRole coiUserRole : completeUserRoles) {
            if (coiUserRole.isReviewCompleted()) continue;
            allReviewsComplete = false;
            break;
        }
        return allReviewsComplete;
    }
}

