/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.auth;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiUserRole;
import org.kuali.kra.coi.auth.CoiDisclosureAuthorizer;
import org.kuali.kra.coi.auth.CoiDisclosureTask;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.RoleService;

public abstract class CoiDeleteUpdateNotesAttachmentsAuthorizerBase
extends CoiDisclosureAuthorizer {
    public boolean isAuthorized(String userId, CoiDisclosureTask task, String updateUser) {
        Principal user = this.getIdentityService().getPrincipal(userId);
        String currentUser = user.getPrincipalName();
        if (!StringUtils.equalsIgnoreCase((String)updateUser, (String)currentUser)) {
            if (this.isAdministrator(userId)) {
                if (!this.isReviewer(updateUser, task.getCoiDisclosure()) && !this.isAdministrator(updateUser)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean isAdministrator(String userId) {
        Collection ids = this.getRoleService().getRoleMemberPrincipalIds("KC-COIDISCLOSURE", "COI Administrator", null);
        return ids.contains(userId);
    }

    protected boolean isReviewer(String userId, CoiDisclosure disclosure) {
        List userRoles = disclosure.getCoiUserRoles();
        for (CoiUserRole userRole : userRoles) {
            if (!StringUtils.equalsIgnoreCase((String)userRole.getRoleName(), (String)"COI Reviewer") || !StringUtils.equalsIgnoreCase((String)userId, (String)userRole.getUserId())) continue;
            return true;
        }
        return false;
    }

    public abstract IdentityService getIdentityService();

    public abstract RoleService getRoleService();
}

