/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.disclosure;

import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosureEventType;
import org.kuali.kra.coi.disclosure.AddManualProjectEvent;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AddManualProjectRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<AddManualProjectEvent> {
    private static final String DISCLOSURE_EVENT_TYPE = "disclosureEventType";

    public boolean processRules(AddManualProjectEvent event) {
        boolean valid = true;
        CoiDisclProject coiDisclProject = event.getCoiDisclProject();
        GlobalVariables.getMessageMap().addToErrorPath(event.getPropertyName());
        DataDictionaryService dataDictionaryService = (DataDictionaryService)KraServiceLocator.getService(DataDictionaryService.class);
        String eventTypeId = coiDisclProject.getDisclosureEventType();
        if (StringUtils.isNotBlank((String)eventTypeId)) {
            CoiDisclosureEventType disclosureEventType = this.getDisclosureEventType(eventTypeId);
            if (disclosureEventType != null) {
                valid = this.validateRequiredFields(coiDisclProject, disclosureEventType);
                valid &= this.isValidProjectId(coiDisclProject);
            }
        } else {
            GlobalVariables.getMessageMap().putError(DISCLOSURE_EVENT_TYPE, "error.required", new String[]{"Event Type (Event Type)"});
            valid = false;
        }
        return valid;
    }

    protected boolean isValidProjectId(CoiDisclProject coiDisclProject) {
        boolean isValid = true;
        String eventDisclosureNumber = coiDisclProject.getCoiDisclosureNumber();
        String eventType = coiDisclProject.getDisclosureEventType();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("coiProjectId", coiDisclProject.getCoiProjectId());
        criteria.put(DISCLOSURE_EVENT_TYPE, eventType);
        criteria.put("coiDisclosureNumber", eventDisclosureNumber);
        List projects = (List)this.getBusinessObjectService().findMatching(CoiDisclProject.class, criteria);
        for (CoiDisclProject project : projects) {
            GlobalVariables.getMessageMap().putError("coiProjectId", "error.coi.duplicate.projectid", new String[]{"(" + coiDisclProject.getCoiProjectId() + ")"});
            isValid = false;
        }
        return isValid;
    }

    private boolean validateRequiredFields(CoiDisclProject coiDisclProject, CoiDisclosureEventType disclosureEventType) {
        boolean valid = true;
        valid &= this.validateRequiredField("coiProjectId", coiDisclProject.getCoiProjectId(), disclosureEventType.getProjectIdLabel());
        valid &= this.validateRequiredField("coiProjectTitle", coiDisclProject.getCoiProjectTitle(), disclosureEventType.getProjectTitleLabel());
        if (disclosureEventType.isUseShortTextField1() && disclosureEventType.isRequireShortTextField1()) {
            valid &= this.validateRequiredField("shortTextField1", coiDisclProject.getShortTextField1(), disclosureEventType.getShortTextField1Label());
        }
        if (disclosureEventType.isUseShortTextField2() && disclosureEventType.isRequireShortTextField2()) {
            valid &= this.validateRequiredField("shortTextField2", coiDisclProject.getShortTextField2(), disclosureEventType.getShortTextField2Label());
        }
        if (disclosureEventType.isUseShortTextField3() && disclosureEventType.isRequireShortTextField3()) {
            valid &= this.validateRequiredField("shortTextField3", coiDisclProject.getShortTextField3(), disclosureEventType.getShortTextField3Label());
        }
        if (disclosureEventType.isUseLongTextField1() && disclosureEventType.isRequireLongTextField1()) {
            valid &= this.validateRequiredField("longTextField1", coiDisclProject.getLongTextField1(), disclosureEventType.getLongTextField1Label());
        }
        if (disclosureEventType.isUseLongTextField2() && disclosureEventType.isRequireLongTextField2()) {
            valid &= this.validateRequiredField("longTextField2", coiDisclProject.getLongTextField2(), disclosureEventType.getLongTextField2Label());
        }
        if (disclosureEventType.isUseLongTextField3() && disclosureEventType.isRequireLongTextField3()) {
            valid &= this.validateRequiredField("longTextField3", coiDisclProject.getLongTextField3(), disclosureEventType.getLongTextField3Label());
        }
        if (disclosureEventType.isUseDateField1() && disclosureEventType.isRequireDateField1()) {
            valid &= this.validateRequiredDateField("dateField1", coiDisclProject.getDateField1(), disclosureEventType.getDateField1Label());
        }
        if (disclosureEventType.isUseDateField2() && disclosureEventType.isRequireDateField2()) {
            valid &= this.validateRequiredDateField("dateField2", coiDisclProject.getDateField2(), disclosureEventType.getDateField2Label());
        }
        if (disclosureEventType.isUseNumberField1() && disclosureEventType.isRequireNumberField1()) {
            valid &= this.validateRequiredNumberField("numberField1", coiDisclProject.getNumberField1(), disclosureEventType.getNumberField1Label());
        }
        if (disclosureEventType.isUseNumberField2() && disclosureEventType.isRequireNumberField2()) {
            valid &= this.validateRequiredNumberField("numberField2", coiDisclProject.getNumberField2(), disclosureEventType.getNumberField2Label());
        }
        if (disclosureEventType.isUseSelectBox1() && disclosureEventType.isRequireSelectBox1()) {
            valid &= this.validateRequiredField("selectBox1", coiDisclProject.getSelectBox1(), disclosureEventType.getSelectBox1Label());
        }
        return valid;
    }

    private boolean validateRequiredField(String fieldName, String fieldValue, String fieldLabel) {
        boolean valid = true;
        if (StringUtils.isBlank((String)fieldValue)) {
            valid = false;
            GlobalVariables.getMessageMap().putError(fieldName, "error.required", new String[]{fieldLabel + " (" + fieldLabel + ")"});
        }
        return valid;
    }

    private boolean validateRequiredDateField(String fieldName, Date fieldValue, String fieldLabel) {
        boolean valid = true;
        if (fieldValue == null) {
            valid = false;
            GlobalVariables.getMessageMap().putError(fieldName, "error.required", new String[]{fieldLabel + " (" + fieldLabel + ")"});
        }
        return valid;
    }

    private boolean validateRequiredNumberField(String fieldName, KualiDecimal fieldValue, String fieldLabel) {
        boolean valid = true;
        if (fieldValue == null) {
            valid = false;
            GlobalVariables.getMessageMap().putError(fieldName, "error.required", new String[]{fieldLabel + " (" + fieldLabel + ")"});
        }
        return valid;
    }

    private CoiDisclosureEventType getDisclosureEventType(String eventTypeId) {
        CoiDisclosureEventType discEventType = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("eventTypeCode", eventTypeId);
        List disclEventTypes = (List)this.getBusinessObjectService().findMatching(CoiDisclosureEventType.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)disclEventTypes)) {
            discEventType = (CoiDisclosureEventType)disclEventTypes.get(0);
        }
        return discEventType;
    }
}

