/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.disclosure;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.coi.CoiDispositionStatus;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class CoiDisclosureAdministratorActionRule {
    private static final String ADMIN_ERRORS = "coiAdminActionErrors";

    public boolean isValidStatus(String disclosureStatus, String dispositionStatus) {
        return this.isValidStatus(disclosureStatus, this.convertDispositionStatus(dispositionStatus));
    }

    public boolean isValidStatus(String disclosureStatus, Integer dispositionStatus) {
        CoiDispositionStatus disposition;
        boolean isValid = true;
        if (StringUtils.isBlank((String)disclosureStatus)) {
            GlobalVariables.getMessageMap().putError(ADMIN_ERRORS, "error.coi.disclosure.status.required", new String[0]);
            isValid = false;
        }
        if (dispositionStatus == null) {
            GlobalVariables.getMessageMap().putError(ADMIN_ERRORS, "error.coi.disposition.status.required", new String[0]);
            isValid = false;
        }
        if ((disposition = (CoiDispositionStatus)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findBySinglePrimaryKey(CoiDispositionStatus.class, (Object)dispositionStatus)) == null) {
            GlobalVariables.getMessageMap().putError(ADMIN_ERRORS, "error.coi.disposition.status.required", new String[0]);
            isValid = false;
        }
        if (StringUtils.equals((String)disposition.getCoiDisclosureStatusCode(), (String)"4") && !StringUtils.equals((String)disclosureStatus, (String)"4")) {
            GlobalVariables.getMessageMap().putError(ADMIN_ERRORS, "error.coi.disclosure.status.invalid", new String[0]);
            isValid = false;
        }
        return isValid;
    }

    public boolean isValidDispositionStatus(String dispositionStatus) {
        return this.isValidDispositionStatus(this.convertDispositionStatus(dispositionStatus));
    }

    public boolean isValidDispositionStatus(Integer dispositionStatus) {
        boolean isValid = true;
        if (dispositionStatus == null) {
            GlobalVariables.getMessageMap().putError("document.coiDisclosureList[0].coiDisclProjects[0].disclosureDispositionCode", "error.coi.disposition.status.required", new String[0]);
            isValid = false;
        }
        return isValid;
    }

    protected Integer convertDispositionStatus(String dispositionStatus) {
        return dispositionStatus != null ? Integer.valueOf(dispositionStatus) : null;
    }
}

