/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.disclosure;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kra.coi.CoiDiscDetail;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.notesandattachments.attachments.CoiDisclosureAttachment;
import org.kuali.kra.coi.notesandattachments.notes.CoiDisclosureNotepad;
import org.kuali.kra.coi.questionnaire.DisclProjectQuestionnaireHelper;
import org.kuali.kra.questionnaire.answer.AnswerHeader;

public class CoiDisclosureProjectBean
implements Serializable {
    private static final long serialVersionUID = -100427824220789523L;
    private CoiDisclProject coiDisclProject = new CoiDisclProject();
    private CoiDisclosure coiDisclosure;
    private String projectName;
    private String projectId;
    private Date approvalDate;
    private List<CoiDisclosureAttachment> projectDiscAttachments = new ArrayList();
    private List<CoiDisclosureNotepad> projectDiscNotepads = new ArrayList();
    private DisclProjectQuestionnaireHelper projectQuestionnaireHelper;
    private boolean excludeFE;

    public CoiDisclProject getCoiDisclProject() {
        return this.coiDisclProject;
    }

    public void setCoiDisclProject(CoiDisclProject coiDisclProject) {
        this.coiDisclProject = coiDisclProject;
    }

    public CoiDisclosure getCoiDisclosure() {
        if (this.coiDisclosure == null) {
            this.coiDisclosure = this.getOriginalCoiDisclosure();
        }
        return this.coiDisclosure;
    }

    private CoiDisclosure getOriginalCoiDisclosure() {
        List projectDiscDetails = this.coiDisclProject.getCoiDiscDetails();
        if (CollectionUtils.isNotEmpty((Collection)projectDiscDetails)) {
            if (((CoiDiscDetail)projectDiscDetails.get(0)).getOriginalCoiDisclosure() == null) {
                return ((CoiDiscDetail)projectDiscDetails.get(0)).getCoiDisclosure();
            }
            return ((CoiDiscDetail)projectDiscDetails.get(0)).getOriginalCoiDisclosure();
        }
        return null;
    }

    public void setCoiDisclosure(CoiDisclosure coiDisclosure) {
        this.coiDisclosure = coiDisclosure;
    }

    public String getProjectName() {
        if (this.getCoiDisclosure().isAnnualEvent() || this.getCoiDisclosure().isUpdateEvent()) {
            return null;
        }
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public boolean isCurrentProject() {
        List projectDiscDetails = this.coiDisclProject.getCoiDiscDetails();
        if (CollectionUtils.isNotEmpty((Collection)projectDiscDetails)) {
            return ((CoiDiscDetail)projectDiscDetails.get(0)).getOriginalCoiDisclosure() == null;
        }
        return false;
    }

    public String getProjectId() {
        if (this.getCoiDisclosure().isAnnualEvent() || this.getCoiDisclosure().isUpdateEvent()) {
            return null;
        }
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = approvalDate;
    }

    public List<CoiDisclosureAttachment> getProjectDiscAttachments() {
        return this.projectDiscAttachments;
    }

    public void setProjectDiscAttachments(List<CoiDisclosureAttachment> projectDiscAttachments) {
        this.projectDiscAttachments = projectDiscAttachments;
    }

    public List<CoiDisclosureNotepad> getProjectDiscNotepads() {
        return this.projectDiscNotepads;
    }

    public void setProjectDiscNotepads(List<CoiDisclosureNotepad> projectDiscNotepads) {
        this.projectDiscNotepads = projectDiscNotepads;
    }

    public boolean isExcludeFE() {
        return this.excludeFE;
    }

    public void setExcludeFE(boolean excludeFE) {
        this.excludeFE = excludeFE;
    }

    public DisclProjectQuestionnaireHelper getProjectQuestionnaireHelper() {
        return this.projectQuestionnaireHelper;
    }

    public void setProjectQuestionnaireHelper(DisclProjectQuestionnaireHelper projectQuestionnaireHelper) {
        this.projectQuestionnaireHelper = projectQuestionnaireHelper;
    }

    public void populateAnswers(CoiDisclosure originalDisclosure) {
        this.projectQuestionnaireHelper = new DisclProjectQuestionnaireHelper(this.coiDisclProject, this.coiDisclProject.getCoiDisclosure(), originalDisclosure);
        this.projectQuestionnaireHelper.populateAnswers();
    }

    public void versionDisclosureAnswers(CoiDisclosure originalDisclosure) {
        this.projectQuestionnaireHelper = new DisclProjectQuestionnaireHelper(this.coiDisclProject, this.coiDisclProject.getCoiDisclosure(), originalDisclosure);
        this.projectQuestionnaireHelper.versionAnswers();
    }

    public List<AnswerHeader> getAnswerHeaders() {
        return this.getProjectQuestionnaireHelper().getAnswerHeaders();
    }
}

