/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.disclosure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.coi.CoiDiscDetail;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.CoiDisclosureForm;
import org.kuali.kra.coi.auth.CoiDisclosureTask;
import org.kuali.kra.coi.disclosure.CoiDisclosureService;
import org.kuali.kra.coi.disclosure.CoiGroupedMasterDisclosureBean;
import org.kuali.kra.coi.disclosure.DisclosurePerson;
import org.kuali.kra.coi.disclosure.DisclosurePersonUnit;
import org.kuali.kra.coi.disclosure.MasterDisclosureBean;
import org.kuali.kra.coi.notification.CoiNotification;
import org.kuali.kra.coi.personfinancialentity.FinEntityDataMatrixBean;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityService;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class DisclosureHelper
implements Serializable {
    private static final long serialVersionUID = -7441300028105575094L;
    protected static final String NAMESPACE_CODE = "KC-COIDISCLOSURE";
    protected static final String PARAMETER_CODE = "Document";
    private static final String CONFLICT_HEADER_LABEL_PARAMETER = "COI_DISCLOSURE_FE_CONFLICT_HEADER_LABEL";
    protected static final String DEFAULT_CONFLICT_HEADER_LABEL = "Related";
    private static final String ERROR_COI_ANNUAL_OPEN_DISCLOSURES_FOR_ADMIN = "error.coi.annual.open.disclosures.for.admin";
    private CoiDisclosureForm form;
    private DisclosurePersonUnit newDisclosurePersonUnit;
    private List<DisclosurePersonUnit> deletedUnits;
    private List<FinEntityDataMatrixBean> editRelationDetails;
    private List<FinEntityDataMatrixBean> newRelationDetails;
    private boolean canViewDisclosureFeHistory;
    private boolean canEditDisclosureFinancialEntity;
    private boolean canViewDisclosureCertification;
    private boolean canCertifyDisclosure;
    private boolean canUpdateFEStatusAdmin;
    private String conflictHeaderLabel;
    private CoiDisclProject newCoiDisclProject;
    private String protocolType;
    private List<Protocol> newProtocols;
    private List<IacucProtocol> newIacucProtocols;
    private Long newProtocolId;
    private Long newIacucProtocolId;
    private String newProposalNumber;
    private Long newAwardId;
    private List<DevelopmentProposal> newProposals;
    private List<InstitutionalProposal> newInstitutionalProposals;
    private List<Award> newAwards;
    private String newProjectId;
    private String newModuleItemKey;
    private String eventTypeCode;
    private String proposalType;
    private boolean modifyReporter;
    MasterDisclosureBean masterDisclosureBean;
    private CoiNotification viewNotification;
    private transient CoiDisclosureService disclosureService;
    private boolean unresolvedEventsPresent;
    private String annualCertApprovalErrorMsgForAdmin;
    private boolean disclosureGroupedByEvent;
    private List<CoiGroupedMasterDisclosureBean> allDisclosuresGroupedByProjects;

    public DisclosureHelper(CoiDisclosureForm form) {
        this.form = form;
        this.setNewDisclosurePersonUnit(new DisclosurePersonUnit());
        this.deletedUnits = new ArrayList();
        this.newRelationDetails = this.getFinancialEntityService().getFinancialEntityDataMatrix();
        this.editRelationDetails = new ArrayList();
        CoiDisclosure coiDisclosure = form.getCoiDisclosureDocument().getCoiDisclosure();
        this.newCoiDisclProject = new CoiDisclProject(coiDisclosure.getCoiDisclosureNumber(), coiDisclosure.getSequenceNumber());
        this.newProtocols = new ArrayList();
        this.newIacucProtocols = new ArrayList();
        this.initConflictHeaderLabel();
        this.setDisclosureGroupedByEvent(true);
        this.setAllDisclosuresGroupedByProjects(new ArrayList());
    }

    public CoiDisclosureForm getForm() {
        return this.form;
    }

    public void prepareView() {
        this.initializePermissions(this.getCoiDisclosure());
        this.initializeOldFeStatii();
        this.checkForUnresolvedEvents();
    }

    private void initializePermissions(CoiDisclosure coiDisclosure) {
        this.initializeModifyCoiDisclosurePermission(coiDisclosure);
        this.canEditDisclosureFinancialEntity = this.hasCanEditDisclosureFinancialEntityPermission(coiDisclosure);
        this.canViewDisclosureFeHistory = this.canEditDisclosureFinancialEntity || this.hasCanViewDisclosureFeHistoryPermission(coiDisclosure);
        this.canViewDisclosureCertification = this.hasCanViewDisclosureCertificationPermission();
        this.canCertifyDisclosure = this.hasCanCertifyDisclosurePermission();
        this.canUpdateFEStatusAdmin = this.hasCanUpdateFEStatusAdmin();
    }

    private void initializeOldFeStatii() {
        for (CoiDisclProject project : this.getCoiDisclosure().getCoiDisclProjects()) {
            for (CoiDiscDetail detail : project.getCoiDiscDetails()) {
                detail.setOldEntityDispositionCode();
            }
        }
    }

    private boolean isDispositionWellResolved(String dispCode) {
        boolean retVal = false;
        if ("215".equals(dispCode) || "211".equals(dispCode) || "220".equals(dispCode) || "230".equals(dispCode) || "240".equals(dispCode) || "210".equals(dispCode) || "200".equals(dispCode)) {
            retVal = true;
        }
        return retVal;
    }

    private void checkForUnresolvedEvents() {
        this.unresolvedEventsPresent = false;
        if (this.getCoiDisclosure().isAnnualEvent() || this.getCoiDisclosure().isAnnualUpdate()) {
            List disclosures = this.getDisclosureService().getAllDisclosuresForUser(this.getCoiDisclosure().getPersonId());
            for (CoiDisclosure disclosure : disclosures) {
                if (disclosure.isAnnualEvent() || disclosure.isAnnualUpdate() || disclosure.isExcludedFromAnnual() || "4".equals(disclosure.getDisclosureStatusCode()) || this.isDispositionWellResolved(disclosure.getDisclosureDispositionCode())) continue;
                this.unresolvedEventsPresent = true;
                if (this.annualCertApprovalErrorMsgForAdmin == null) {
                    this.annualCertApprovalErrorMsgForAdmin = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(ERROR_COI_ANNUAL_OPEN_DISCLOSURES_FOR_ADMIN);
                    this.annualCertApprovalErrorMsgForAdmin = this.annualCertApprovalErrorMsgForAdmin.replace("{0}", this.getCoiDisclosure().getDisclosureReporter().getReporter().getFullName());
                }
                break;
            }
        } else {
            this.annualCertApprovalErrorMsgForAdmin = null;
        }
    }

    private void initializeModifyCoiDisclosurePermission(CoiDisclosure coiDisclosure) {
        CoiDisclosureTask task = new CoiDisclosureTask("modifyCoiDisclosure", coiDisclosure);
        this.modifyReporter = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    private String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public CoiDisclosure getCoiDisclosure() {
        CoiDisclosureDocument document = this.form.getCoiDisclosureDocument();
        if (document == null || document.getCoiDisclosure() == null) {
            throw new IllegalArgumentException("invalid (null) CoiDisclosureDocument in ProtocolForm");
        }
        return document.getCoiDisclosure();
    }

    private TaskAuthorizationService getTaskAuthorizationService() {
        return (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    public void setForm(CoiDisclosureForm form) {
        this.form = form;
    }

    public DisclosurePersonUnit getNewDisclosurePersonUnit() {
        return this.newDisclosurePersonUnit;
    }

    public void setNewDisclosurePersonUnit(DisclosurePersonUnit newDisclosurePersonUnit) {
        this.newDisclosurePersonUnit = newDisclosurePersonUnit;
        DisclosurePerson disclosurePerson = null;
        disclosurePerson = CollectionUtils.isEmpty((Collection)((CoiDisclosureDocument)this.form.getDocument()).getCoiDisclosure().getDisclosurePersons()) ? ((CoiDisclosureDocument)this.form.getDocument()).getCoiDisclosure().getDisclosureReporter() : (DisclosurePerson)((CoiDisclosureDocument)this.form.getDocument()).getCoiDisclosure().getDisclosurePersons().get(0);
        this.newDisclosurePersonUnit.setDisclosurePersonId(disclosurePerson.getDisclosurePersonId());
        this.newDisclosurePersonUnit.setDisclosurePerson(disclosurePerson);
        this.newDisclosurePersonUnit.setPersonId(disclosurePerson.getPersonId());
    }

    public List<DisclosurePersonUnit> getDeletedUnits() {
        return this.deletedUnits;
    }

    public void setDeletedUnits(List<DisclosurePersonUnit> deletedUnits) {
        this.deletedUnits = deletedUnits;
    }

    public List<FinEntityDataMatrixBean> getEditRelationDetails() {
        return this.editRelationDetails;
    }

    public void setEditRelationDetails(List<FinEntityDataMatrixBean> editRelationDetails) {
        this.editRelationDetails = editRelationDetails;
    }

    public List<FinEntityDataMatrixBean> getNewRelationDetails() {
        return this.newRelationDetails;
    }

    public void setNewRelationDetails(List<FinEntityDataMatrixBean> newRelationDetails) {
        this.newRelationDetails = newRelationDetails;
    }

    private FinancialEntityService getFinancialEntityService() {
        return (FinancialEntityService)KraServiceLocator.getService(FinancialEntityService.class);
    }

    public boolean isCanViewDisclosureFeHistory() {
        return this.canViewDisclosureFeHistory;
    }

    public void setCanViewDisclosureFeHistory(boolean canViewDisclosureFeHistory) {
        this.canViewDisclosureFeHistory = canViewDisclosureFeHistory;
    }

    public boolean isCanViewDisclosureCertification() {
        return this.canViewDisclosureCertification;
    }

    public boolean isCanCertifyDisclosure() {
        return this.canCertifyDisclosure;
    }

    public boolean isCanUpdateFEStatusAdmin() {
        return (this.getCoiDisclosure().isUnderReview() || this.getCoiDisclosure().isSubmittedForReview()) && this.canUpdateFEStatusAdmin;
    }

    private boolean hasCanViewDisclosureFeHistoryPermission(CoiDisclosure coiDisclosure) {
        CoiDisclosureTask task = new CoiDisclosureTask("viewCoiDisclosure", coiDisclosure);
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    private boolean hasCanViewDisclosureCertificationPermission() {
        CoiDisclosureTask task = new CoiDisclosureTask("viewCoiDisclosure", this.getCoiDisclosure());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    private boolean hasCanUpdateFEStatusAdmin() {
        CoiDisclosureTask task = new CoiDisclosureTask("updateFEStatusAdmin", this.getCoiDisclosure());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    private boolean hasCanCertifyDisclosurePermission() {
        return this.getCoiDisclosure().getPersonId() == null || StringUtils.equals((String)this.getCoiDisclosure().getPersonId(), (String)GlobalVariables.getUserSession().getPrincipalId());
    }

    public boolean isCanEditDisclosureFinancialEntity() {
        return this.canEditDisclosureFinancialEntity;
    }

    public void setCanEditDisclosureFinancialEntity(boolean canEditDisclosureFinancialEntity) {
        this.canEditDisclosureFinancialEntity = canEditDisclosureFinancialEntity;
    }

    private boolean hasCanEditDisclosureFinancialEntityPermission(CoiDisclosure coiDisclosure) {
        CoiDisclosureTask task = new CoiDisclosureTask("modifyCoiDisclosure", coiDisclosure);
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    public String getConflictHeaderLabel() {
        if (StringUtils.isBlank((String)this.conflictHeaderLabel)) {
            this.initConflictHeaderLabel();
        }
        return this.conflictHeaderLabel;
    }

    public void setConflictHeaderLabel(String conflictHeaderLabel) {
        this.conflictHeaderLabel = conflictHeaderLabel;
    }

    private void initConflictHeaderLabel() {
        String param = DEFAULT_CONFLICT_HEADER_LABEL;
        try {
            param = this.getParameterService().getParameterValueAsString(NAMESPACE_CODE, PARAMETER_CODE, CONFLICT_HEADER_LABEL_PARAMETER);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConflictHeaderLabel(param);
    }

    private ParameterService getParameterService() {
        return (ParameterService)KraServiceLocator.getService(ParameterService.class);
    }

    public CoiDisclProject getNewCoiDisclProject() {
        return this.newCoiDisclProject;
    }

    public void setNewCoiDisclProject(CoiDisclProject newCoiDisclProject) {
        this.newCoiDisclProject = newCoiDisclProject;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public void setProtocolType(String protocolType) {
        this.protocolType = protocolType;
    }

    public List<Protocol> getNewProtocols() {
        return this.newProtocols;
    }

    public void setNewProtocols(List<Protocol> newProtocols) {
        this.newProtocols = newProtocols;
    }

    public Long getNewProtocolId() {
        return this.newProtocolId;
    }

    public void setNewProtocolId(Long newProtocolId) {
        this.newProtocolId = newProtocolId;
    }

    public List<IacucProtocol> getNewIacucProtocols() {
        return this.newIacucProtocols;
    }

    public void setNewIacucProtocols(List<IacucProtocol> newIacucProtocols) {
        this.newIacucProtocols = newIacucProtocols;
    }

    public Long getNewIacucProtocolId() {
        return this.newIacucProtocolId;
    }

    public void setNewIacucProtocolId(Long newIacucProtocolId) {
        this.newIacucProtocolId = newIacucProtocolId;
    }

    public String getNewProposalNumber() {
        return this.newProposalNumber;
    }

    public void setNewProposalNumber(String newProposalNumber) {
        this.newProposalNumber = newProposalNumber;
    }

    public Long getNewAwardId() {
        return this.newAwardId;
    }

    public void setNewAwardId(Long newAwardId) {
        this.newAwardId = newAwardId;
    }

    public List<DevelopmentProposal> getNewProposals() {
        return this.newProposals;
    }

    public void setNewProposals(List<DevelopmentProposal> newProposals) {
        this.newProposals = newProposals;
    }

    public List<Award> getNewAwards() {
        return this.newAwards;
    }

    public void setNewAwards(List<Award> newAwards) {
        this.newAwards = newAwards;
    }

    public String getNewProjectId() {
        return this.newProjectId;
    }

    public void setNewProjectId(String newProjectId) {
        this.newProjectId = newProjectId;
    }

    public List<InstitutionalProposal> getNewInstitutionalProposals() {
        return this.newInstitutionalProposals;
    }

    public void setNewInstitutionalProposals(List<InstitutionalProposal> newInstitutionalProposals) {
        this.newInstitutionalProposals = newInstitutionalProposals;
    }

    public String getProposalType() {
        return this.proposalType;
    }

    public void setProposalType(String proposalType) {
        this.proposalType = proposalType;
    }

    public boolean isModifyReporter() {
        return this.modifyReporter;
    }

    public void setModifyReporter(boolean modifyReporter) {
        this.modifyReporter = modifyReporter;
    }

    public String getEventTypeCode() {
        return this.eventTypeCode;
    }

    public void setEventTypeCode(String eventTypeCode) {
        this.eventTypeCode = eventTypeCode;
    }

    public String getNewModuleItemKey() {
        return this.newModuleItemKey;
    }

    public void setNewModuleItemKey(String newModuleItemKey) {
        this.newModuleItemKey = newModuleItemKey;
    }

    public MasterDisclosureBean getMasterDisclosureBean() {
        return this.masterDisclosureBean;
    }

    public void setMasterDisclosureBean(MasterDisclosureBean masterDisclosureBean) {
        this.masterDisclosureBean = masterDisclosureBean;
    }

    public boolean isIsMasterDisclosure() {
        return this.getMasterDisclosureBean() != null;
    }

    public CoiNotification getViewNotification() {
        return this.viewNotification;
    }

    public void setViewNotification(CoiNotification viewNotification) {
        this.viewNotification = viewNotification;
    }

    private CoiDisclosureService getDisclosureService() {
        if (this.disclosureService == null) {
            this.disclosureService = (CoiDisclosureService)KraServiceLocator.getService(CoiDisclosureService.class);
        }
        return this.disclosureService;
    }

    public boolean isUnresolvedEventsPresent() {
        return this.unresolvedEventsPresent;
    }

    public void setUnresolvedEventsPresent(boolean unresolvedEventsPresent) {
        this.unresolvedEventsPresent = unresolvedEventsPresent;
    }

    public String getAnnualCertApprovalErrorMsgForAdmin() {
        return this.annualCertApprovalErrorMsgForAdmin;
    }

    public boolean isDisclosedProjectsPresent() {
        return this.getAllDisclosuresGroupedByProjects().size() > 0;
    }

    public boolean isFinancialEntitiesPresent() {
        boolean entitiesPresent = false;
        List disclosureProjects = this.getCoiDisclosure().getCoiDisclProjects();
        if (!disclosureProjects.isEmpty() && !((CoiDisclProject)disclosureProjects.get(0)).getCoiDiscDetails().isEmpty()) {
            entitiesPresent = ((CoiDiscDetail)((CoiDisclProject)disclosureProjects.get(0)).getCoiDiscDetails().get(0)).getPersonFinIntDisclosure() != null;
        }
        return entitiesPresent;
    }

    public List<CoiGroupedMasterDisclosureBean> getAllDisclosuresGroupedByProjects() {
        if (this.allDisclosuresGroupedByProjects.isEmpty()) {
            this.setAllDisclosuresGroupedByProjects(this.getDisclosureService().getUndisclosedProjectsGroupedByEvent(this.getCoiDisclosure().getCoiDisclProjects()));
        }
        return this.allDisclosuresGroupedByProjects;
    }

    public boolean isDisclosureGroupedByEvent() {
        return this.disclosureGroupedByEvent;
    }

    public void setDisclosureGroupedByEvent(boolean disclosureGroupedByEvent) {
        this.disclosureGroupedByEvent = disclosureGroupedByEvent;
    }

    public void setAllDisclosuresGroupedByProjects(List<CoiGroupedMasterDisclosureBean> allDisclosuresGroupedByProjects) {
        this.allDisclosuresGroupedByProjects = allDisclosuresGroupedByProjects;
    }
}

