/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.disclosure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureEventType;
import org.kuali.kra.coi.disclosure.CoiDisclosureProjectBean;
import org.kuali.kra.coi.disclosure.CoiGroupedMasterDisclosureBean;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.rice.krad.service.BusinessObjectService;

public class MasterDisclosureBean
implements Serializable {
    private static final long serialVersionUID = 8636120108965638825L;
    private CoiDisclosure coiDisclosure;
    private List<CoiDisclosureProjectBean> awardProjects = new ArrayList();
    private List<CoiDisclosureProjectBean> proposalProjects = new ArrayList();
    private List<CoiDisclosureProjectBean> protocolProjects = new ArrayList();
    private List<CoiDisclosureProjectBean> iacucProtocolProjects = new ArrayList();
    private List<CoiDisclosureProjectBean> manualAwardProjects = new ArrayList();
    private List<CoiDisclosureProjectBean> manualProposalProjects = new ArrayList();
    private List<CoiDisclosureProjectBean> manualProtocolProjects = new ArrayList();
    private List<CoiDisclosureProjectBean> manualIacucProtocolProjects = new ArrayList();
    private List<CoiDisclosureProjectBean> manualTravelProjects = new ArrayList();
    private List<CoiDisclosureProjectBean> allProjects;
    private List<CoiDisclosureProjectBean> otherManualProjects = new ArrayList();
    private List<AnswerHeader> answerHeaders;
    private List<CoiDisclosureProjectBean> allDisclosureProjects;
    private List<CoiGroupedMasterDisclosureBean> allDisclosuresGroupedByProjects;
    private boolean disclosureGroupedByEvent;

    public MasterDisclosureBean() {
        this.allProjects = new ArrayList();
        this.setAllDisclosureProjects(new ArrayList());
        this.setAllDisclosuresGroupedByProjects(new ArrayList());
        this.setDisclosureGroupedByEvent(true);
    }

    public CoiDisclosure getCoiDisclosure() {
        return this.coiDisclosure;
    }

    public void setCoiDisclosure(CoiDisclosure coiDisclosure) {
        this.coiDisclosure = coiDisclosure;
    }

    public List<CoiDisclosureProjectBean> getAwardProjects() {
        return this.awardProjects;
    }

    public void setAwardProjects(List<CoiDisclosureProjectBean> awardProjects) {
        this.awardProjects = awardProjects;
    }

    public List<CoiDisclosureProjectBean> getProposalProjects() {
        return this.proposalProjects;
    }

    public void setProposalProjects(List<CoiDisclosureProjectBean> proposalProjects) {
        this.proposalProjects = proposalProjects;
    }

    public List<CoiDisclosureProjectBean> getProtocolProjects() {
        return this.protocolProjects;
    }

    public void setProtocolProjects(List<CoiDisclosureProjectBean> protocolProjects) {
        this.protocolProjects = protocolProjects;
    }

    public List<CoiDisclosureProjectBean> getIacucProtocolProjects() {
        return this.iacucProtocolProjects;
    }

    public void setIacucProtocolProjects(List<CoiDisclosureProjectBean> protocolProjects) {
        this.iacucProtocolProjects = protocolProjects;
    }

    public List<CoiDisclosureProjectBean> getManualAwardProjects() {
        return this.manualAwardProjects;
    }

    public void setManualAwardProjects(List<CoiDisclosureProjectBean> manualAwardProjects) {
        this.manualAwardProjects = manualAwardProjects;
    }

    public List<CoiDisclosureProjectBean> getManualProposalProjects() {
        return this.manualProposalProjects;
    }

    public void setManualProposalProjects(List<CoiDisclosureProjectBean> manualProposalProjects) {
        this.manualProposalProjects = manualProposalProjects;
    }

    public List<CoiDisclosureProjectBean> getManualProtocolProjects() {
        return this.manualProtocolProjects;
    }

    public void setManualProtocolProjects(List<CoiDisclosureProjectBean> manualProtocolProjects) {
        this.manualProtocolProjects = manualProtocolProjects;
    }

    public List<CoiDisclosureProjectBean> getManualIacucProtocolProjects() {
        return this.manualIacucProtocolProjects;
    }

    public void setManualIacucProtocolProjects(List<CoiDisclosureProjectBean> manualIacucProtocolProjects) {
        this.manualIacucProtocolProjects = manualIacucProtocolProjects;
    }

    public void addProject(CoiDisclosureProjectBean coiDisclosureProjectBean, String projectTypeCode) {
        int typeCode = Integer.parseInt(projectTypeCode);
        switch (typeCode) {
            case 1: {
                this.getAwardProjects().add(coiDisclosureProjectBean);
                coiDisclosureProjectBean.setExcludeFE(this.isEventExcludFE("1"));
                break;
            }
            case 2: {
                this.getProposalProjects().add(coiDisclosureProjectBean);
                coiDisclosureProjectBean.setExcludeFE(this.isEventExcludFE("2"));
                break;
            }
            case 3: {
                this.getProtocolProjects().add(coiDisclosureProjectBean);
                coiDisclosureProjectBean.setExcludeFE(this.isEventExcludFE("3"));
                break;
            }
            case 4: {
                this.getIacucProtocolProjects().add(coiDisclosureProjectBean);
                coiDisclosureProjectBean.setExcludeFE(this.isEventExcludFE("4"));
                break;
            }
            case 10: {
                this.getProposalProjects().add(coiDisclosureProjectBean);
                coiDisclosureProjectBean.setExcludeFE(this.isEventExcludFE("10"));
                break;
            }
            case 11: {
                this.getManualAwardProjects().add(coiDisclosureProjectBean);
                coiDisclosureProjectBean.setExcludeFE(this.isEventExcludFE("11"));
                break;
            }
            case 12: {
                this.getManualProposalProjects().add(coiDisclosureProjectBean);
                coiDisclosureProjectBean.setExcludeFE(this.isEventExcludFE("12"));
                break;
            }
            case 13: {
                this.getManualProtocolProjects().add(coiDisclosureProjectBean);
                coiDisclosureProjectBean.setExcludeFE(this.isEventExcludFE("13"));
                break;
            }
            case 15: {
                this.getManualTravelProjects().add(coiDisclosureProjectBean);
                coiDisclosureProjectBean.setExcludeFE(this.isEventExcludFE("15"));
                break;
            }
            case 16: {
                this.getManualIacucProtocolProjects().add(coiDisclosureProjectBean);
                coiDisclosureProjectBean.setExcludeFE(this.isEventExcludFE("16"));
                break;
            }
            default: {
                this.getOtherManualProjects().add(coiDisclosureProjectBean);
                coiDisclosureProjectBean.setExcludeFE(this.isEventExcludFE("" + typeCode));
            }
        }
        this.getAllDisclosureProjects().add(coiDisclosureProjectBean);
    }

    private boolean isEventExcludFE(String eventTypeCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("eventTypeCode", eventTypeCode);
        CoiDisclosureEventType coiDisclosureEventType = (CoiDisclosureEventType)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findByPrimaryKey(CoiDisclosureEventType.class, fieldValues);
        return coiDisclosureEventType == null ? false : coiDisclosureEventType.isExcludeFinancialEntities();
    }

    public List<CoiDisclosureProjectBean> getAllProjects() {
        return this.allProjects;
    }

    public void setAllProjects(List<CoiDisclosureProjectBean> allProjects) {
        this.allProjects = allProjects;
    }

    public List<List<CoiDisclosureProjectBean>> getProjectLists() {
        ArrayList<List<CoiDisclosureProjectBean>> projects = new ArrayList<List<CoiDisclosureProjectBean>>();
        projects.add(this.awardProjects);
        projects.add(this.proposalProjects);
        projects.add(this.protocolProjects);
        projects.add(this.iacucProtocolProjects);
        projects.add(this.manualAwardProjects);
        projects.add(this.manualProposalProjects);
        projects.add(this.manualProtocolProjects);
        projects.add(this.manualIacucProtocolProjects);
        projects.add(this.manualTravelProjects);
        projects.add(this.otherManualProjects);
        return projects;
    }

    public List<AnswerHeader> getAnswerHeaders() {
        return this.answerHeaders;
    }

    public void setAnswerHeaders(List<AnswerHeader> answerHeaders) {
        this.answerHeaders = answerHeaders;
    }

    public List<CoiDisclosureProjectBean> getManualTravelProjects() {
        return this.manualTravelProjects;
    }

    public void setManualTravelProjects(List<CoiDisclosureProjectBean> manualTravelProjects) {
        this.manualTravelProjects = manualTravelProjects;
    }

    public void setOtherManualProjects(List<CoiDisclosureProjectBean> otherManualProjects) {
        this.otherManualProjects = otherManualProjects;
    }

    public List<CoiDisclosureProjectBean> getOtherManualProjects() {
        return this.otherManualProjects;
    }

    public List<CoiGroupedMasterDisclosureBean> getAllDisclosuresGroupedByProjects() {
        return this.allDisclosuresGroupedByProjects;
    }

    public void setAllDisclosuresGroupedByProjects(List<CoiGroupedMasterDisclosureBean> allDisclosuresGroupedByProjects) {
        this.allDisclosuresGroupedByProjects = allDisclosuresGroupedByProjects;
    }

    public List<CoiDisclosureProjectBean> getAllDisclosureProjects() {
        return this.allDisclosureProjects;
    }

    public void setAllDisclosureProjects(List<CoiDisclosureProjectBean> allDisclosureProjects) {
        this.allDisclosureProjects = allDisclosureProjects;
    }

    public boolean isDisclosureGroupedByEvent() {
        return this.disclosureGroupedByEvent;
    }

    public void setDisclosureGroupedByEvent(boolean disclosureGroupedByEvent) {
        this.disclosureGroupedByEvent = disclosureGroupedByEvent;
    }
}

