/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.lookup;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.CoiDisclosureDocument;
import org.kuali.kra.coi.actions.CoiDisclosureActionService;
import org.kuali.kra.coi.lookup.CoiCustomSearchForm;
import org.kuali.kra.coi.lookup.CustomAdminSearchHelper;
import org.kuali.kra.coi.lookup.dao.CoiDisclosureDao;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class CoiCustomSearchAction
extends KualiAction {
    private CoiDisclosureDao coiDisclosureDao;
    private ParameterService parameterService;
    private CoiDisclosureActionService coiDisclosureActionService;
    private DocumentService documentService;
    private PermissionService permissionService;
    private KraAuthorizationService kraAuthorizationService;

    public ActionForward openCustomSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isAuthorizedForCoiLookups()) {
            CoiCustomSearchForm searchForm = (CoiCustomSearchForm)form;
            searchForm.setCanQuickApprove(this.getPermissionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-COIDISCLOSURE", "Approve Coi Disclosure"));
            CustomAdminSearchHelper helper = searchForm.getCustomAdminSearchHelper();
            helper.setAllOpenReviews(this.getOpenReviews());
            helper.setPendingReviews(this.getPendingReviews());
            helper.setInProgressReviews(this.getInProgressReviews());
            return mapping.findForward("basic");
        }
        return mapping.findForward("portal");
    }

    public ActionForward quickApproveDisclosure(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CoiCustomSearchForm searchForm = (CoiCustomSearchForm)form;
        CustomAdminSearchHelper helper = searchForm.getCustomAdminSearchHelper();
        String coiDisclosureDocumentNumber = this.getCoiDisclosureDocumentNumber(request);
        CoiDisclosureDocument coiDisclosureDocument = (CoiDisclosureDocument)this.getDocumentService().getByDocumentHeaderId(coiDisclosureDocumentNumber);
        if (!helper.hasFinEnt(coiDisclosureDocument.getCoiDisclosure()) && this.getKraAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), (Permissionable)coiDisclosureDocument.getCoiDisclosure(), "Approve Coi Disclosure")) {
            this.getCoiDisclosureActionService().approveDisclosure(coiDisclosureDocument.getCoiDisclosure(), "210");
            GlobalVariables.getMessageMap().putInfo("noField", "message.coi.quick.approved", new String[0]);
        } else {
            GlobalVariables.getMessageMap().putError("noField", "error.coi.nopermission.approve", new String[0]);
        }
        helper.setAllOpenReviews(this.getOpenReviews());
        helper.setPendingReviews(this.getPendingReviews());
        helper.setInProgressReviews(this.getInProgressReviews());
        return mapping.findForward("basic");
    }

    protected List<CoiDisclosure> getOpenReviews() {
        return this.getCoiDisclosureDao().getReviewsForReviewStatuses(Arrays.asList("2", "3"));
    }

    protected List<CoiDisclosure> getPendingReviews() {
        return this.getCoiDisclosureDao().getReviewsForReviewStatuses(Arrays.asList("2"));
    }

    protected List<CoiDisclosure> getInProgressReviews() {
        Collection inProgressStatusCodes = this.getParameterService().getParameterValuesAsString(CoiDisclosureDocument.class, "WORK_IN_PROGRESS_REVIEW_STATUSES");
        return this.getCoiDisclosureDao().getReviewsForReviewStatuses(inProgressStatusCodes);
    }

    protected String getCoiDisclosureDocumentNumber(HttpServletRequest request) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            String documentNumber = StringUtils.substringBetween((String)parameterName, (String)".disclosureDocNbr", (String)".");
            if (StringUtils.isEmpty((String)documentNumber)) {
                return null;
            }
            return documentNumber;
        }
        return null;
    }

    protected CoiDisclosureDao getCoiDisclosureDao() {
        if (this.coiDisclosureDao == null) {
            this.coiDisclosureDao = (CoiDisclosureDao)KraServiceLocator.getService(CoiDisclosureDao.class);
        }
        return this.coiDisclosureDao;
    }

    public void setCoiDisclosureDao(CoiDisclosureDao coiDisclosureDao) {
        this.coiDisclosureDao = coiDisclosureDao;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected CoiDisclosureActionService getCoiDisclosureActionService() {
        if (this.coiDisclosureActionService == null) {
            this.coiDisclosureActionService = (CoiDisclosureActionService)KraServiceLocator.getService(CoiDisclosureActionService.class);
        }
        return this.coiDisclosureActionService;
    }

    public void setCoiDisclosureActionService(CoiDisclosureActionService coiDisclosureActionService) {
        this.coiDisclosureActionService = coiDisclosureActionService;
    }

    protected DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        }
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected KraAuthorizationService getKraAuthorizationService() {
        if (this.kraAuthorizationService == null) {
            this.kraAuthorizationService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        }
        return this.kraAuthorizationService;
    }

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = (PermissionService)KraServiceLocator.getService(PermissionService.class);
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected boolean isAuthorizedForCoiLookups() {
        ApplicationTask task = new ApplicationTask("lookupCoiDisclosures");
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    private String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }
}

