/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.util.StringUtils;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.auth.CoiDisclosureTask;
import org.kuali.kra.coi.lookup.CoiDisclosureLookupableHelperBase;
import org.kuali.rice.krad.bo.BusinessObject;

public class CoiSubmittedDisclosureLookupableHelper
extends CoiDisclosureLookupableHelperBase {
    private static final long serialVersionUID = 4999402404037030752L;
    private static final String LEAD_UNIT = "leadUnitNumber";

    public List<? extends BusinessObject> getLookupSpecificSearchResults(Map<String, String> fieldValues) {
        List allDisclosures = super.getResults(fieldValues);
        ArrayList<CoiDisclosure> submittedDisclosures = new ArrayList<CoiDisclosure>();
        for (CoiDisclosure disclosure : allDisclosures) {
            if (!disclosure.isSubmitted() || !this.disclosureCanBeDisplayed(disclosure, fieldValues)) continue;
            submittedDisclosures.add(disclosure);
        }
        return submittedDisclosures;
    }

    private boolean disclosureCanBeDisplayed(CoiDisclosure rawDisclosure, Map<String, String> fieldValues) {
        boolean displayDisclosure = false;
        String researcherLeadUnit = fieldValues.get(LEAD_UNIT);
        if (rawDisclosure.getCoiDisclosureDocument() != null) {
            CoiDisclosureTask task = new CoiDisclosureTask("viewCoiDisclosure", rawDisclosure);
            if (this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task) && (StringUtils.isEmpty((CharSequence)researcherLeadUnit) || researcherLeadUnit.equals(rawDisclosure.getLeadUnitNumber()))) {
                displayDisclosure = true;
            }
        }
        return displayDisclosure;
    }

    protected boolean isAuthorizedForCoiLookups() {
        return true;
    }
}

