/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.lookup;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.coi.CoiDisclProject;
import org.kuali.kra.coi.CoiDisclosure;

public class CustomAdminSearchHelper {
    private List<CoiDisclosure> allOpenReviews = new ArrayList();
    private List<CoiDisclosure> pendingReviews = new ArrayList();
    private List<CoiDisclosure> inProgressReviews = new ArrayList();

    protected List<CoiDisclosure> filterByFinEnt(List<CoiDisclosure> disclosures, boolean hasFinEnt) {
        ArrayList<CoiDisclosure> results = new ArrayList<CoiDisclosure>();
        for (CoiDisclosure discl : disclosures) {
            boolean disclHasFinEnt = this.hasFinEnt(discl);
            if (disclHasFinEnt != hasFinEnt) continue;
            results.add(discl);
        }
        return results;
    }

    public boolean hasFinEnt(CoiDisclosure coiDisclosure) {
        boolean disclHasFinEnt = false;
        for (CoiDisclProject disclProject : coiDisclosure.getCoiDisclProjects()) {
            if (disclProject.getCoiDiscDetails().isEmpty()) continue;
            disclHasFinEnt = true;
        }
        return disclHasFinEnt;
    }

    public List<CoiDisclosure> getAllOpenReviews() {
        return this.allOpenReviews;
    }

    public void setAllOpenReviews(List<CoiDisclosure> allOpenReviews) {
        this.allOpenReviews = allOpenReviews;
    }

    public List<CoiDisclosure> getAllOpenReviewsWithoutFinEnts() {
        return this.filterByFinEnt(this.getAllOpenReviews(), false);
    }

    public List<CoiDisclosure> getAllOpenReviewsWithFinEnts() {
        return this.filterByFinEnt(this.getAllOpenReviews(), true);
    }

    public List<CoiDisclosure> getPendingReviews() {
        return this.pendingReviews;
    }

    public void setPendingReviews(List<CoiDisclosure> pendingReviews) {
        this.pendingReviews = pendingReviews;
    }

    public List<CoiDisclosure> getPendingReviewsWithoutFinEnts() {
        return this.filterByFinEnt(this.getPendingReviews(), false);
    }

    public List<CoiDisclosure> getPendingReviewsWithFinEnts() {
        return this.filterByFinEnt(this.getPendingReviews(), true);
    }

    public List<CoiDisclosure> getInProgressReviews() {
        return this.inProgressReviews;
    }

    public void setInProgressReviews(List<CoiDisclosure> inProgressReviews) {
        this.inProgressReviews = inProgressReviews;
    }

    public List<CoiDisclosure> getInProgressReviewsWithoutFinEnts() {
        return this.filterByFinEnt(this.getInProgressReviews(), false);
    }

    public List<CoiDisclosure> getInProgressReviewsWithFinEnts() {
        return this.filterByFinEnt(this.getInProgressReviews(), true);
    }
}

