/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.lookup.dao.ojb;

import java.sql.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.coi.lookup.dao.CoiDisclosureUndisclosedEventsDao;
import org.kuali.kra.iacuc.personnel.IacucProtocolPerson;
import org.kuali.kra.iacuc.protocol.funding.IacucProtocolFundingSource;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.util.OjbCollectionAware;

public class CoiDisclosureUndisclosedEventsDaoOjb
extends PlatformAwareDaoBaseOjb
implements OjbCollectionAware,
CoiDisclosureUndisclosedEventsDao {
    private static final String PERSON_ID = "personId";
    private static final String DEV_PROPOSAL_SAVE_DATE = "developmentProposal.updateTimestamp";
    private static final String INST_PROPOSAL_SAVE_DATE = "institutionalProposal.updateTimestamp";
    private static final String AWARD_SAVE_DATE = "award.updateTimestamp";
    private static final String IRB_PROTOCOL_SAVE_DATE = "protocol.updateTimestamp";
    private static final String IACUC_PROTOCOL_SAVE_DATE = "protocol.updateTimestamp";
    private static final String DEV_PROPOSAL_SPONSOR_CODE = "developmentProposal.sponsorCode";
    private static final String INST_PROPOSAL_SPONSOR_CODE = "institutionalProposal.sponsorCode";
    private static final String AWARD_SPONSOR_CODE = "award.sponsorCode";
    private static final String FUNDING_SOURCE_TYPE_FIELD = "protocol.protocolFundingSources.fundingSourceTypeCode";
    private static final String FUNDING_SOURCE_NUMBER_FIELD = "protocol.protocolFundingSources.fundingSourceNumber";
    private static final String FUNDING_SOURCE_COLLECTION = "protocol.protocolFundingSources";

    public List<ProposalPerson> getDevelopmentProposalPersons(Map<String, String> fieldValues) {
        QueryByCriteria query = QueryFactory.newQuery(ProposalPerson.class, (Criteria)this.getSearchCriteria(fieldValues, DEV_PROPOSAL_SAVE_DATE, DEV_PROPOSAL_SPONSOR_CODE));
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    public List<InstitutionalProposalPerson> getInstituteProposalPersons(Map<String, String> fieldValues) {
        QueryByCriteria query = QueryFactory.newQuery(InstitutionalProposalPerson.class, (Criteria)this.getSearchCriteria(fieldValues, INST_PROPOSAL_SAVE_DATE, INST_PROPOSAL_SPONSOR_CODE));
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    public List<AwardPerson> getAwardPersons(Map<String, String> fieldValues) {
        QueryByCriteria query = QueryFactory.newQuery(AwardPerson.class, (Criteria)this.getSearchCriteria(fieldValues, AWARD_SAVE_DATE, AWARD_SPONSOR_CODE));
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    public List<IacucProtocolPerson> getIacucProtocolPersons(Map<String, String> fieldValues) {
        Criteria searchCriteria = this.getSearchCriteria(fieldValues, "protocol.updateTimestamp");
        String sponsorCode = this.getSponsorCriteria(fieldValues);
        if (StringUtils.isNotBlank((String)sponsorCode)) {
            Criteria sponsorCriteria = this.getIacucProtocolSponsorCriteria(sponsorCode);
            searchCriteria.addAndCriteria(sponsorCriteria);
        }
        QueryByCriteria query = QueryFactory.newQuery(IacucProtocolPerson.class, (Criteria)searchCriteria);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    public List<ProtocolPerson> getIrbProtocolPersons(Map<String, String> fieldValues) {
        Criteria searchCriteria = this.getSearchCriteria(fieldValues, "protocol.updateTimestamp");
        String sponsorCode = this.getSponsorCriteria(fieldValues);
        if (StringUtils.isNotBlank((String)sponsorCode)) {
            Criteria sponsorCriteria = this.getIrbProtocolSponsorCriteria(sponsorCode);
            searchCriteria.addAndCriteria(sponsorCriteria);
        }
        QueryByCriteria query = QueryFactory.newQuery(ProtocolPerson.class, (Criteria)searchCriteria);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    private Criteria getSearchCriteria(Map<String, String> fieldValues, String saveDateField, String sponsorField) {
        Criteria searchCriteria = this.getSearchCriteria(fieldValues, saveDateField);
        String sponsorCode = this.getSponsorCriteria(fieldValues);
        if (StringUtils.isNotBlank((String)sponsorCode)) {
            searchCriteria.addEqualTo(sponsorField, (Object)sponsorCode);
        }
        return searchCriteria;
    }

    private Criteria getSearchCriteria(Map<String, String> fieldValues, String saveDateField) {
        Criteria searchCriteria = new Criteria();
        String personId = fieldValues.get(PERSON_ID);
        String strDateFrom = fieldValues.get("createDateFrom");
        String strDateTo = fieldValues.get("createDateTo");
        Date createDateFrom = null;
        Date createDateTo = null;
        try {
            if (StringUtils.isNotBlank((String)strDateFrom)) {
                createDateFrom = CoreApiServiceLocator.getDateTimeService().convertToSqlDate(strDateFrom);
            }
            if (StringUtils.isNotBlank((String)strDateTo)) {
                createDateTo = CoreApiServiceLocator.getDateTimeService().convertToSqlDate(strDateTo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!StringUtils.isBlank((String)personId)) {
            searchCriteria.addEqualTo(PERSON_ID, (Object)personId);
        }
        if (ObjectUtils.isNotNull((Object)createDateFrom)) {
            searchCriteria.addGreaterThan((Object)saveDateField, (Object)createDateFrom);
        }
        if (ObjectUtils.isNotNull((Object)createDateTo)) {
            searchCriteria.addLessThan((Object)saveDateField, (Object)createDateTo);
        }
        return searchCriteria;
    }

    private Criteria getIacucProtocolSponsorCriteria(String sponsorCode) {
        return this.getProtocolSponsorCriteria(sponsorCode, IacucProtocolFundingSource.class);
    }

    private Criteria getIrbProtocolSponsorCriteria(String sponsorCode) {
        return this.getProtocolSponsorCriteria(sponsorCode, ProtocolFundingSource.class);
    }

    private Criteria getProtocolSponsorCriteria(String sponsorCode, Class<? extends ProtocolFundingSourceBase> fundingSourceBusinessObject) {
        Criteria sponsorCriteria = new Criteria();
        if (StringUtils.isNotBlank((String)sponsorCode)) {
            sponsorCriteria.addEqualTo(FUNDING_SOURCE_TYPE_FIELD, (Object)"1");
            sponsorCriteria.addEqualTo(FUNDING_SOURCE_NUMBER_FIELD, (Object)sponsorCode);
            sponsorCriteria.addPathClass(FUNDING_SOURCE_COLLECTION, fundingSourceBusinessObject);
        }
        return sponsorCriteria;
    }

    private String getSponsorCriteria(Map<String, String> fieldValues) {
        return fieldValues.get("sponsorCode");
    }
}

