/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.notification;

import java.util.List;
import java.util.Map;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.notification.CoiNotificationRoleQualifierService;
import org.kuali.kra.common.notification.NotificationContextBase;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.exception.UnknownRoleException;
import org.kuali.kra.common.notification.service.KcNotificationModuleRoleService;
import org.kuali.kra.common.notification.service.KcNotificationRoleQualifierService;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.util.EmailAttachment;
import org.springframework.util.CollectionUtils;

public class CoiNotificationContext
extends NotificationContextBase {
    private static final long serialVersionUID = 6642334312368480034L;
    private String coiDisclosureDocumentNumber;
    private String actionTypeCode;
    private String contextName;
    private String forwardName;
    private CoiNotificationRoleQualifierService coiNotificationRoleQualifierService;

    public CoiNotificationContext(CoiDisclosure coiDisclosure, String actionTypeCode, String contextName, NotificationRenderer renderer) {
        super(renderer);
        this.coiDisclosureDocumentNumber = coiDisclosure.getCoiDisclosureDocument().getDocumentNumber();
        this.actionTypeCode = actionTypeCode;
        this.contextName = contextName;
        this.setNotificationService((KcNotificationService)KraServiceLocator.getService(KcNotificationService.class));
        this.setNotificationModuleRoleService((KcNotificationModuleRoleService)KraServiceLocator.getService(KcNotificationModuleRoleService.class));
        this.setNotificationRoleQualifierService((KcNotificationRoleQualifierService)KraServiceLocator.getService(CoiNotificationRoleQualifierService.class));
        ((CoiNotificationRoleQualifierService)this.getNotificationRoleQualifierService()).setCoiDisclosure(coiDisclosure);
    }

    public String getModuleCode() {
        return "8";
    }

    public String getDocumentNumber() {
        return this.coiDisclosureDocumentNumber;
    }

    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void populateRoleQualifiers(NotificationTypeRecipient notificationRecipient) throws UnknownRoleException {
        if (CollectionUtils.isEmpty((Map)notificationRecipient.getRoleQualifiers())) {
            super.populateRoleQualifiers(notificationRecipient);
        }
    }

    public List<EmailAttachment> getEmailAttachments() {
        return null;
    }

    public CoiNotificationRoleQualifierService getCoiNotificationRoleQualifierService() {
        return this.coiNotificationRoleQualifierService;
    }

    public void setCoiNotificationRoleQualifierService(CoiNotificationRoleQualifierService coiNotificationRoleQualifierService) {
        this.coiNotificationRoleQualifierService = coiNotificationRoleQualifierService;
    }

    public String getForwardName() {
        return this.forwardName;
    }

    public void setForwardName(String forwardName) {
        this.forwardName = forwardName;
    }
}

