/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.notification;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.coi.notification.CoiReplacementParameters;
import org.kuali.kra.common.notification.NotificationRendererBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class CoiNotificationRenderer
extends NotificationRendererBase {
    private CoiDisclosure coiDisclosure;
    private transient BusinessObjectService businessObjectService;
    private transient KcPersonService kcPersonService;

    public CoiNotificationRenderer(CoiDisclosure coiDisclosure) {
        this.coiDisclosure = coiDisclosure;
    }

    public Map<String, String> getDefaultReplacementParameters() {
        String[] replacementParameters = CoiReplacementParameters.REPLACEMENT_PARAMETERS;
        Map params = super.getDefaultReplacementParameters();
        this.coiDisclosure.refreshReferenceObject("coiDisclosureEventType");
        String key = null;
        for (int i = 0; i < replacementParameters.length; ++i) {
            key = replacementParameters[i];
            if (StringUtils.equals((String)key, (String)"{SEQUENCE_NUMBER}")) {
                params.put(key, this.getCoiDisclosure().getSequenceNumber().toString());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{DISCLOSURE_TYPE}")) {
                params.put(key, this.coiDisclosure.getCoiDisclosureEventType().getDescription());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{DOCUMENT_NUMBER}")) {
                params.put(key, this.getCoiDisclosure().getCoiDisclosureDocument().getDocumentNumber());
                continue;
            }
            if (!StringUtils.equals((String)key, (String)"{DISCLOSURE_ID}")) continue;
            params.put(key, this.getCoiDisclosure().getCoiDisclosureId().toString());
        }
        return params;
    }

    public CoiDisclosure getCoiDisclosure() {
        return this.coiDisclosure;
    }

    public void setCoiDisclosure(CoiDisclosure coiDisclosure) {
        this.coiDisclosure = coiDisclosure;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

