/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataGroup;
import org.kuali.kra.coi.personfinancialentity.FinEntitiesDataMatrix;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;

public class FinEntitiesDataMatrixMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    private static final String COLUMN_SORT_ID_FIELD_NAME = "columnSortId";
    private static final String GROUP_ID_FIELD_NAME = "dataGroupId";
    private transient BusinessObjectService businessObjectService;

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    private boolean checkUniqueness(MaintenanceDocument document) {
        boolean isValid = true;
        FinEntitiesDataMatrix newFinEntitiesDataMatrix = (FinEntitiesDataMatrix)document.getNewMaintainableObject().getDataObject();
        isValid &= this.checkSortIdUniqueness(newFinEntitiesDataMatrix);
        return isValid &= this.checkGroupIdExist(newFinEntitiesDataMatrix);
    }

    private boolean checkSortIdUniqueness(FinEntitiesDataMatrix newFinEntitiesDataMatrix) {
        boolean isValid = true;
        Integer coloumnSortId = newFinEntitiesDataMatrix.getColumnSortId();
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put(COLUMN_SORT_ID_FIELD_NAME, coloumnSortId);
        Collection matchingDataMatrixs = this.getBusinessObjectService().findMatching(FinEntitiesDataMatrix.class, fieldValues);
        for (FinEntitiesDataMatrix dataMatrix : matchingDataMatrixs) {
            if (ObjectUtils.equals((Object)dataMatrix.getColumnName(), (Object)newFinEntitiesDataMatrix.getColumnName()) || !ObjectUtils.equals((Object)dataMatrix.getDataGroupId(), (Object)newFinEntitiesDataMatrix.getDataGroupId())) continue;
            isValid = false;
            this.putFieldError(COLUMN_SORT_ID_FIELD_NAME, "error.duplicate.property", new String[]{"Column Sort Id"});
            break;
        }
        return isValid;
    }

    private boolean checkGroupIdExist(FinEntitiesDataMatrix newFinEntitiesDataMatrix) {
        boolean isValid = true;
        Integer groupId = newFinEntitiesDataMatrix.getDataGroupId();
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put(GROUP_ID_FIELD_NAME, groupId);
        if (this.getBusinessObjectService().countMatching(FinEntitiesDataGroup.class, fieldValues) == 0) {
            isValid = false;
            this.putFieldError(GROUP_ID_FIELD_NAME, "error.datagroup.not.exist", new String[]{groupId.toString()});
        }
        return isValid;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

