/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.coi.notesandattachments.attachments.FinancialEntityAttachment;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityAction;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityForm;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityHelper;
import org.kuali.kra.coi.personfinancialentity.FinancialEntitySummaryHelper;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.service.VersionException;
import org.kuali.rice.krad.util.GlobalVariables;

public class FinancialEntityEditListAction
extends FinancialEntityAction {
    private static final String DEACTIVATE_ENTITY_QUESTION = "DeactivateEntity";
    private static final String DEACTIVATE_ENTITY_REASON_MAXLENGTH = "1000";
    private static final String PROCESS_STATUS_FINAL = "F";

    public ActionForward editActiveFinancialEntity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        financialEntityHelper.setEditType("active");
        this.editFinancialEntity(form, request);
        return mapping.findForward("basic");
    }

    public ActionForward editInactiveFinancialEntity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        financialEntityHelper.setEditType("inactive");
        this.editFinancialEntity(form, request);
        return mapping.findForward("basic");
    }

    private void editFinancialEntity(ActionForm form, HttpServletRequest request) throws Exception {
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        int entityIndex = -1;
        if (request.getParameter("coiDocId") != null) {
            financialEntityHelper.setActiveFinancialEntities(this.getFinancialEntities(true));
            entityIndex = this.findMatchedIndex(financialEntityHelper.getActiveFinancialEntities(), financialEntityHelper.getEditCoiEntityId());
        } else {
            entityIndex = this.getSelectedLine(request);
        }
        PersonFinIntDisclosure personFinIntDisclosure = (PersonFinIntDisclosure)this.getFinancialEntities(form).get(entityIndex);
        financialEntityHelper.setEditEntityIndex(entityIndex);
        financialEntityHelper.setEditRelationDetails(this.getFinancialEntityService().getFinancialEntityDataMatrixForEdit(personFinIntDisclosure.getPerFinIntDisclDetails()));
        financialEntityHelper.setFinEntityAttachmentList(FinancialEntityAttachment.copyAttachmentList((List)personFinIntDisclosure.getFinEntityAttachments()));
        financialEntityHelper.resetPrevSponsorCode();
    }

    private int findMatchedIndex(List<PersonFinIntDisclosure> financialEntities, String entityId) {
        int i = 0;
        for (PersonFinIntDisclosure financialEntity : financialEntities) {
            if (StringUtils.equals((String)financialEntity.getPersonFinIntDisclosureId().toString(), (String)entityId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ActionForward editFinancialEntityFromLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = request.getParameter("personFinIntDisclosureId");
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        List activePersonFinIntDisclosures = this.getActiveFinancialEntities();
        List inactivePersonFinIntDisclosures = this.getInactiveFinancialEntities();
        financialEntityHelper.setActiveFinancialEntities(activePersonFinIntDisclosures);
        financialEntityHelper.setInactiveFinancialEntities(inactivePersonFinIntDisclosures);
        PersonFinIntDisclosure currentEntity = this.getFinancialEntity(id);
        financialEntityHelper.setEditEntityIndex(this.getEntityIndex(currentEntity));
        financialEntityHelper.setEditRelationDetails(this.getFinancialEntityService().getFinancialEntityDataMatrixForEdit(currentEntity.getPerFinIntDisclDetails()));
        if (StringUtils.equals((String)(currentEntity.getStatusCode() + ""), (String)"2")) {
            financialEntityHelper.setEditType("inactive");
        } else {
            financialEntityHelper.setEditType("active");
        }
        return mapping.findForward("editList");
    }

    protected int getEntityIndex(PersonFinIntDisclosure currentEntity) {
        int entityIndex = 0;
        List financialEntities = this.getActiveFinancialEntities();
        if (StringUtils.equals((String)(currentEntity.getStatusCode() + ""), (String)"2")) {
            financialEntities = this.getInactiveFinancialEntities();
        }
        for (int i = 0; i < financialEntities.size(); ++i) {
            PersonFinIntDisclosure fe = (PersonFinIntDisclosure)financialEntities.get(i);
            if (!StringUtils.equals((String)(currentEntity.getPersonFinIntDisclosureId() + ""), (String)(fe.getPersonFinIntDisclosureId() + ""))) continue;
            entityIndex = i;
        }
        return entityIndex;
    }

    protected PersonFinIntDisclosure getFinancialEntity(String entityId) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("personFinIntDisclosureId", entityId);
        PersonFinIntDisclosure value = (PersonFinIntDisclosure)this.getBusinessObjectService().findByPrimaryKey(PersonFinIntDisclosure.class, criteria);
        return value;
    }

    protected List<PersonFinIntDisclosure> getActiveFinancialEntities() {
        return this.getFinancialEntityService().getFinancialEntities(GlobalVariables.getUserSession().getPrincipalId(), true);
    }

    protected List<PersonFinIntDisclosure> getInactiveFinancialEntities() {
        return this.getFinancialEntityService().getFinancialEntities(GlobalVariables.getUserSession().getPrincipalId(), false);
    }

    private List<PersonFinIntDisclosure> getFinancialEntities(ActionForm form) {
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        if (StringUtils.equals((String)"active", (String)financialEntityHelper.getEditType())) {
            return ((FinancialEntityForm)form).getFinancialEntityHelper().getActiveFinancialEntities();
        }
        return ((FinancialEntityForm)form).getFinancialEntityHelper().getInactiveFinancialEntities();
    }

    public ActionForward showFinancialEntityHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PersonFinIntDisclosure currentPersonFinIntDisclosure;
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        Integer entityIndex = Integer.parseInt(request.getParameter("index"));
        financialEntityHelper.setEditEntityIndex(entityIndex.intValue());
        String status = request.getParameter("status");
        if (StringUtils.equalsIgnoreCase((String)status, (String)"activecoi")) {
            currentPersonFinIntDisclosure = this.getFinancialEntity(entityIndex.toString());
            currentPersonFinIntDisclosure.setVersions(this.getFinancialEntityService().getFinDisclosureVersions(currentPersonFinIntDisclosure.getEntityNumber()));
        } else if (StringUtils.equalsIgnoreCase((String)status, (String)"inactive")) {
            currentPersonFinIntDisclosure = (PersonFinIntDisclosure)((FinancialEntityForm)form).getFinancialEntityHelper().getInactiveFinancialEntities().get(entityIndex);
        } else {
            currentPersonFinIntDisclosure = (PersonFinIntDisclosure)((FinancialEntityForm)form).getFinancialEntityHelper().getActiveFinancialEntities().get(entityIndex);
            List versionList = currentPersonFinIntDisclosure.getVersions();
            ArrayList<PersonFinIntDisclosure> activeFinancialIntDisclosure = new ArrayList<PersonFinIntDisclosure>();
            for (PersonFinIntDisclosure personFinIntDisclosure : versionList) {
                if (!personFinIntDisclosure.getProcessStatus().equals(PROCESS_STATUS_FINAL)) continue;
                activeFinancialIntDisclosure.add(personFinIntDisclosure);
            }
            currentPersonFinIntDisclosure.setVersions(activeFinancialIntDisclosure);
        }
        financialEntityHelper.setVersions(currentPersonFinIntDisclosure);
        return mapping.findForward("history");
    }

    public ActionForward viewFinancialEntity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        int currentVersionNumber;
        PersonFinIntDisclosure currentFinancialEntity;
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        FinancialEntitySummaryHelper summaryHelper = ((FinancialEntityForm)form).getFinancialEntitySummaryHelper();
        Integer entityIndex = Integer.parseInt(request.getParameter("index"));
        financialEntityHelper.setEditEntityIndex(entityIndex.intValue());
        String status = request.getParameter("status");
        if (StringUtils.equalsIgnoreCase((String)status, (String)"activecoi")) {
            currentFinancialEntity = this.getFinancialEntity(entityIndex.toString());
            currentFinancialEntity.setVersions(this.getFinancialEntityService().getFinDisclosureVersions(currentFinancialEntity.getEntityNumber()));
            currentVersionNumber = currentFinancialEntity.getVersions().size();
            status = "active";
            ((FinancialEntityForm)form).getFinancialEntityHelper().setActiveFinancialEntities(this.getFinancialEntities(currentFinancialEntity.getPersonId(), true));
            ((FinancialEntityForm)form).getFinancialEntityHelper().setInactiveFinancialEntities(this.getFinancialEntities(currentFinancialEntity.getPersonId(), false));
        } else if (StringUtils.equalsIgnoreCase((String)status, (String)"inactive")) {
            currentFinancialEntity = (PersonFinIntDisclosure)((FinancialEntityForm)form).getFinancialEntityHelper().getInactiveFinancialEntities().get(entityIndex);
            currentVersionNumber = currentFinancialEntity.getVersions().size();
        } else {
            currentFinancialEntity = (PersonFinIntDisclosure)((FinancialEntityForm)form).getFinancialEntityHelper().getActiveFinancialEntities().get(entityIndex);
            List versionList = currentFinancialEntity.getVersions();
            ArrayList<PersonFinIntDisclosure> activeFinancialIntDisclosure = new ArrayList<PersonFinIntDisclosure>();
            for (PersonFinIntDisclosure personFinIntDisclosure : versionList) {
                if (!personFinIntDisclosure.getProcessStatus().equals(PROCESS_STATUS_FINAL)) continue;
                activeFinancialIntDisclosure.add(personFinIntDisclosure);
            }
            currentFinancialEntity.setVersions(activeFinancialIntDisclosure);
            currentVersionNumber = currentFinancialEntity.getVersions().size();
        }
        summaryHelper.setEntityStatus(status);
        summaryHelper.setSummaryDetails(currentVersionNumber, currentFinancialEntity.getEntityNumber(), status);
        return mapping.findForward("viewEntity");
    }

    public ActionForward previousNextVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        int currentVersionNumber = Integer.parseInt(request.getParameter("versionNumber"));
        String entityNumber = request.getParameter("entityNumber");
        FinancialEntitySummaryHelper summaryHelper = ((FinancialEntityForm)form).getFinancialEntitySummaryHelper();
        String status = summaryHelper.getEntityStatus();
        summaryHelper.setSummaryDetails(currentVersionNumber, entityNumber, status);
        return mapping.findForward("viewEntity");
    }

    public ActionForward inactivateFinancialEntity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int entityIndex = this.getSelectedLine(request);
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String reason = request.getParameter("reason");
        String callerString = String.format("inactivateFinancialEntity.line%s.anchor%s", entityIndex, 0);
        if (question == null) {
            return this.performQuestionWithInput(mapping, form, request, response, DEACTIVATE_ENTITY_QUESTION, "Are you sure you want to deactivate this financial entity ?", "confirmationQuestion", callerString, "");
        }
        if (!DEACTIVATE_ENTITY_QUESTION.equals(question) || !"1".equals(buttonClicked)) {
            if (StringUtils.isBlank((String)reason) || reason.length() > 1000) {
                if (reason == null) {
                    reason = "";
                }
                return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, DEACTIVATE_ENTITY_QUESTION, "Are you sure you want to deactivate this financial entity ?", "confirmationQuestion", callerString, "", reason, "error.deactivate.financial.entity", "reason", DEACTIVATE_ENTITY_REASON_MAXLENGTH);
            }
            PersonFinIntDisclosure personFinIntDisclosure = (PersonFinIntDisclosure)((FinancialEntityForm)form).getFinancialEntityHelper().getActiveFinancialEntities().get(entityIndex);
            ((FinancialEntityForm)form).getFinancialEntityHelper().setEditRelationDetails(this.getFinancialEntityService().getFinancialEntityDataMatrixForEdit(personFinIntDisclosure.getPerFinIntDisclDetails()));
            ((FinancialEntityForm)form).getFinancialEntityHelper().setFinEntityAttachmentList(this.getFinancialEntityService().retrieveFinancialEntityAttachmentsFor(personFinIntDisclosure.getPersonFinIntDisclosureId()));
            this.versionFinancialEntity(form, personFinIntDisclosure, Integer.valueOf(2), reason);
        }
        ((FinancialEntityForm)form).getFinancialEntityHelper().setEditEntityIndex(-1);
        return mapping.findForward("basic");
    }

    public ActionForward activateFinancialEntity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int entityIndex = this.getSelectedLine(request);
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        PersonFinIntDisclosure personFinIntDisclosure = (PersonFinIntDisclosure)financialEntityHelper.getInactiveFinancialEntities().get(entityIndex);
        financialEntityHelper.setEditRelationDetails(this.getFinancialEntityService().getFinancialEntityDataMatrixForEdit(personFinIntDisclosure.getPerFinIntDisclDetails()));
        financialEntityHelper.setFinEntityAttachmentList(this.getFinancialEntityService().retrieveFinancialEntityAttachmentsFor(personFinIntDisclosure.getPersonFinIntDisclosureId()));
        this.versionFinancialEntity(form, personFinIntDisclosure, Integer.valueOf(1), "");
        financialEntityHelper.setEditEntityIndex(-1);
        return mapping.findForward("basic");
    }

    private PersonFinIntDisclosure versionFinancialEntity(ActionForm form, PersonFinIntDisclosure personFinIntDisclosure, Integer statusCode, String statusDesc) throws VersionException {
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        PersonFinIntDisclosure newVersionDisclosure = this.getFinancialEntityService().versionPersonFinintDisclosure(personFinIntDisclosure, financialEntityHelper.getEditRelationDetails(), financialEntityHelper.getFinEntityAttachmentList());
        newVersionDisclosure.setStatusCode(statusCode);
        newVersionDisclosure.setStatusDescription(statusDesc);
        newVersionDisclosure.refreshReferenceObject("finIntEntityStatus");
        this.saveFinancialEntity(form, newVersionDisclosure);
        return newVersionDisclosure;
    }

    public ActionForward submit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialEntityForm financialEntityForm = (FinancialEntityForm)form;
        FinancialEntityHelper financialEntityHelper = financialEntityForm.getFinancialEntityHelper();
        int entityIndex = this.getSelectedLine(request);
        PersonFinIntDisclosure personFinIntDisclosure = (PersonFinIntDisclosure)this.getFinancialEntities(form).get(entityIndex);
        if (this.isValidToSave(personFinIntDisclosure, this.getErrorPropertyPrefix(form, entityIndex))) {
            if (StringUtils.equals((String)PROCESS_STATUS_FINAL, (String)personFinIntDisclosure.getProcessStatus())) {
                PersonFinIntDisclosure newFinIntDisclosure = this.versionFinancialEntity(form, personFinIntDisclosure, Integer.valueOf(StringUtils.equals((String)"active", (String)financialEntityHelper.getEditType()) ? 1 : 2), "");
                this.resetEditEntityIndex(form, newFinIntDisclosure.getPersonFinIntDisclosureId());
            } else {
                personFinIntDisclosure.setProcessStatus(PROCESS_STATUS_FINAL);
                this.resetFinEntityDet(financialEntityHelper, personFinIntDisclosure);
                personFinIntDisclosure.setFinEntityAttachments(financialEntityHelper.getFinEntityAttachmentList());
                this.saveFinancialEntity(form, personFinIntDisclosure);
            }
            if (StringUtils.isNotBlank((String)financialEntityForm.getCoiDocId())) {
                String forward = this.buildForwardUrl(financialEntityForm.getCoiDocId());
                financialEntityForm.setCoiDocId(null);
                financialEntityForm.getFinancialEntityHelper().setReporterId(null);
                return new ActionForward(forward, true);
            }
            financialEntityHelper.initiate();
        }
        return mapping.findForward("basic");
    }

    private String getErrorPropertyPrefix(ActionForm form, int entityIndex) {
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        if (StringUtils.equals((String)"active", (String)financialEntityHelper.getEditType())) {
            return "financialEntityHelper.activeFinancialEntities[" + entityIndex + "]";
        }
        return "financialEntityHelper.inactiveFinancialEntities[" + entityIndex + "]";
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        int entityIndex = this.getSelectedLine(request);
        PersonFinIntDisclosure personFinIntDisclosure = (PersonFinIntDisclosure)this.getFinancialEntities(form).get(entityIndex);
        if (this.isValidToSave(personFinIntDisclosure, this.getErrorPropertyPrefix(form, entityIndex))) {
            if (StringUtils.equals((String)PROCESS_STATUS_FINAL, (String)personFinIntDisclosure.getProcessStatus())) {
                PersonFinIntDisclosure newVersionDisclosure = this.getFinancialEntityService().versionPersonFinintDisclosure(personFinIntDisclosure, financialEntityHelper.getEditRelationDetails(), financialEntityHelper.getFinEntityAttachmentList());
                newVersionDisclosure.setProcessStatus("S");
                newVersionDisclosure.setStatusDescription("");
                this.saveFinancialEntity(form, newVersionDisclosure);
                this.resetEditEntityIndex(form, newVersionDisclosure.getPersonFinIntDisclosureId());
            } else {
                personFinIntDisclosure.setFinEntityAttachments(financialEntityHelper.getFinEntityAttachmentList());
                this.resetFinEntityDet(financialEntityHelper, personFinIntDisclosure);
                this.saveFinancialEntity(form, personFinIntDisclosure);
            }
        }
        return mapping.findForward("basic");
    }

    private void resetFinEntityDet(FinancialEntityHelper financialEntityHelper, PersonFinIntDisclosure personFinIntDisclosure) {
        if (CollectionUtils.isNotEmpty((Collection)personFinIntDisclosure.getPerFinIntDisclDetails())) {
            this.getBusinessObjectService().delete(personFinIntDisclosure.getPerFinIntDisclDetails());
        }
        personFinIntDisclosure.setPerFinIntDisclDetails(this.getFinancialEntityService().getFinDisclosureDetails(financialEntityHelper.getEditRelationDetails(), personFinIntDisclosure.getEntityNumber(), personFinIntDisclosure.getSequenceNumber()));
    }

    private void resetEditEntityIndex(ActionForm form, Long personFinIntDisclosureId) {
        FinancialEntityHelper financialEntityHelper = ((FinancialEntityForm)form).getFinancialEntityHelper();
        int i = 0;
        for (PersonFinIntDisclosure personFinIntDisclosure : this.getFinancialEntities(form)) {
            if (personFinIntDisclosure.getPersonFinIntDisclosureId().equals(personFinIntDisclosureId)) {
                financialEntityHelper.setEditEntityIndex(i);
                break;
            }
            ++i;
        }
    }

    public ActionForward addNewFinancialEntityAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((FinancialEntityForm)form).getFinancialEntityHelper().addNewFinancialEntityAttachment();
        return mapping.findForward("basic");
    }

    public ActionForward deleteFinancialEntityAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialEntityForm financialEntityForm = (FinancialEntityForm)form;
        int selectedLine = this.getSelectedLine(request);
        financialEntityForm.getFinancialEntityHelper().removeNewFinancialEntityAttachment(selectedLine);
        return mapping.findForward("basic");
    }

    public ActionForward whereToGoAfterCancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("portal");
    }
}

