/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.coi.personfinancialentity;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.coi.personfinancialentity.FinancialEntityContactInfo;
import org.kuali.kra.coi.personfinancialentity.PersonFinIntDisclosure;
import org.kuali.kra.coi.personfinancialentity.SaveFinancialEntityEvent;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.SponsorService;
import org.kuali.rice.krad.util.GlobalVariables;

public class SaveFinancialEntityRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<SaveFinancialEntityEvent> {
    private static final String SPONSOR_CODE = "sponsorCode";
    private SponsorService sponsorService;

    public boolean processRules(SaveFinancialEntityEvent event) {
        boolean isValid = this.checkValidSponsor(event);
        return isValid &= this.checkUniqueEntityName(event);
    }

    private boolean checkValidSponsor(SaveFinancialEntityEvent event) {
        boolean isValid = true;
        if (StringUtils.isNotBlank((String)event.getPersonFinIntDisclosure().getSponsorCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(SPONSOR_CODE, event.getPersonFinIntDisclosure().getSponsorCode());
            Sponsor sp = (Sponsor)this.getBusinessObjectService().findByPrimaryKey(Sponsor.class, fieldValues);
            if (!this.getSponsorService().validateSponsor(sp)) {
                GlobalVariables.getMessageMap().addToErrorPath(event.getPropertyName());
                GlobalVariables.getMessageMap().putError(SPONSOR_CODE, "error.invalid.sponsorCode", new String[0]);
                isValid = false;
                GlobalVariables.getMessageMap().removeFromErrorPath(event.getPropertyName());
            }
        }
        return isValid;
    }

    private boolean checkUniqueEntityName(SaveFinancialEntityEvent event) {
        if (StringUtils.isNotBlank((String)event.getPersonFinIntDisclosure().getEntityName())) {
            String entityNumber = event.getPersonFinIntDisclosure().getEntityNumber();
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("entityName", event.getPersonFinIntDisclosure().getEntityName());
            fieldValues.put("financialEntityReporterId", event.getPersonFinIntDisclosure().getFinancialEntityReporterId());
            List personFinIntDisclosures = (List)this.getBusinessObjectService().findMatching(PersonFinIntDisclosure.class, fieldValues);
            for (PersonFinIntDisclosure personFinIntDisclosure : personFinIntDisclosures) {
                if (StringUtils.equalsIgnoreCase((String)entityNumber, (String)personFinIntDisclosure.getEntityNumber())) continue;
                boolean result = false;
                for (FinancialEntityContactInfo oldFeci : personFinIntDisclosure.getFinEntityContactInfos()) {
                    for (FinancialEntityContactInfo newFeci : event.getPersonFinIntDisclosure().getFinEntityContactInfos()) {
                        if (!newFeci.infoMatches(oldFeci)) continue;
                        GlobalVariables.getMessageMap().addToErrorPath(event.getPropertyName());
                        GlobalVariables.getMessageMap().putError("entityName", "error.duplicate.property", new String[]{"Entity Name and Contact Info"});
                        GlobalVariables.getMessageMap().removeFromErrorPath(event.getPropertyName());
                        return false;
                    }
                }
                if (!result) continue;
            }
        }
        return true;
    }

    public SponsorService getSponsorService() {
        if (this.sponsorService == null) {
            this.sponsorService = (SponsorService)KraServiceLocator.getService(SponsorService.class);
        }
        return this.sponsorService;
    }

    public void setSponsorService(SponsorService sponsorService) {
        this.sponsorService = sponsorService;
    }
}

