/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.notification;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.notification.CommitteeReplacementParameters;
import org.kuali.kra.common.notification.NotificationRendererBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class CommitteeNotificationRenderer
extends NotificationRendererBase {
    private Committee committee;
    private transient BusinessObjectService businessObjectService;
    private transient KcPersonService kcPersonService;

    public CommitteeNotificationRenderer(Committee committee) {
        this.committee = committee;
    }

    public Map<String, String> getDefaultReplacementParameters() {
        String[] replacementParameters = CommitteeReplacementParameters.REPLACEMENT_PARAMETERS;
        Map params = super.getDefaultReplacementParameters();
        String key = null;
        for (int i = 0; i < replacementParameters.length; ++i) {
            key = replacementParameters[i];
            if (StringUtils.equals((String)key, (String)"{DOCUMENT_NUMBER}")) {
                params.put(key, ((CommitteeDocument)this.committee.getCommitteeDocument()).getDocumentNumber());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{SEQUENCE_NUMBER}")) {
                params.put(key, this.committee.getSequenceNumber().toString());
                continue;
            }
            if (!StringUtils.equals((String)key, (String)"{COMMITTEE_NAME}")) continue;
            params.put(key, this.committee.getCommitteeName().toString());
        }
        return params;
    }

    public Committee getCommittee() {
        return this.committee;
    }

    public void setCommittee(Committee committee) {
        this.committee = committee;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    private ConfigurationService getKualiConfigurationService() {
        return KRADServiceLocator.getKualiConfigurationService();
    }
}

