/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.print;

import edu.mit.irb.irbnamespace.CommitteeDocument;
import edu.mit.irb.irbnamespace.CommitteeMasterDataDocument;
import edu.mit.irb.irbnamespace.CommitteeMemberDocument;
import edu.mit.irb.irbnamespace.CommitteeMemberRoleDocument;
import edu.mit.irb.irbnamespace.PersonDocument;
import edu.mit.irb.irbnamespace.ProtocolDocument;
import edu.mit.irb.irbnamespace.ResearchAreaDocument;
import edu.mit.irb.irbnamespace.ScheduleDocument;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.print.IrbPrintXmlUtilService;
import org.kuali.kra.committee.print.ScheduleXmlStream;
import org.kuali.kra.common.committee.bo.CommitteeMembershipExpertiseBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.bo.CommitteeResearchAreaBase;
import org.kuali.kra.irb.personnel.ProtocolPersonRolodex;
import org.kuali.kra.printing.xmlstream.PrintBaseXmlStream;

public class CommitteeXmlStream
extends PrintBaseXmlStream {
    private ScheduleXmlStream scheduleXmlStream;
    private IrbPrintXmlUtilService irbPrintXmlUtilService;

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        Committee committee = (Committee)printableBusinessObject;
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        CommitteeDocument committeeDocumentType = CommitteeDocument.Factory.newInstance();
        committeeDocumentType.setCommittee(this.getCommitteeCompleteDetails(committee));
        xmlObjectList.put("Committee", (XmlObject)committeeDocumentType);
        return xmlObjectList;
    }

    public CommitteeDocument.Committee getCommitteeCompleteDetails(Committee committee) {
        CommitteeDocument.Committee committeeType = CommitteeDocument.Committee.Factory.newInstance();
        this.setCommitteeMasterData(committee, committeeType.addNewCommitteeMasterData());
        this.setCommitteeMembers(committee, committeeType);
        this.setScheduleForcommittee(committee, committeeType);
        this.setCommitteeResearchArea(committee, committeeType);
        return committeeType;
    }

    private void setCommitteeResearchArea(Committee committee, CommitteeDocument.Committee committeeType) {
        List committeeResearchAreas = committee.getCommitteeResearchAreas();
        if (committeeResearchAreas.isEmpty()) {
            return;
        }
        for (CommitteeResearchAreaBase committeeResearchArea : committeeResearchAreas) {
            ResearchAreaDocument.ResearchArea researchArea = committeeType.addNewResearchArea();
            researchArea.setResearchAreaCode(committeeResearchArea.getResearchAreaCode());
            researchArea.setResearchAreaDescription(committeeResearchArea.getResearchArea().getDescription());
        }
    }

    private void setScheduleForcommittee(Committee committee, CommitteeDocument.Committee committeeType) {
        java.util.Date currentDate = new java.util.Date();
        Boolean isRooster = committee.getPrintRooster();
        List vecSchedule = committee.getCommitteeSchedules();
        if (vecSchedule.isEmpty()) {
            return;
        }
        for (CommitteeSchedule scheduleDetailsBean : vecSchedule) {
            ScheduleDocument.Schedule.NextSchedule nextSchedule;
            ScheduleDocument.Schedule scheduleType;
            Date scheduleDate = scheduleDetailsBean.getScheduledDate();
            int dateCount = scheduleDate.compareTo(currentDate);
            if (isRooster.booleanValue()) {
                scheduleType = committeeType.addNewSchedule();
                this.getScheduleXmlStream().setScheduleMasterData(scheduleDetailsBean, scheduleType.addNewScheduleMasterData());
                nextSchedule = scheduleType.addNewNextSchedule();
                this.getScheduleXmlStream().setNextSchedule(scheduleDetailsBean, nextSchedule.addNewScheduleMasterData());
            }
            if (isRooster.booleanValue() || dateCount <= 0) continue;
            scheduleType = committeeType.addNewSchedule();
            this.getScheduleXmlStream().setScheduleMasterData(scheduleDetailsBean, scheduleType.addNewScheduleMasterData());
            nextSchedule = scheduleType.addNewNextSchedule();
            this.getScheduleXmlStream().setNextSchedule(scheduleDetailsBean, nextSchedule.addNewScheduleMasterData());
        }
    }

    public void setCommitteeMembers(Committee committee, CommitteeDocument.Committee committeeType) {
        List committeeMemberships = committee.getCommitteeMemberships();
        if (committeeMemberships.isEmpty()) {
            return;
        }
        for (CommitteeMembership membershipBean : committeeMemberships) {
            CommitteeMemberDocument.CommitteeMember committeeMember = committeeType.addNewCommitteeMember();
            this.setCommitteeMembershipType(membershipBean, committeeMember);
        }
    }

    public void setCommitteeMembers(Committee committee, ProtocolDocument.Protocol.Submissions committeeType) {
        List committeeMemberships = committee.getCommitteeMemberships();
        if (committeeMemberships.isEmpty()) {
            return;
        }
        for (CommitteeMembership membershipBean : committeeMemberships) {
            CommitteeMemberDocument.CommitteeMember committeeMember = committeeType.addNewCommitteeMember();
            this.setCommitteeMembershipType(membershipBean, committeeMember);
        }
    }

    private void setCommitteeMembershipType(CommitteeMembership membershipBean, CommitteeMemberDocument.CommitteeMember committeeMember) {
        List vecMemRoles;
        membershipBean.refreshNonUpdateableReferences();
        this.setPersonType(membershipBean, committeeMember);
        committeeMember.setMemberStatus(membershipBean.isActive() ? "active" : "inactive");
        committeeMember.setMemberStatusStartDt(Calendar.getInstance());
        committeeMember.setMemberStatusEndDt(Calendar.getInstance());
        if (membershipBean.getTermEndDate() != null) {
            committeeMember.setTermEnd(this.getDateTimeService().getCalendar((java.util.Date)membershipBean.getTermEndDate()));
        }
        if (membershipBean.getTermStartDate() != null) {
            committeeMember.setTermStart(this.getDateTimeService().getCalendar((java.util.Date)membershipBean.getTermStartDate()));
        }
        if (membershipBean.getMembershipType() != null) {
            committeeMember.setMemberType(membershipBean.getMembershipType().getDescription());
        }
        committeeMember.setPaidMemberFlag(membershipBean.getPaidMember());
        List committeeMemResearchArea = membershipBean.getMembershipExpertise();
        if (committeeMemResearchArea != null) {
            for (CommitteeMembershipExpertiseBase committeeMemberExpertise : committeeMemResearchArea) {
                ResearchAreaDocument.ResearchArea researchArea = committeeMember.addNewResearchArea();
                researchArea.setResearchAreaCode(committeeMemberExpertise.getResearchAreaCode());
                if (committeeMemberExpertise.getResearchArea() == null) continue;
                researchArea.setResearchAreaDescription(committeeMemberExpertise.getResearchArea().getDescription());
            }
        }
        if ((vecMemRoles = membershipBean.getMembershipRoles()) != null) {
            for (CommitteeMembershipRole committeeMembershipRole : vecMemRoles) {
                CommitteeMemberRoleDocument.CommitteeMemberRole committeeMemRole = committeeMember.addNewCommitteeMemberRole();
                committeeMemRole.setMemberRoleCode(new BigInteger(String.valueOf(committeeMembershipRole.getMembershipRoleCode())));
                if (committeeMembershipRole.getMembershipRole() != null) {
                    committeeMemRole.setMemberRoleDesc(committeeMembershipRole.getMembershipRole().getDescription());
                }
                if (committeeMembershipRole.getStartDate() != null) {
                    committeeMemRole.setMemberRoleStartDt(this.getDateTimeService().getCalendar((java.util.Date)committeeMembershipRole.getStartDate()));
                }
                if (committeeMembershipRole.getEndDate() == null) continue;
                committeeMemRole.setMemberRoleEndDt(this.getDateTimeService().getCalendar((java.util.Date)committeeMembershipRole.getEndDate()));
            }
        }
    }

    private void setPersonType(CommitteeMembership membershipBean, CommitteeMemberDocument.CommitteeMember committeeMember) {
        PersonDocument.Person person = committeeMember.addNewPerson();
        boolean employeeFlag = membershipBean.getPerson() != null;
        person.setFacultyFlag(false);
        person.setEmployeeFlag(!employeeFlag);
        if (employeeFlag) {
            KcPerson personBean = membershipBean.getPerson();
            this.getIrbPrintXmlUtilService().setPersonXml(personBean, person);
        } else {
            ProtocolPersonRolodex rolodexBean = (ProtocolPersonRolodex)membershipBean.getRolodex();
            this.getIrbPrintXmlUtilService().setPersonXml(rolodexBean, person);
        }
    }

    public void setCommitteeMasterData(Committee committee, CommitteeMasterDataDocument.CommitteeMasterData committeeMasterData) {
        committeeMasterData.setCommitteeId(committee.getCommitteeId());
        committeeMasterData.setCommitteeName(committee.getCommitteeName());
        committeeMasterData.setHomeUnitNumber(committee.getHomeUnitNumber());
        committeeMasterData.setHomeUnitName(committee.getUnitName());
        committeeMasterData.setCommitteeTypeCode(new BigInteger(String.valueOf(committee.getCommitteeTypeCode())));
        committeeMasterData.setCommitteeTypeDesc(committee.getCommitteeType().getDescription());
        committeeMasterData.setScheduleDescription(committee.getScheduleDescription());
        committeeMasterData.setMinimumMembersRequired(new BigInteger(String.valueOf(committee.getMinimumMembersRequired())));
        committeeMasterData.setMaxProtocols(new BigInteger(String.valueOf(committee.getMaxProtocols())));
        committeeMasterData.setAdvSubmissionDays(new BigInteger(String.valueOf(committee.getAdvancedSubmissionDaysRequired())));
        if (committee.getReviewType() != null) {
            committeeMasterData.setDefaultReviewTypeCode(new BigInteger(String.valueOf(committee.getReviewTypeCode())));
            committeeMasterData.setDefaultReviewTypeDesc(committee.getReviewType().getDescription());
        }
    }

    public void setScheduleXmlStream(ScheduleXmlStream scheduleXmlStream) {
        this.scheduleXmlStream = scheduleXmlStream;
    }

    public ScheduleXmlStream getScheduleXmlStream() {
        return this.scheduleXmlStream;
    }

    public void setIrbPrintXmlUtilService(IrbPrintXmlUtilService irbPrintXmlUtilService) {
        this.irbPrintXmlUtilService = irbPrintXmlUtilService;
    }

    public IrbPrintXmlUtilService getIrbPrintXmlUtilService() {
        return this.irbPrintXmlUtilService;
    }
}

