/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.rule.event.CommitteeScheduleDateConflictEvent;
import org.kuali.kra.committee.rule.event.CommitteeScheduleEventBase;
import org.kuali.kra.committee.rules.CommitteeScheduleDateConflictRule;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.util.DateUtils;

public class CommitteeScheduleDateConflictRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<CommitteeScheduleDateConflictEvent> {
    private static final Log LOG = LogFactory.getLog(CommitteeScheduleDateConflictRule.class);
    public static final String ID = "document.committeeList[0].committeeSchedules[%1$s].scheduledDate";
    public static final String DATES_IN_CONFLICT_ERROR_KEY = "datesInConflict";

    public boolean processRules(CommitteeScheduleDateConflictEvent addCommitteeScheduleEvent) {
        boolean rulePassed = true;
        CommitteeScheduleEventBase.ErrorType type = addCommitteeScheduleEvent.getType();
        switch (1.$SwitchMap$org$kuali$kra$committee$rule$event$CommitteeScheduleEventBase$ErrorType[type.ordinal()]) {
            case 1: {
                rulePassed = this.processHardErrors(addCommitteeScheduleEvent);
                break;
            }
            case 2: {
                rulePassed = this.processSoftErrors(addCommitteeScheduleEvent);
            }
        }
        return rulePassed;
    }

    private boolean processHardErrors(CommitteeScheduleDateConflictEvent addCommitteeScheduleEvent) {
        LinkedList conflictDates;
        boolean rulePassed = true;
        List committeeSchedules = addCommitteeScheduleEvent.getCommitteeSchedules();
        rulePassed = this.parseUniqueDateSet(committeeSchedules, conflictDates = new LinkedList());
        if (!rulePassed) {
            this.identifyPotentialConflicts(committeeSchedules, conflictDates);
        }
        return rulePassed;
    }

    private boolean parseUniqueDateSet(List<CommitteeSchedule> committeeSchedules, List<java.sql.Date> conflictDates) {
        boolean retVal = true;
        boolean flag = true;
        LinkedHashSet<java.sql.Date> set = new LinkedHashSet<java.sql.Date>();
        for (CommitteeSchedule committeeSchedule : committeeSchedules) {
            flag = true;
            flag = set.add(committeeSchedule.getScheduledDate());
            if (flag) continue;
            conflictDates.add(committeeSchedule.getScheduledDate());
        }
        if (conflictDates.size() > 0) {
            retVal = false;
        }
        return retVal;
    }

    private void identifyPotentialConflicts(List<CommitteeSchedule> committeeSchedules, List<java.sql.Date> conflictDates) {
        java.sql.Date scheduleDate = null;
        int count = 0;
        for (java.sql.Date date : conflictDates) {
            count = 0;
            for (CommitteeSchedule committeeSchedule : committeeSchedules) {
                scheduleDate = committeeSchedule.getScheduledDate();
                if (DateUtils.isSameDay((Date)date, (Date)scheduleDate)) {
                    this.reportError(String.format(ID, count), "error.committeeSchedule.date.conflict", new String[]{scheduleDate.toString()});
                }
                ++count;
            }
        }
    }

    private boolean processSoftErrors(CommitteeScheduleDateConflictEvent addCommitteeScheduleEvent) {
        boolean rulePassed = true;
        List datesInConflict = addCommitteeScheduleEvent.getScheduleData().getDatesInConflict();
        for (java.sql.Date date : datesInConflict) {
            this.reportSoftError(DATES_IN_CONFLICT_ERROR_KEY, "error.committeeSchedule.dates.skipped", new String[]{date.toString()});
        }
        return rulePassed;
    }
}

