/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.sql.Date;
import org.kuali.kra.committee.rule.event.CommitteeScheduleStartAndEndDateEvent;
import org.kuali.kra.committee.rules.CommitteeScheduleStartAndEndDateRule;
import org.kuali.kra.common.committee.web.struts.form.schedule.ScheduleData;
import org.kuali.kra.common.committee.web.struts.form.schedule.StyleKey;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class CommitteeScheduleStartAndEndDateRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<CommitteeScheduleStartAndEndDateEvent> {
    public static final String DOT = ".";
    public static final String BLANK = "";

    public boolean processRules(CommitteeScheduleStartAndEndDateEvent addCommitteeScheduleEvent) {
        boolean valid = true;
        StringBuilder errorPathBuilder = new StringBuilder();
        errorPathBuilder.append(Constants.committeeHelper).append(DOT);
        errorPathBuilder.append(Constants.scheduleData).append(DOT);
        ScheduleData scheduleData = addCommitteeScheduleEvent.getScheduleData();
        Date startDate = scheduleData.getScheduleStartDate();
        if (startDate == null) {
            errorPathBuilder.append(Constants.scheduleStartDate);
            this.reportError(errorPathBuilder.toString(), "error.committeeSchedule.start.date.blank", new String[0]);
            valid = false;
        } else {
            valid &= this.validateStartDateEndDateAfterOrEquals(scheduleData, errorPathBuilder);
        }
        return valid;
    }

    private boolean validateStartDateEndDateAfterOrEquals(ScheduleData scheduleData, StringBuilder errorPathBuilder) {
        boolean rulePassed = true;
        Date startDate = scheduleData.getScheduleStartDate();
        Date endDate = null;
        String[] msg = new String[1];
        StyleKey key = StyleKey.valueOf((String)scheduleData.getRecurrenceType());
        switch (1.$SwitchMap$org$kuali$kra$common$committee$web$struts$form$schedule$StyleKey[key.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                endDate = scheduleData.getDailySchedule().getScheduleEndDate();
                rulePassed = !this.isStartDateEndDateAfterOrEquals(startDate, endDate, msg);
                errorPathBuilder.append(Constants.dailySchedule);
                break;
            }
            case 3: {
                endDate = scheduleData.getWeeklySchedule().getScheduleEndDate();
                rulePassed = !this.isStartDateEndDateAfterOrEquals(startDate, endDate, msg);
                errorPathBuilder.append(Constants.weeklySchedule);
                break;
            }
            case 4: {
                endDate = scheduleData.getMonthlySchedule().getScheduleEndDate();
                rulePassed = !this.isStartDateEndDateAfterOrEquals(startDate, endDate, msg);
                errorPathBuilder.append(Constants.monthlySchedule);
                break;
            }
            case 5: {
                endDate = scheduleData.getYearlySchedule().getScheduleEndDate();
                rulePassed = !this.isStartDateEndDateAfterOrEquals(startDate, endDate, msg);
                errorPathBuilder.append(Constants.yearlySchedule);
            }
        }
        if (!rulePassed) {
            errorPathBuilder.append(DOT).append(Constants.scheduleEndDate);
            this.reportError(errorPathBuilder.toString(), msg[0], new String[0]);
        }
        return rulePassed;
    }

    private boolean isStartDateEndDateAfterOrEquals(Date startDate, Date endDate, String ... msg) {
        boolean retVal = false;
        if (startDate.toString().equals(endDate.toString())) {
            msg[0] = "error.committeeSchedule.start.and.endDate.equal";
            retVal = true;
        }
        if (!retVal && startDate.after(endDate)) {
            msg[0] = "error.committeeSchedule.start.and.endDate";
            retVal = true;
        }
        return retVal;
    }
}

