/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.rule.event.CommitteeScheduleTimeEvent;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class CommitteeScheduleTimeRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<CommitteeScheduleTimeEvent> {
    public static final String MSG1 = "hh:mm";
    public static final String MSG2 = "hh as 1-12 & mm as 0-59";
    public static final String MSG3 = "hh as 1-12";
    public static final String MSG4 = "mm as 0-59";
    public static final String COLON = ":";
    public static final String ID1 = "document.committeeList[0].committeeSchedules[%1$s].viewTime.time";
    public static final String ID2 = "committeeHelper.scheduleData.time.time";

    public boolean processRules(CommitteeScheduleTimeEvent event) {
        boolean rulePassed = true;
        if (null != event.getScheduleData()) {
            rulePassed = this.processTime(event.getScheduleData().getTime().getTime(), ID2);
        }
        if (null != event.getCommitteeSchedules()) {
            rulePassed = this.processCommitteeSchedules(event.getCommitteeSchedules());
        }
        return rulePassed;
    }

    private boolean processCommitteeSchedules(List<CommitteeSchedule> committeeSchedules) {
        boolean rulePassed = true;
        int count = 0;
        for (CommitteeSchedule cs : committeeSchedules) {
            String time = cs.getViewTime().getTime();
            rulePassed &= this.processTime(time, String.format(ID1, count++));
        }
        return rulePassed;
    }

    public boolean processTime(String time, String id) {
        if (StringUtils.isBlank((String)time)) {
            this.createRequiredFieldErrorReport(id);
            return false;
        }
        String[] result = time.split(COLON);
        if (result.length != 2) {
            this.createFormattingErrorReport(id, time, MSG1);
            return false;
        }
        try {
            Integer hrs = new Integer(result[0]);
            Integer mins = new Integer(result[1]);
            if (hrs < 1 || hrs > 12) {
                this.createFormattingErrorReport(id, time, MSG3);
                return false;
            }
            if (mins < 0 || mins > 59) {
                this.createFormattingErrorReport(id, time, MSG4);
                return false;
            }
        }
        catch (NumberFormatException e) {
            this.createFormattingErrorReport(id, time, MSG2);
            return false;
        }
        return true;
    }

    private void createFormattingErrorReport(String id, String data, String msg) {
        this.reportError(id, "error.committeeSchedule.viewTime.formatting", new String[]{data, msg});
    }

    private void createRequiredFieldErrorReport(String id) {
        this.reportError(id, "error.committeeSchedule.viewTime.blank", new String[0]);
    }
}

