/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.service.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.notification.AgendaCreatedNotificationRenderer;
import org.kuali.kra.committee.notification.CommitteeNotificationContext;
import org.kuali.kra.committee.notification.MinutesCreatedNotificationRenderer;
import org.kuali.kra.committee.service.CommitteeNotificationService;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.meeting.CommScheduleMinuteDoc;
import org.kuali.kra.meeting.ScheduleAgenda;

public class CommitteeNotificationServiceImpl
implements CommitteeNotificationService {
    private String committeeNotificationType;
    private KcNotificationService kcNotificationService;

    public String getCommitteeNotificationType() {
        return this.committeeNotificationType;
    }

    public void setCommitteeNotificationType(String committeeNotificationType) {
        this.committeeNotificationType = committeeNotificationType;
    }

    public void generateNotification(String notificationType, ScheduleAgenda agenda) {
        if (!StringUtils.equals((String)notificationType, (String)"213")) {
            throw new IllegalArgumentException(this.committeeNotificationType);
        }
        CommitteeSchedule committeeSchedule = (CommitteeSchedule)agenda.getCommitteeSchedule();
        AgendaCreatedNotificationRenderer renderer = new AgendaCreatedNotificationRenderer(agenda, "action taken");
        CommitteeNotificationContext context = new CommitteeNotificationContext(committeeSchedule, notificationType, "Agenda Generated Notification", (NotificationRenderer)renderer);
        this.kcNotificationService.sendNotification((NotificationContext)context);
    }

    public void generateNotification(String notificationType, CommScheduleMinuteDoc minuteDoc) {
        if (!StringUtils.equals((String)notificationType, (String)"215")) {
            throw new IllegalArgumentException(this.committeeNotificationType);
        }
        CommitteeSchedule committeeSchedule = (CommitteeSchedule)minuteDoc.getCommitteeSchedule();
        MinutesCreatedNotificationRenderer renderer = new MinutesCreatedNotificationRenderer(minuteDoc, "action taken");
        CommitteeNotificationContext context = new CommitteeNotificationContext(committeeSchedule, notificationType, "Agenda Generated Notification", (NotificationRenderer)renderer);
        this.kcNotificationService.sendNotification((NotificationContext)context);
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }
}

