/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.bo;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeBatchCorrespondenceDetailBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.correspondence.BatchCorrespondenceBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.SequenceAccessorService;

public abstract class CommitteeBatchCorrespondenceBase
extends KraPersistableBusinessObjectBase
implements Comparable<CommitteeBatchCorrespondenceBase> {
    private static final long serialVersionUID = 1L;
    private String committeeBatchCorrespondenceId;
    private String committeeId;
    private String batchCorrespondenceTypeCode;
    private Timestamp batchRunDate;
    private Date timeWindowStart;
    private Date timeWindowEnd;
    private List<CommitteeBatchCorrespondenceDetailBase> committeeBatchCorrespondenceDetails;
    private BatchCorrespondenceBase batchCorrespondence;
    private CommitteeBase committee;
    private transient int finalActionCounter;
    private transient DateTimeService dateTimeService;

    public CommitteeBatchCorrespondenceBase() {
        this.setCommitteeBatchCorrespondenceDetails(new ArrayList());
    }

    public CommitteeBatchCorrespondenceBase(String batchCorrespondenceTypeCode, String committeeId, Date startDate, Date endDate) {
        this();
        this.setCommitteeBatchCorrespondenceId(((SequenceAccessorService)KraServiceLocator.getService(SequenceAccessorService.class)).getNextAvailableSequenceNumber("SEQ_COMMITTEE_ID").toString());
        this.setCommitteeId(committeeId);
        this.setBatchCorrespondenceTypeCode(batchCorrespondenceTypeCode);
        this.setBatchRunDate(this.getDateTimeService().getCurrentTimestamp());
        this.setTimeWindowStart(startDate);
        this.setTimeWindowEnd(endDate);
        this.setFinalActionCounter(0);
    }

    public String getCommitteeBatchCorrespondenceId() {
        return this.committeeBatchCorrespondenceId;
    }

    public void setCommitteeBatchCorrespondenceId(String committeeBatchCorrespondenceId) {
        this.committeeBatchCorrespondenceId = committeeBatchCorrespondenceId;
    }

    public String getCommitteeId() {
        return this.committeeId;
    }

    public void setCommitteeId(String committeeId) {
        this.committeeId = committeeId;
    }

    public String getBatchCorrespondenceTypeCode() {
        return this.batchCorrespondenceTypeCode;
    }

    public void setBatchCorrespondenceTypeCode(String batchCorrespondenceTypeCode) {
        this.batchCorrespondenceTypeCode = batchCorrespondenceTypeCode;
    }

    public Timestamp getBatchRunDate() {
        return this.batchRunDate;
    }

    public void setBatchRunDate(Timestamp batchRunDate) {
        this.batchRunDate = batchRunDate;
    }

    public String getFormattedBatchRunDate() {
        return new SimpleDateFormat("MM/dd/yyyy").format(this.batchRunDate);
    }

    public String getFormattedBatchRunTime() {
        return new SimpleDateFormat("h:mm a").format(this.batchRunDate);
    }

    public Date getTimeWindowStart() {
        return this.timeWindowStart;
    }

    public void setTimeWindowStart(Date timeWindowStart) {
        this.timeWindowStart = timeWindowStart;
    }

    public String getFormattedTimeWindowStart() {
        return new SimpleDateFormat("MM/dd/yyyy").format(this.timeWindowStart);
    }

    public Date getTimeWindowEnd() {
        return this.timeWindowEnd;
    }

    public void setTimeWindowEnd(Date timeWindowEnd) {
        this.timeWindowEnd = timeWindowEnd;
    }

    public String getFormattedTimeWindowEnd() {
        return new SimpleDateFormat("MM/dd/yyyy").format(this.timeWindowEnd);
    }

    public List<CommitteeBatchCorrespondenceDetailBase> getCommitteeBatchCorrespondenceDetails() {
        return this.committeeBatchCorrespondenceDetails;
    }

    public void setCommitteeBatchCorrespondenceDetails(List<CommitteeBatchCorrespondenceDetailBase> committeeBatchCorrespondenceDetails) {
        this.committeeBatchCorrespondenceDetails = committeeBatchCorrespondenceDetails;
    }

    public BatchCorrespondenceBase getBatchCorrespondence() {
        return this.batchCorrespondence;
    }

    public void setBatchCorrespondence(BatchCorrespondenceBase batchCorrespondence) {
        this.batchCorrespondence = batchCorrespondence;
    }

    public CommitteeBase getCommittee() {
        return this.committee;
    }

    public void setCommittee(CommitteeBase committee) {
        this.committee = committee;
    }

    @Override
    public int compareTo(CommitteeBatchCorrespondenceBase arg) {
        int timeWindowStartDiff = this.getTimeWindowStart().compareTo(arg.getTimeWindowStart());
        if (timeWindowStartDiff != 0) {
            return timeWindowStartDiff;
        }
        int timeWindowEndDiff = this.getTimeWindowEnd().compareTo(arg.getTimeWindowEnd());
        if (timeWindowEndDiff != 0) {
            return timeWindowEndDiff;
        }
        int batchRunDateDiff = this.getBatchRunDate().compareTo(arg.getBatchRunDate());
        if (batchRunDateDiff != 0) {
            return batchRunDateDiff;
        }
        return this.getCommitteeBatchCorrespondenceId().compareTo(arg.getCommitteeBatchCorrespondenceId());
    }

    public int getFinalActionCounter() {
        return this.finalActionCounter;
    }

    public void setFinalActionCounter(int finalActionCounter) {
        this.finalActionCounter = finalActionCounter;
    }

    private DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)KraServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }
}

