/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.bo;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.committee.bo.CommitteeAssociateBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipExpertiseBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.bo.CommitteeMembershipType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.personnel.ProtocolPersonRolodexBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.util.DateUtils;

public abstract class CommitteeMembershipBase
extends CommitteeAssociateBase {
    private static final long serialVersionUID = 3036751811459612428L;
    private final String DATE_FORMAT = "MM/dd/yyyy";
    private Long committeeMembershipId;
    private String personId;
    private Integer rolodexId;
    private String personName;
    private String membershipId;
    private boolean paidMember;
    private Date termStartDate;
    private Date termEndDate;
    private String membershipTypeCode;
    private String comments;
    private String contactNotes;
    private String trainingNotes;
    private List<CommitteeMembershipRole> membershipRoles;
    private List<CommitteeMembershipExpertiseBase> membershipExpertise;
    private CommitteeMembershipType membershipType;
    private ProtocolPersonRolodexBase rolodex;
    private boolean delete;
    private boolean wasInactiveAtLastSave;
    private transient KcPersonService kcPersonService;
    private transient KcPerson kcPerson;

    public CommitteeMembershipBase() {
        this.setMembershipRoles(new ArrayList());
        this.setMembershipExpertise(new ArrayList());
    }

    public Long getCommitteeMembershipId() {
        return this.committeeMembershipId;
    }

    public void setCommitteeMembershipId(Long committeeMembershipId) {
        this.committeeMembershipId = committeeMembershipId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public String getMembershipId() {
        return this.membershipId;
    }

    public void setMembershipId(String membershipId) {
        this.membershipId = membershipId;
    }

    public boolean getPaidMember() {
        return this.paidMember;
    }

    public void setPaidMember(boolean paidMemberFlag) {
        this.paidMember = paidMemberFlag;
    }

    public Date getTermStartDate() {
        return this.termStartDate;
    }

    public String getFormattedTermStartDate() {
        if (this.termStartDate == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        return dateFormat.format(this.termStartDate);
    }

    public void setTermStartDate(Date termStartDate) {
        this.termStartDate = termStartDate;
    }

    public Date getTermEndDate() {
        return this.termEndDate;
    }

    public String getFormattedTermEndDate() {
        if (this.termEndDate == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        return dateFormat.format(this.termEndDate);
    }

    public void setTermEndDate(Date termEndDate) {
        this.termEndDate = termEndDate;
    }

    public String getMembershipTypeCode() {
        return this.membershipTypeCode;
    }

    public void setMembershipTypeCode(String membershipTypeCode) {
        this.membershipTypeCode = membershipTypeCode;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getContactNotes() {
        return this.contactNotes;
    }

    public void setContactNotes(String contactNotes) {
        this.contactNotes = contactNotes;
    }

    public String getTrainingNotes() {
        return this.trainingNotes;
    }

    public void setTrainingNotes(String trainingNotes) {
        this.trainingNotes = trainingNotes;
    }

    public void setMembershipRoles(List<CommitteeMembershipRole> membershipRoles) {
        this.membershipRoles = membershipRoles;
    }

    public List<CommitteeMembershipRole> getMembershipRoles() {
        return this.membershipRoles;
    }

    public void setMembershipExpertise(List<CommitteeMembershipExpertiseBase> committeeMembershipExpertise) {
        this.membershipExpertise = committeeMembershipExpertise;
    }

    public List<CommitteeMembershipExpertiseBase> getMembershipExpertise() {
        return this.membershipExpertise;
    }

    public CommitteeMembershipType getMembershipType() {
        return this.membershipType;
    }

    public void setMembershipType(CommitteeMembershipType membershipType) {
        this.membershipType = membershipType;
    }

    public KcPerson getPerson() {
        if (this.kcPerson == null && StringUtils.isNotBlank((String)this.personId)) {
            this.kcPerson = this.getKcPersonService().getKcPersonByPersonId(this.personId);
        }
        return this.kcPerson;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public ProtocolPersonRolodexBase getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(ProtocolPersonRolodexBase rolodex) {
        this.rolodex = rolodex;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean getWasInactiveAtLastSave() {
        return this.wasInactiveAtLastSave;
    }

    public void setWasInactiveAtLastSave(boolean wasInactiveAtLastSave) {
        this.wasInactiveAtLastSave = wasInactiveAtLastSave;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CommitteeMembershipBase committeeMembership = (CommitteeMembershipBase)obj;
        return this.getCommitteeIdFk() != null && this.getCommitteeIdFk().equals(committeeMembership.getCommitteeIdFk()) && (this.getPersonId() != null && this.getPersonId().equals(committeeMembership.getPersonId()) || this.getRolodexId() != null && this.getRolodexId().equals(committeeMembership.getRolodexId())) && this.getTermStartDate() != null && this.getTermStartDate().equals(committeeMembership.getTermStartDate());
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.getCommitteeIdFk() == null ? 0 : this.getCommitteeIdFk().hashCode());
        result = 31 * result + (this.getPersonId() == null ? 0 : this.getPersonId().hashCode());
        result = 31 * result + (this.getRolodexId() == null ? 0 : this.getRolodexId().hashCode());
        result = 31 * result + (this.getTermStartDate() == null ? 0 : this.getTermStartDate().hashCode());
        return result;
    }

    public boolean isActive() {
        Date currentDate = DateUtils.clearTimeFields((Date)new Date(System.currentTimeMillis()));
        return this.isActive(currentDate);
    }

    public boolean isActive(Date date) {
        boolean isActive = false;
        for (CommitteeMembershipRole role : this.membershipRoles) {
            if (role.getStartDate() == null || role.getEndDate() == null || date.before(role.getStartDate()) || date.after(role.getEndDate())) continue;
            if (role.getMembershipRoleCode().equals("14")) {
                isActive = false;
                break;
            }
            isActive = true;
        }
        return isActive;
    }

    public boolean isSamePerson(CommitteeMembershipBase committeeMembership) {
        boolean isEquals = false;
        if (this.getPersonId() != null && this.getPersonId().equals(committeeMembership.getPersonId()) || this.getRolodexId() != null && this.getRolodexId().equals(committeeMembership.getRolodexId())) {
            isEquals = true;
        }
        return isEquals;
    }

    public void resetPersistenceState() {
        this.setCommitteeMembershipId(null);
    }

    public boolean hasTermEnded() {
        boolean retVal = true;
        Date currentDate = DateUtils.clearTimeFields((Date)new Date(System.currentTimeMillis()));
        if (this.termEndDate != null && !this.termEndDate.before(currentDate)) {
            retVal = false;
        }
        return retVal;
    }

    public boolean isRepresentingPerson(String personId) {
        boolean retVal = false;
        if (this.personId != null) {
            retVal = this.personId.equals(personId);
        }
        return retVal;
    }
}

