/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.bo;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.drools.core.util.StringUtils;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.common.committee.bo.CommitteeAssociateBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.ScheduleStatus;
import org.kuali.kra.common.committee.meeting.CommScheduleActItemBase;
import org.kuali.kra.common.committee.meeting.CommScheduleMinuteDocBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttachmentsBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.meeting.ScheduleAgendaBase;
import org.kuali.kra.common.committee.web.struts.form.schedule.DayOfWeek;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.util.DateUtils;

public abstract class CommitteeScheduleBase<CS extends CommitteeScheduleBase<CS, CMT, PS, CSM>, CMT extends CommitteeBase<CMT, ?, CS>, PS extends ProtocolSubmissionBase, CSM extends CommitteeScheduleMinuteBase<CSM, CS>>
extends CommitteeAssociateBase
implements Comparable<CS>,
Permissionable {
    private static final long serialVersionUID = -360139608123017188L;
    public static final Long DEFAULT_SCHEDULE_ID = 9999999999L;
    private Time12HrFmt viewTime;
    private boolean filter = true;
    private boolean delete = false;
    private transient boolean selected = false;
    private Long id;
    private String scheduleId;
    private Date scheduledDate;
    private String place;
    private Timestamp time;
    private Date protocolSubDeadline;
    private Integer scheduleStatusCode;
    private Date meetingDate;
    private Timestamp startTime;
    private Timestamp endTime;
    private Date agendaProdRevDate;
    private Integer maxProtocols;
    private String comments;
    private boolean availableToReviewers;
    private ScheduleStatus scheduleStatus;
    @SkipVersioning
    private List<ProtocolBase> protocols;
    private Time12HrFmt viewStartTime;
    private Time12HrFmt viewEndTime;
    private transient List<CommitteeScheduleAttendanceBase> committeeScheduleAttendances;
    private transient List<CSM> committeeScheduleMinutes;
    private transient List<CommitteeScheduleAttachmentsBase> committeeScheduleAttachments;
    @SkipVersioning
    private transient List<PS> protocolSubmissions;
    private transient List<CommScheduleActItemBase> commScheduleActItems;
    private transient List<CommScheduleMinuteDocBase> minuteDocs;
    private transient List<ScheduleAgendaBase> scheduleAgendas;

    public CommitteeScheduleBase() {
        this.setCommitteeScheduleAttendances(new ArrayList());
        this.setCommScheduleActItems(new ArrayList());
        this.setProtocolSubmissions(new ArrayList());
        this.setCommitteeScheduleMinutes(new ArrayList());
        this.setMinuteDocs(new ArrayList());
        this.setScheduleAgendas(new ArrayList());
        this.setCommitteeScheduleAttachments(new ArrayList());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public Date getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(Date scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public Timestamp getTime() {
        java.util.Date dt = new java.util.Date(this.time.getTime());
        dt = DateUtils.round((java.util.Date)dt, (int)5);
        if (this.viewTime != null) {
            dt = new java.util.Date(0L);
            dt = DateUtils.round((java.util.Date)dt, (int)5);
            dt = DateUtils.addMinutes((java.util.Date)dt, (int)this.viewTime.findMinutes());
            this.time = new Timestamp(dt.getTime());
        }
        return this.time;
    }

    public void setTime(Timestamp time) {
        this.time = time;
    }

    public Timestamp getActualTime() {
        return this.time;
    }

    public Date getProtocolSubDeadline() {
        return this.protocolSubDeadline;
    }

    public void setProtocolSubDeadline(Date protocolSubDeadline) {
        this.protocolSubDeadline = protocolSubDeadline;
    }

    public Integer getScheduleStatusCode() {
        return this.scheduleStatusCode;
    }

    public void setScheduleStatusCode(Integer scheduleStatusCode) {
        this.scheduleStatusCode = scheduleStatusCode;
    }

    public Date getMeetingDate() {
        return this.meetingDate;
    }

    public void setMeetingDate(Date meetingDate) {
        this.meetingDate = meetingDate;
    }

    public Timestamp getStartTime() {
        if (this.startTime == null || this.startTime.getTime() == 0L) {
            java.util.Date dt = new java.util.Date(0L);
            dt = DateUtils.round((java.util.Date)dt, (int)5);
            if (this.viewStartTime != null) {
                dt = DateUtils.addMinutes((java.util.Date)dt, (int)this.viewStartTime.findMinutes());
            }
            this.startTime = new Timestamp(dt.getTime());
        }
        return this.startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getEndTime() {
        if (this.endTime == null || this.endTime.getTime() == 0L) {
            java.util.Date dt = new java.util.Date(0L);
            dt = DateUtils.round((java.util.Date)dt, (int)5);
            if (this.viewEndTime != null) {
                dt = DateUtils.addMinutes((java.util.Date)dt, (int)this.viewEndTime.findMinutes());
            }
            this.endTime = new Timestamp(dt.getTime());
        }
        return this.endTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public Date getAgendaProdRevDate() {
        return this.agendaProdRevDate;
    }

    public void setAgendaProdRevDate(Date agendaProdRevDate) {
        this.agendaProdRevDate = agendaProdRevDate;
    }

    public Integer getMaxProtocols() {
        if (this.maxProtocols == null) {
            this.maxProtocols = this.getParentCommittee().getMaxProtocols();
        }
        return this.maxProtocols;
    }

    public void setMaxProtocols(Integer maxProtocols) {
        if (maxProtocols == null) {
            maxProtocols = 0;
        }
        this.maxProtocols = maxProtocols;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public boolean isAvailableToReviewers() {
        return this.availableToReviewers;
    }

    public void setAvailableToReviewers(boolean availableToReviewers) {
        this.availableToReviewers = availableToReviewers;
    }

    public abstract CMT getParentCommittee();

    public abstract void setCommittee(CMT var1);

    public ScheduleStatus getScheduleStatus() {
        return this.scheduleStatus;
    }

    public void setScheduleStatus(ScheduleStatus scheduleStatus) {
        this.scheduleStatus = scheduleStatus;
    }

    public void setDayOfWeek(String dayOfWeek) {
    }

    public String getDayOfWeek() {
        GregorianCalendar cl = new GregorianCalendar();
        cl.setTime(this.scheduledDate);
        DayOfWeek dayOfWeek = null;
        switch (cl.get(7)) {
            case 1: {
                dayOfWeek = DayOfWeek.Sunday;
                break;
            }
            case 2: {
                dayOfWeek = DayOfWeek.Monday;
                break;
            }
            case 3: {
                dayOfWeek = DayOfWeek.Tuesday;
                break;
            }
            case 4: {
                dayOfWeek = DayOfWeek.Wednesday;
                break;
            }
            case 5: {
                dayOfWeek = DayOfWeek.Thursday;
                break;
            }
            case 6: {
                dayOfWeek = DayOfWeek.Friday;
                break;
            }
            case 7: {
                dayOfWeek = DayOfWeek.Saturday;
            }
        }
        return dayOfWeek.name().toUpperCase();
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public boolean getFilter() {
        return this.filter;
    }

    public Time12HrFmt getViewTime() {
        if (null == this.viewTime) {
            this.viewTime = new Time12HrFmt(this.time);
        }
        return this.viewTime;
    }

    public void setViewTime(Time12HrFmt viewTime) {
        this.viewTime = viewTime;
    }

    public boolean getDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public List<ProtocolBase> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<ProtocolBase> protocols) {
        this.protocols = protocols;
    }

    public List<CommitteeScheduleAttendanceBase> getCommitteeScheduleAttendances() {
        return this.committeeScheduleAttendances;
    }

    public void setCommitteeScheduleAttendances(List<CommitteeScheduleAttendanceBase> committeeScheduleAttendances) {
        this.committeeScheduleAttendances = committeeScheduleAttendances;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CommitteeScheduleBase committeeSchedule = (CommitteeScheduleBase)obj;
        return this.getId() != null && this.getId().equals(committeeSchedule.getId());
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public int compareTo(CS other) {
        int compareResult = this.getScheduledDate() == null ? (other.getScheduledDate() == null ? 0 : -1) : (other.getScheduledDate() == null ? 1 : this.getScheduledDate().compareTo(other.getScheduledDate()));
        return compareResult;
    }

    public void resetPersistenceState() {
        this.setId(null);
    }

    public List<PS> getProtocolSubmissions() {
        return this.protocolSubmissions;
    }

    public List<PS> getLatestProtocolSubmissions() {
        TreeMap<String, ProtocolSubmissionBase> latestSubmissions = new TreeMap<String, ProtocolSubmissionBase>();
        ArrayList<Object> returnList = new ArrayList<Object>();
        for (ProtocolSubmissionBase submission : this.protocolSubmissions) {
            if (submission.getProtocol() == null || StringUtils.isEmpty((CharSequence)submission.getProtocol().getProtocolNumber())) {
                returnList.add(submission);
                continue;
            }
            String key = submission.getProtocol().getProtocolNumber();
            if (!submission.getProtocol().isActive()) continue;
            ProtocolSubmissionBase existingSubmission = (ProtocolSubmissionBase)latestSubmissions.get(key);
            if (existingSubmission == null) {
                latestSubmissions.put(key, submission);
                continue;
            }
            int newInt = submission.getSequenceNumber();
            int existInt = existingSubmission.getSequenceNumber();
            int newSubNum = submission.getSubmissionNumber();
            int existSubNum = existingSubmission.getSubmissionNumber();
            if (newInt <= existInt && (newInt != existInt || newSubNum <= existSubNum)) continue;
            latestSubmissions.put(key, submission);
        }
        returnList.addAll(latestSubmissions.values());
        return returnList;
    }

    public void setProtocolSubmissions(List<PS> protocolSubmissions) {
        this.protocolSubmissions = protocolSubmissions;
    }

    public Time12HrFmt getViewStartTime() {
        if (null == this.viewStartTime) {
            this.viewStartTime = new Time12HrFmt(this.startTime);
        }
        return this.viewStartTime;
    }

    public void setViewStartTime(Time12HrFmt viewStartTime) {
        this.viewStartTime = viewStartTime;
    }

    public Time12HrFmt getViewEndTime() {
        if (null == this.viewEndTime) {
            this.viewEndTime = new Time12HrFmt(this.endTime);
        }
        return this.viewEndTime;
    }

    public void setViewEndTime(Time12HrFmt viewEndTime) {
        this.viewEndTime = viewEndTime;
    }

    public List<CommScheduleActItemBase> getCommScheduleActItems() {
        return this.commScheduleActItems;
    }

    public void setCommScheduleActItems(List<CommScheduleActItemBase> commScheduleActItems) {
        this.commScheduleActItems = commScheduleActItems;
    }

    public List<CSM> getCommitteeScheduleMinutes() {
        return this.committeeScheduleMinutes;
    }

    public void setCommitteeScheduleMinutes(List<CSM> committeeScheduleMinutes) {
        this.committeeScheduleMinutes = committeeScheduleMinutes;
    }

    public List<CommitteeScheduleAttachmentsBase> getCommitteeScheduleAttachments() {
        return this.committeeScheduleAttachments;
    }

    public void setCommitteeScheduleAttachments(List<CommitteeScheduleAttachmentsBase> committeeScheduleAttachments) {
        this.committeeScheduleAttachments = committeeScheduleAttachments;
    }

    public List<CommScheduleMinuteDocBase> getMinuteDocs() {
        return this.minuteDocs;
    }

    public void setMinuteDocs(List<CommScheduleMinuteDocBase> minuteDocs) {
        this.minuteDocs = minuteDocs;
    }

    public List<ScheduleAgendaBase> getScheduleAgendas() {
        return this.scheduleAgendas;
    }

    public void setScheduleAgendas(List<ScheduleAgendaBase> scheduleAgendas) {
        this.scheduleAgendas = scheduleAgendas;
    }

    public String getDocumentKey() {
        return "committeeSchedule";
    }

    public String getDocumentNumberForPermission() {
        return this.getScheduleId();
    }

    public String getDocumentRoleTypeCode() {
        return null;
    }

    public String getLeadUnitNumber() {
        return null;
    }

    public String getNamespace() {
        return this.getParentCommittee().getNamespace();
    }

    public List<String> getRoleNames() {
        ArrayList<String> roleNames = new ArrayList<String>();
        roleNames.add("IRB Administrator");
        roleNames.add("IRB Reviewer");
        return roleNames;
    }

    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        qualifiedRoleAttributes.put("committee", this.getParentCommittee().getCommitteeId());
        qualifiedRoleAttributes.put("committeeSchedule", this.getScheduleId());
    }

    public boolean isActiveFor(String personId) {
        CommitteeMembershipBase member;
        boolean retVal = false;
        CommitteeBase parentCommittee = this.getParentCommittee();
        if (parentCommittee != null && (member = parentCommittee.getCommitteeMembershipFor(personId)) != null) {
            retVal = member.isActive(this.scheduledDate);
        }
        return retVal;
    }

    public boolean isScheduleDateInPast() {
        boolean retVal = false;
        Date currentDate = DateUtils.clearTimeFields((Date)new Date(System.currentTimeMillis()));
        if (this.scheduledDate != null) {
            retVal = this.scheduledDate.before(currentDate);
        }
        return retVal;
    }
}

