/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.bo.CommitteeResearchAreaBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CommitteeLookupableHelperServiceImplBase<CMT extends CommitteeBase<CMT, CD, ?>, CD extends CommitteeDocumentBase<CD, CMT, ?>>
extends KraLookupableHelperServiceImpl {
    private static final String COMMITTEE_TYPE_CODE_FIELD_NAME = "committeeTypeCode";
    private static final String PERSON_NAME = "personName";
    private static final String RESEARCH_AREA_CODE = "researchAreaCode";
    private static final String DOCHANDLER_LINK = "%s/DocHandler.do?command=displayDocSearchView&docId=%s";

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        fieldValues.put(COMMITTEE_TYPE_CODE_FIELD_NAME, this.getCommitteeTypeCodeHook());
        List activeCommittees = this.getUniqueList(super.getSearchResultsUnbounded(fieldValues), fieldValues);
        Long matchingResultsCount = new Long(activeCommittees.size());
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit(Question.class);
        if (matchingResultsCount == null || matchingResultsCount.intValue() <= searchResultsLimit) {
            return new CollectionIncomplete((Collection)activeCommittees, new Long(0L));
        }
        return new CollectionIncomplete((Collection)this.trimResult(activeCommittees, searchResultsLimit), matchingResultsCount);
    }

    protected abstract String getCommitteeTypeCodeHook();

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (field.getPropertyName().equals("committeeResearchAreas.researchAreaCode")) {
                    super.updateLookupField(field, RESEARCH_AREA_CODE, "org.kuali.kra.bo.ResearchArea");
                    continue;
                }
                if (!field.getPropertyName().equals("committeeMemberships.personName")) continue;
                super.updateLookupField(field, PERSON_NAME, this.getCommitteeMembershipFullyQualifiedClassNameHook());
            }
        }
        return rows;
    }

    protected abstract String getCommitteeMembershipFullyQualifiedClassNameHook();

    protected List<? extends BusinessObject> getUniqueList(List<? extends BusinessObject> searchResults, Map<String, String> fieldValues) {
        ArrayList<CommitteeBase> uniqueResults = new ArrayList<CommitteeBase>();
        ArrayList<String> committeeIds = new ArrayList<String>();
        searchResults.addAll(this.getUnapprovedCommittees(fieldValues));
        if (CollectionUtils.isNotEmpty(searchResults)) {
            Collections.sort(searchResults, Collections.reverseOrder());
            for (CommitteeBase committeeBase : searchResults) {
                if (committeeIds.contains(committeeBase.getCommitteeId())) continue;
                committeeBase.getCommitteeChair();
                uniqueResults.add(committeeBase);
                committeeIds.add(committeeBase.getCommitteeId());
            }
        }
        return uniqueResults;
    }

    protected abstract String getHtmlAction();

    protected abstract String getDocumentTypeName();

    protected String getKeyFieldName() {
        return "committeeId";
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        HtmlData.AnchorHtmlData htmlData;
        List<Object> htmlDataList = new ArrayList<HtmlData>();
        String editCommitteeDocId = this.getEditedCommitteeDocId((CommitteeBase)businessObject);
        boolean isUnappprovedCommittee = false;
        if ("S".equals(((CommitteeBase)businessObject).getCommitteeDocument().getDocStatusCode()) && ((CommitteeBase)businessObject).getSequenceNumber() == 1) {
            isUnappprovedCommittee = true;
            editCommitteeDocId = ((CommitteeBase)businessObject).getCommitteeDocument().getDocumentNumber();
        }
        if (this.getKraAuthorizationService().hasPermission(this.getUserIdentifier(), (Permissionable)((CommitteeBase)businessObject), this.getModifyCommitteePermissionNameHook())) {
            htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
            if (StringUtils.isNotBlank((String)editCommitteeDocId)) {
                htmlData = (HtmlData.AnchorHtmlData)htmlDataList.get(0);
                CommitteeDocumentBase document = ((CommitteeBase)businessObject).getCommitteeDocument();
                String workflowUrl = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
                htmlData.setHref(String.format(DOCHANDLER_LINK, workflowUrl, editCommitteeDocId));
                htmlData.setDisplayText("resume edit");
            }
        }
        if (!isUnappprovedCommittee && this.getKraAuthorizationService().hasPermission(this.getUserIdentifier(), (Permissionable)((CommitteeBase)businessObject), this.getViewCommitteePermissionNameHook())) {
            htmlData = this.getViewLink((Document)((CommitteeBase)businessObject).getCommitteeDocument());
            htmlData.setDisplayText("view active");
            htmlDataList.add(htmlData);
        }
        return htmlDataList;
    }

    protected abstract String getViewCommitteePermissionNameHook();

    protected abstract String getModifyCommitteePermissionNameHook();

    protected String getEditedCommitteeDocId(CMT committee) {
        String docId = null;
        List documents = this.getCommitteeDocuments(committee.getCommitteeId());
        if (CollectionUtils.isNotEmpty((Collection)documents)) {
            docId = ((CommitteeDocumentBase)documents.get(0)).getDocumentNumber();
        }
        return docId;
    }

    protected List<CD> getCommitteeDocuments(String committeeId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", committeeId);
        List documents = (List)this.getBusinessObjectService().findMatching(this.getCommitteeDocumentBOClassHook(), fieldValues);
        ArrayList<CommitteeDocumentBase> result = new ArrayList<CommitteeDocumentBase>();
        for (CommitteeDocumentBase commDoc : documents) {
            if (!"S".equals(commDoc.getDocStatusCode())) continue;
            result.add(commDoc);
        }
        return result;
    }

    protected abstract Class<CD> getCommitteeDocumentBOClassHook();

    protected List<CMT> getUnapprovedCommittees(Map<String, String> criterias) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("docStatusCode", "S");
        List documents = (List)this.getBusinessObjectService().findMatching(this.getCommitteeDocumentBOClassHook(), fieldValues);
        ArrayList<CommitteeBase> result = new ArrayList<CommitteeBase>();
        List committeeIds = this.getCommitteeIds();
        for (CommitteeDocumentBase commDoc : documents) {
            if (committeeIds.contains(commDoc.getCommitteeId())) continue;
            try {
                CommitteeDocumentBase workflowCommitteeDoc = (CommitteeDocumentBase)((DocumentService)KraServiceLocator.getService(DocumentService.class)).getByDocumentHeaderId(commDoc.getDocumentNumber());
                String content = ((RouteHeaderService)KraServiceLocator.getService(RouteHeaderService.class)).getContent(workflowCommitteeDoc.getDocumentHeader().getWorkflowDocument().getDocumentId()).getDocumentContent();
                commDoc.getCommitteeList().add(this.populateCommitteeFromXmlDocumentContents(content));
                if (!this.isCriteriaMatched(commDoc.getCommittee(), criterias)) continue;
                commDoc.getCommittee().setCommitteeDocument(commDoc);
                result.add(commDoc.getCommittee());
            }
            catch (Exception e) {
                LOG.info((Object)("CommitteeBase Doc " + commDoc.getDocumentNumber() + " parsing error"));
            }
        }
        return result;
    }

    protected boolean isCriteriaMatched(CMT committee, Map<String, String> criterias) {
        boolean isMatch;
        boolean bl = isMatch = this.isMatching(criterias.get("committeeId"), committee.getCommitteeId()) && this.isMatching(criterias.get("committeeName"), committee.getCommitteeName()) && this.isMatching(criterias.get("homeUnitNumber"), committee.getHomeUnitNumber()) && this.isMatching(criterias.get("committeeDescription"), committee.getCommitteeDescription()) && this.isMatchingCode(criterias.get(COMMITTEE_TYPE_CODE_FIELD_NAME), committee.getCommitteeTypeCode()) && this.isMatchingCode(criterias.get("reviewTypeCode"), committee.getReviewTypeCode());
        if (isMatch && (StringUtils.isNotBlank((String)criterias.get("committeeMemberships.personName")) || StringUtils.isNotBlank((String)criterias.get("committeeMemberships.membershipRoles.membershipRoleCode")))) {
            if (CollectionUtils.isNotEmpty((Collection)committee.getCommitteeMemberships())) {
                if (StringUtils.isNotBlank((String)criterias.get("committeeMemberships.personName"))) {
                    isMatch = this.isMemberNameMatch(criterias.get("committeeMemberships.personName"), committee.getCommitteeMemberships());
                }
                if (isMatch && StringUtils.isNotBlank((String)criterias.get("committeeMemberships.membershipRoles.membershipRoleCode"))) {
                    isMatch = this.isMemberRoleMatch(criterias.get("committeeMemberships.membershipRoles.membershipRoleCode"), committee.getCommitteeMemberships());
                }
            } else {
                isMatch = false;
            }
        }
        if (isMatch && StringUtils.isNotBlank((String)criterias.get("committeeResearchAreas.researchAreaCode"))) {
            isMatch = CollectionUtils.isNotEmpty((Collection)committee.getCommitteeResearchAreas()) ? this.isAreaResearchMatch(criterias.get("committeeResearchAreas.researchAreaCode"), committee.getCommitteeResearchAreas()) : false;
        }
        if (isMatch) {
            committee.refreshReferenceObject("homeUnit");
        }
        return isMatch;
    }

    protected boolean isMemberNameMatch(String matchmember, List<CommitteeMembershipBase> members) {
        boolean isMatch = false;
        for (CommitteeMembershipBase member : members) {
            if (!this.isMatching(matchmember, member.getPersonName())) continue;
            isMatch = true;
            break;
        }
        return isMatch;
    }

    protected boolean isMemberRoleMatch(String matchRoleCode, List<CommitteeMembershipBase> members) {
        boolean isMatch = false;
        block0: for (CommitteeMembershipBase member : members) {
            for (CommitteeMembershipRole role : member.getMembershipRoles()) {
                if (!this.isMatchingCode(matchRoleCode, role.getMembershipRoleCode())) continue;
                isMatch = true;
                continue block0;
            }
        }
        return isMatch;
    }

    protected boolean isAreaResearchMatch(String matchArea, List<CommitteeResearchAreaBase> researchAreas) {
        boolean isMatch = false;
        for (CommitteeResearchAreaBase researchArea : researchAreas) {
            if (!this.isMatching(matchArea, researchArea.getResearchAreaCode())) continue;
            isMatch = true;
            break;
        }
        return isMatch;
    }

    protected boolean isMatching(String patternString, String value) {
        boolean isMatch = false;
        if (StringUtils.isBlank((String)patternString)) {
            isMatch = true;
        } else {
            patternString = patternString.replaceAll("\\?", "\\\\?");
            if ((patternString = patternString.replaceAll("\\.", "\\\\.")).indexOf("*") == 0) {
                patternString = patternString.replaceFirst("\\*", "^*");
            }
            if (!patternString.endsWith("*")) {
                patternString = patternString + "$";
            }
            Pattern p = Pattern.compile(patternString.toUpperCase());
            Matcher m = p.matcher(value.toUpperCase());
            isMatch = m.find();
        }
        return isMatch;
    }

    protected boolean isMatchingCode(String selectedCode, String value) {
        boolean isMatch = false;
        isMatch = StringUtils.isBlank((String)selectedCode) ? true : selectedCode.equals(value);
        return isMatch;
    }

    protected CMT populateCommitteeFromXmlDocumentContents(String xmlDocumentContents) {
        CommitteeBase committee = null;
        if (!StringUtils.isEmpty((String)xmlDocumentContents)) {
            committee = (CommitteeBase)this.getBusinessObjectFromXML(xmlDocumentContents, this.getCommitteeBOClassHook().getName());
        }
        return (CMT)committee;
    }

    protected abstract Class<CMT> getCommitteeBOClassHook();

    protected PersistableBusinessObject getBusinessObjectFromXML(String xmlDocumentContents, String objectTagName) {
        String objXml = StringUtils.substringBetween((String)xmlDocumentContents, (String)("<" + objectTagName + ">"), (String)("</" + objectTagName + ">"));
        objXml = "<" + objectTagName + ">" + objXml + "</" + objectTagName + ">";
        if (objXml.contains("itemDesctiption")) {
            objXml = objXml.replaceAll("itemDesctiption", "itemDescription");
        }
        PersistableBusinessObject businessObject = (PersistableBusinessObject)KRADServiceLocator.getXmlObjectSerializerService().fromXml(objXml);
        return businessObject;
    }

    protected KraAuthorizationService getKraAuthorizationService() {
        return (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
    }

    protected List<String> getCommitteeIds() {
        List committees = (List)this.getBusinessObjectService().findAll(this.getCommitteeBOClassHook());
        ArrayList<String> result = new ArrayList<String>();
        for (CommitteeBase committee : committees) {
            if (result.contains(committee.getCommitteeId())) continue;
            result.add(committee.getCommitteeId());
        }
        return result;
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    protected List<CMT> trimResult(List<CMT> result, Integer trimSize) {
        ArrayList<CommitteeBase> trimedResult = new ArrayList<CommitteeBase>();
        for (CommitteeBase committee : result) {
            if (trimedResult.size() >= trimSize) continue;
            trimedResult.add(committee);
        }
        return trimedResult;
    }
}

