/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.document.authorization.CommitteeScheduleTaskBase;
import org.kuali.kra.common.committee.document.authorization.CommitteeTaskBase;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public abstract class CommitteeScheduleLookupableHelperServiceImplBase<CS extends CommitteeScheduleBase<CS, CMT, ?, ?>, CMT extends CommitteeBase<CMT, ?, CS>, CMTTSK extends CommitteeTaskBase<CMT>, CSTSK extends CommitteeScheduleTaskBase<CMT, CS>>
extends KualiLookupableHelperServiceImpl {
    private static final String READ_ONLY = "readOnly";
    private static final String COMMITTEE_COMMITTEE_NAME = "committee.committeeName";
    private static final String COMMITTEE_COMMITTEE_TYPE_CODE = "committee.committeeTypeCode";
    private static final String COMMITTEE_ID = "committeeId";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String SCHEDULE_PERSON_ID_LOOKUP = "committee.committeeMemberships.personId";
    private TaskAuthorizationService taskAuthorizationService;
    private List<Long> activeCommitteePKs = new ArrayList();
    private List<Long> inActiveCommitteePKs = new ArrayList();

    protected boolean isCurrentVersion(CMT committee) {
        boolean retValue = false;
        if (this.activeCommitteePKs.contains(committee.getId())) {
            retValue = true;
        } else if (!this.inActiveCommitteePKs.contains(committee.getId())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(COMMITTEE_ID, committee.getCommitteeId());
            List committees = (List)this.getBusinessObjectService().findMatchingOrderBy(this.getCommonCommitteeBOClassHook(), fieldValues, SEQUENCE_NUMBER, false);
            if (committees != null && !committees.isEmpty()) {
                if (((CommitteeBase)committees.get(0)).equals(committee)) {
                    retValue = true;
                }
                this.activeCommitteePKs.add(((CommitteeBase)committees.get(0)).getId());
                committees.remove(0);
                for (CommitteeBase cmt : committees) {
                    this.inActiveCommitteePKs.add(cmt.getId());
                }
            }
        }
        return retValue;
    }

    protected abstract Class<CMT> getCommonCommitteeBOClassHook();

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        fieldValues.put(COMMITTEE_COMMITTEE_TYPE_CODE, this.getCommitteeTypeCodeHook());
        List rawCommitteeSchedules = super.getSearchResultsUnbounded(fieldValues);
        ArrayList<Object> finalCommitteeSchedules = new ArrayList<Object>();
        for (CommitteeScheduleBase schedule : rawCommitteeSchedules) {
            if (schedule.getParentCommittee() == null || !this.isCurrentVersion(schedule.getParentCommittee())) continue;
            if (StringUtils.isNotBlank((String)fieldValues.get(SCHEDULE_PERSON_ID_LOOKUP))) {
                if ((!schedule.isActiveFor(fieldValues.get(SCHEDULE_PERSON_ID_LOOKUP)) || !schedule.isAvailableToReviewers()) && !this.canModifySchedule(schedule)) continue;
                finalCommitteeSchedules.add(schedule);
                continue;
            }
            finalCommitteeSchedules.add(schedule);
        }
        Collections.sort(finalCommitteeSchedules);
        if (StringUtils.isNotBlank((String)fieldValues.get(SCHEDULE_PERSON_ID_LOOKUP))) {
            CommitteeScheduleBase schedule;
            ArrayList<CommitteeScheduleBase> pastCommitteeSchedules = new ArrayList<CommitteeScheduleBase>();
            Iterator i$ = finalCommitteeSchedules.iterator();
            while (i$.hasNext() && (schedule = (CommitteeScheduleBase)i$.next()).isScheduleDateInPast()) {
                pastCommitteeSchedules.add(schedule);
            }
            finalCommitteeSchedules.removeAll(pastCommitteeSchedules);
            Collections.reverse(pastCommitteeSchedules);
            finalCommitteeSchedules.addAll(pastCommitteeSchedules);
        }
        Long matchingResultsCount = new Long(finalCommitteeSchedules.size());
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit((Class)this.getCommitteeScheduleBOClassHook());
        if (matchingResultsCount == null || matchingResultsCount.intValue() <= searchResultsLimit) {
            return new CollectionIncomplete(finalCommitteeSchedules, new Long(0L));
        }
        return new CollectionIncomplete((Collection)this.trimResult(finalCommitteeSchedules, searchResultsLimit), matchingResultsCount);
    }

    protected abstract Class<CS> getCommitteeScheduleBOClassHook();

    protected abstract String getCommitteeTypeCodeHook();

    protected List<CS> trimResult(List<CS> result, Integer trimSize) {
        ArrayList<CommitteeScheduleBase> trimmedResult = new ArrayList<CommitteeScheduleBase>();
        for (CommitteeScheduleBase committeeSchedule : result) {
            if (trimmedResult.size() >= trimSize) continue;
            trimmedResult.add(committeeSchedule);
        }
        return trimmedResult;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (this.canModifySchedule((CommitteeScheduleBase)businessObject)) {
            htmlDataList.add((HtmlData)this.getLink((CommitteeScheduleBase)businessObject, true));
            htmlDataList.add((HtmlData)this.getLink((CommitteeScheduleBase)businessObject, false));
        } else if (this.canViewSchedule((CommitteeScheduleBase)businessObject)) {
            htmlDataList.add((HtmlData)this.getLink((CommitteeScheduleBase)businessObject, false));
        }
        if (((CommitteeScheduleBase)businessObject).isScheduleDateInPast()) {
            HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
            htmlData.setDisplayText("(past)");
            htmlDataList.add((HtmlData)htmlData);
        }
        return htmlDataList;
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    protected HtmlData.AnchorHtmlData getLink(CS committeeSchedule, boolean isEdit) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        parameters.put("scheduleId", committeeSchedule.getId().toString());
        if (isEdit) {
            htmlData.setDisplayText("edit");
            parameters.put(READ_ONLY, "false");
        } else {
            htmlData.setDisplayText("view");
            parameters.put(READ_ONLY, "true");
        }
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getMeetingManagementActionIdHook() + ".do"), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected abstract String getMeetingManagementActionIdHook();

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        BusinessObject inqBo = bo;
        String inqPropertyName = propertyName;
        if (COMMITTEE_COMMITTEE_NAME.equals(propertyName)) {
            return new HtmlData.AnchorHtmlData();
        }
        return super.getInquiryUrl(inqBo, inqPropertyName);
    }

    protected boolean canModifySchedule(CS committeeSchedule) {
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("modifySchedule", committeeSchedule.getParentCommittee());
        return this.taskAuthorizationService.isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    protected abstract CMTTSK getNewCommitteeTaskInstanceHook(String var1, CMT var2);

    protected boolean canViewSchedule(CS committeeSchedule) {
        CommitteeScheduleTaskBase task = this.getNewCommitteeScheduleTaskInstanceHook("viewSchedule", committeeSchedule.getParentCommittee(), committeeSchedule);
        boolean result = this.taskAuthorizationService.isAuthorized(this.getUserIdentifier(), (Task)task);
        return result;
    }

    protected abstract CSTSK getNewCommitteeScheduleTaskInstanceHook(String var1, CMT var2, CS var3);

    public void setTaskAuthorizationService(TaskAuthorizationService taskAuthorizationService) {
        this.taskAuthorizationService = taskAuthorizationService;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!"committee.committeeId".equals(field.getPropertyName()) && !COMMITTEE_COMMITTEE_NAME.equals(field.getPropertyName())) continue;
                field.setQuickFinderClassNameImpl("");
            }
        }
        return rows;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

