/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.KeyValueComparator;
import org.kuali.kra.lookup.keyvalue.PrefixValuesFinder;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CommitteeIdByUnitValuesFinderBase<CMT extends CommitteeBase<CMT, ?, ?>>
extends KeyValuesBase {
    private static final long serialVersionUID = -3005003472800028011L;
    private String protocolLeadUnit;
    private String docRouteStatus;
    private String currentCommitteeId;
    public static final String FINAL_STATUS_CD = "F";
    private Set<String> unitIds = new HashSet();

    public List<KeyValue> getKeyValues() {
        Collection committees = this.getValidCommittees();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        if (CollectionUtils.isNotEmpty((Collection)committees)) {
            if (this.isSaved()) {
                this.getProtocolUnitIds();
                for (CommitteeBase committee : committees) {
                    if (!StringUtils.equalsIgnoreCase((String)committee.getCommitteeDocument().getDocStatusCode(), (String)FINAL_STATUS_CD) || !this.unitIds.contains(committee.getHomeUnit().getUnitNumber())) continue;
                    keyValues.add((KeyValue)new ConcreteKeyValue(committee.getCommitteeId(), committee.getCommitteeName()));
                }
            } else {
                this.getAdminUnitIds();
                for (CommitteeBase committee : committees) {
                    if (!this.unitIds.contains(committee.getHomeUnit().getUnitNumber()) && !committee.getCommitteeId().equals(this.getCurrentCommitteeId())) continue;
                    keyValues.add((KeyValue)new ConcreteKeyValue(committee.getCommitteeId(), committee.getCommitteeName()));
                }
            }
            Collections.sort(keyValues, new KeyValueComparator());
        }
        keyValues.add(0, (KeyValue)new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        return keyValues;
    }

    protected abstract String getCommitteeTypeCodeHook();

    private boolean isSaved() {
        return this.getDocRouteStatus().equals("S");
    }

    protected abstract String getRoleNameHook();

    private void getAdminUnitIds() {
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        Role roleInfo = this.getRoleService().getRoleByNamespaceCodeAndName("KC-UNT", this.getRoleNameHook());
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleInfo.getId());
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put("unitNumber", "*");
        HashMap qualifications = new HashMap(qualifiedRoleAttributes);
        boolean valid = this.getRoleService().principalHasRole(principalId, roleIds, qualifications);
        if (valid) {
            List principalQualifications = this.getRoleService().getNestedRoleQualifiersForPrincipalByRoleIds(principalId, roleIds, qualifications);
            for (Map attrSet : principalQualifications) {
                Unit unit = this.getUnitService().getUnit((String)attrSet.get("unitNumber"));
                if (unit == null) continue;
                this.unitIds.add(unit.getUnitNumber());
                if (!attrSet.containsKey("subunits") || !StringUtils.equalsIgnoreCase((String)"Y", (String)((String)attrSet.get("subunits")))) continue;
                List subUnits = this.getUnitService().getAllSubUnits((String)attrSet.get("unitNumber"));
                for (Unit u : subUnits) {
                    this.unitIds.add(u.getUnitNumber());
                }
            }
        }
    }

    private Collection<CMT> getValidCommittees() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("committeeTypeCode", this.getCommitteeTypeCodeHook());
        Collection allCommittees = ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findMatching(this.getCommitteeBOClassHook(), criteria);
        HashMap<String, CommitteeBase> committeeMap = new HashMap<String, CommitteeBase>();
        CommitteeBase tmpComm = null;
        for (CommitteeBase comm : allCommittees) {
            if (!FINAL_STATUS_CD.equalsIgnoreCase(comm.getCommitteeDocument().getDocStatusCode())) continue;
            if (committeeMap.containsKey(comm.getCommitteeId())) {
                tmpComm = (CommitteeBase)committeeMap.get(comm.getCommitteeId());
                if (comm.getSequenceNumber() <= tmpComm.getSequenceNumber()) continue;
                committeeMap.put(comm.getCommitteeId(), comm);
                continue;
            }
            committeeMap.put(comm.getCommitteeId(), comm);
        }
        return committeeMap.values();
    }

    protected abstract Class<CMT> getCommitteeBOClassHook();

    private void getProtocolUnitIds() {
        if (StringUtils.isNotBlank((String)this.protocolLeadUnit)) {
            this.unitIds.add(this.protocolLeadUnit);
            List subUnits = this.getUnitService().getAllSubUnits(this.protocolLeadUnit);
            for (Unit unit : subUnits) {
                this.unitIds.add(unit.getUnitNumber());
            }
            String topUnitNumber = this.getUnitService().getTopUnit().getUnitNumber();
            this.getParentUnitIds(this.protocolLeadUnit, topUnitNumber);
        }
    }

    private void getParentUnitIds(String currentUnitNumber, String topUnitNumber) {
        if (currentUnitNumber.equals(topUnitNumber)) {
            return;
        }
        String parentUnitNumber = this.getUnitService().getUnit(currentUnitNumber).getParentUnitNumber();
        Unit parentUnit = this.getUnitService().getUnit(parentUnitNumber);
        this.unitIds.add(parentUnit.getUnitNumber());
        this.getParentUnitIds(parentUnit.getUnitNumber(), topUnitNumber);
    }

    private UnitService getUnitService() {
        return (UnitService)KraServiceLocator.getService(UnitService.class);
    }

    private RoleService getRoleService() {
        return (RoleService)KraServiceLocator.getService(RoleService.class);
    }

    public String getProtocolLeadUnit() {
        return this.protocolLeadUnit;
    }

    public void setProtocolLeadUnit(String protocolLeadUnit) {
        this.protocolLeadUnit = protocolLeadUnit;
    }

    public String getDocRouteStatus() {
        return this.docRouteStatus;
    }

    public void setDocRouteStatus(String docRouteStatus) {
        this.docRouteStatus = docRouteStatus;
    }

    public String getCurrentCommitteeId() {
        return this.currentCommitteeId;
    }

    public void setCurrentCommitteeId(String currentCommitteeId) {
        this.currentCommitteeId = currentCommitteeId;
    }
}

