/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.KeyValueComparator;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class CommitteeIdValuesFinderBase
extends KeyValuesBase {
    private static final long serialVersionUID = -2721177236491755020L;
    private List<ProtocolCorrespondenceTemplateBase> correspondenceTemplates;
    private BusinessObjectService businessObjectService;

    public BusinessObjectService getBusinessObjectService() {
        if (null == this.businessObjectService) {
            this.setBusinessObjectService((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class));
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public List<CommitteeBase> getActiveCommittees() {
        ArrayList<CommitteeBase> returnCommitteeList = new ArrayList<CommitteeBase>();
        Collection committees = this.getBusinessObjectService().findAll(this.getCommitteeBOClassHook());
        if (CollectionUtils.isNotEmpty((Collection)committees)) {
            ArrayList<String> committeeIds = new ArrayList<String>();
            Collections.sort((List)committees, Collections.reverseOrder());
            for (CommitteeBase committee : committees) {
                if (committeeIds.contains(committee.getCommitteeId())) continue;
                returnCommitteeList.add(committee);
                committeeIds.add(committee.getCommitteeId());
            }
        }
        return returnCommitteeList;
    }

    protected abstract Class<? extends CommitteeBase> getCommitteeBOClassHook();

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        List committees = this.getActiveCommittees();
        if (CollectionUtils.isNotEmpty((Collection)committees)) {
            List excludedCommitteeIds = this.getExcludedCommitteeIds();
            for (CommitteeBase committee : committees) {
                if (excludedCommitteeIds.contains(committee.getCommitteeId())) continue;
                keyValues.add((KeyValue)new ConcreteKeyValue(committee.getCommitteeId(), committee.getCommitteeName()));
            }
            Collections.sort(keyValues, new KeyValueComparator());
        }
        keyValues.add(0, (KeyValue)new ConcreteKeyValue("", "select"));
        return keyValues;
    }

    private List<String> getExcludedCommitteeIds() {
        ArrayList<String> committeeIds = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)this.correspondenceTemplates)) {
            for (ProtocolCorrespondenceTemplateBase correspondenceTemplate : this.correspondenceTemplates) {
                committeeIds.add(correspondenceTemplate.getCommitteeId());
            }
        }
        return committeeIds;
    }

    public List<ProtocolCorrespondenceTemplateBase> getCorrespondenceTemplates() {
        return this.correspondenceTemplates;
    }

    public void setCorrespondenceTemplates(List<ProtocolCorrespondenceTemplateBase> correspondenceTemplates) {
        this.correspondenceTemplates = correspondenceTemplates;
    }
}

