/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.meeting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.meeting.CommonMeetingService;
import org.kuali.kra.common.committee.meeting.MeetingEventBase;
import org.kuali.kra.common.committee.meeting.MeetingFormBase;
import org.kuali.kra.common.committee.meeting.MeetingHelperBase;
import org.kuali.kra.common.committee.meeting.MeetingSaveEvent;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewableBase;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class MeetingActionBase
extends KualiAction {
    private static final String CLOSE_QUESTION = "Would you like to save meeting data before close it ?";
    private static final String CLOSE_QUESTION_ID = "meeting.close.question";
    private static final String LINE_NUMBER = "lineNum";
    private static final String REFRESH_CALLER = "refreshCaller";
    private static final String COMMITTEE_SCHEDULE_ERROR_PATH = "meetingHelper.committeeSchedule";

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("id", request.getParameter("scheduleId"));
        ArrayList<CommitteeScheduleMinuteBase> permittedMinutes = new ArrayList<CommitteeScheduleMinuteBase>();
        CommitteeScheduleBase commSchedule = (CommitteeScheduleBase)this.getBusinessObjectService().findByPrimaryKey(this.getCommitteeScheduleBOClass(), fieldValues);
        List minutes = commSchedule.getCommitteeScheduleMinutes();
        Collections.sort(minutes, CommitteeScheduleMinuteBase.entryTypeComparator);
        for (CommitteeScheduleMinuteBase minute : minutes) {
            if (!this.getReviewerCommentsService().getReviewerCommentsView((ProtocolReviewableBase)minute)) continue;
            permittedMinutes.add(minute);
        }
        commSchedule.setCommitteeScheduleMinutes(permittedMinutes);
        ((MeetingFormBase)form).setReadOnly("true".equals(request.getParameter("readOnly")));
        ((MeetingFormBase)form).getMeetingHelper().setCommitteeSchedule(commSchedule);
        if (!((MeetingFormBase)form).getMeetingHelper().hasViewModifySchedulePermission()) {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "start", this.getClass().getSimpleName());
        }
        this.getMeetingService().populateFormHelper(((MeetingFormBase)form).getMeetingHelper(), commSchedule, this.getScheduleLineNumber(request, commSchedule));
        return mapping.findForward("basic");
    }

    protected abstract Class<? extends CommitteeScheduleBase> getCommitteeScheduleBOClass();

    private int getScheduleLineNumber(HttpServletRequest request, CommitteeScheduleBase<?, ?, ?, ?> commSchedule) {
        int lineNumber = 0;
        if (StringUtils.isNotBlank((String)request.getParameter(LINE_NUMBER))) {
            lineNumber = Integer.parseInt(request.getParameter(LINE_NUMBER));
        } else {
            for (CommitteeScheduleBase schedule : commSchedule.getParentCommittee().getCommitteeSchedules()) {
                ++lineNumber;
                if (!schedule.getId().equals(commSchedule.getId())) continue;
                break;
            }
        }
        return lineNumber;
    }

    public ActionForward management(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("management");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeScheduleBase committeeSchedule = ((MeetingFormBase)form).getMeetingHelper().getCommitteeSchedule();
        if (this.isValidToSave(((MeetingFormBase)form).getMeetingHelper())) {
            ((MeetingFormBase)form).getMeetingHelper().populateAttendancePreSave();
            this.getMeetingService().saveMeetingDetails(committeeSchedule, ((MeetingFormBase)form).getMeetingHelper().getDeletedBos());
            ((MeetingFormBase)form).getMeetingHelper().initDeletedList();
        }
        return mapping.findForward("basic");
    }

    private boolean isValidToSave(MeetingHelperBase meetingHelper) {
        GlobalVariables.getMessageMap().addToErrorPath(COMMITTEE_SCHEDULE_ERROR_PATH);
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)meetingHelper.getCommitteeSchedule());
        GlobalVariables.getMessageMap().removeFromErrorPath(COMMITTEE_SCHEDULE_ERROR_PATH);
        boolean valid = GlobalVariables.getMessageMap().hasNoErrors();
        return valid &= this.applyRules((KualiDocumentEvent)new MeetingSaveEvent("", this.getCommitteeDocument(meetingHelper.getCommitteeSchedule().getParentCommittee().getCommitteeDocument().getDocumentHeader().getDocumentNumber()), meetingHelper, MeetingEventBase.ErrorType.HARDERROR));
    }

    protected CommitteeDocumentBase getCommitteeDocument(String documentNumber) {
        try {
            return (CommitteeDocumentBase)((DocumentService)KraServiceLocator.getService(DocumentService.class)).getByDocumentHeaderId(documentNumber);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ActionForward actions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("actions");
    }

    private ActionForward viewProtocolSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolSubmissionBase protocolSubmission = (ProtocolSubmissionBase)((MeetingFormBase)form).getMeetingHelper().getCommitteeSchedule().getLatestProtocolSubmissions().get(Integer.parseInt(request.getParameter("line")));
        response.sendRedirect(this.getActionIdHook() + ".do?methodToCall=start&submissionId=" + protocolSubmission.getSubmissionId());
        return null;
    }

    protected abstract String getActionIdHook();

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MeetingFormBase meetingForm = (MeetingFormBase)form;
        String question = request.getParameter("questionIndex");
        if (question == null && meetingForm.getMeetingHelper().canModifySchedule()) {
            return this.performQuestionWithoutInput(mapping, form, request, response, CLOSE_QUESTION_ID, CLOSE_QUESTION, "confirmationQuestion", ((MeetingFormBase)form).getMethodToCall(), "");
        }
        if (meetingForm.getMeetingHelper().canModifySchedule()) {
            String buttonClicked = request.getParameter("buttonClicked");
            if (CLOSE_QUESTION_ID.equals(question) && "0".equals(buttonClicked)) {
                CommitteeScheduleBase committeeSchedule = meetingForm.getMeetingHelper().getCommitteeSchedule();
                if (this.isValidToSave(((MeetingFormBase)form).getMeetingHelper())) {
                    ((MeetingFormBase)form).getMeetingHelper().populateAttendancePreSave();
                    this.getMeetingService().saveMeetingDetails(committeeSchedule, ((MeetingFormBase)form).getMeetingHelper().getDeletedBos());
                    ((MeetingFormBase)form).getMeetingHelper().initDeletedList();
                } else {
                    return mapping.findForward("basic");
                }
            }
        }
        return mapping.findForward("portal");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("portal");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (StringUtils.isNotBlank((String)request.getParameter(REFRESH_CALLER))) {
            if ("nonOrganizationalRolodexLookupable".equals(request.getParameter(REFRESH_CALLER))) {
                ((MeetingFormBase)form).getMeetingHelper().getNewOtherPresentBean().getAttendance().setNonEmployeeFlag(true);
            } else {
                ((MeetingFormBase)form).getMeetingHelper().getNewOtherPresentBean().getAttendance().setNonEmployeeFlag(false);
            }
        }
        return super.refresh(mapping, form, request, response);
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        ((MeetingFormBase)form).getMeetingHelper().sortAttendances();
        String command = request.getParameter("command");
        if (StringUtils.isNotBlank((String)command) && "viewProtocolSubmission".equals(command)) {
            forward = this.viewProtocolSubmission(mapping, form, request, response);
        }
        ((MeetingFormBase)form).getMeetingHelper().setHideReviewerName(this.getReviewerCommentsService().setHideReviewerName(((MeetingFormBase)form).getMeetingHelper().getCommitteeSchedule().getCommitteeScheduleMinutes()));
        Collections.sort(((MeetingFormBase)form).getMeetingHelper().getCommitteeSchedule().getCommitteeScheduleMinutes(), CommitteeScheduleMinuteBase.entryTypeComparator);
        return forward;
    }

    protected DictionaryValidationService getDictionaryValidationService() {
        return KNSServiceLocator.getKNSDictionaryValidationService();
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    protected boolean applyRules(KualiDocumentEvent event) {
        return ((KualiRuleService)KraServiceLocator.getService(KualiRuleService.class)).applyRules(event);
    }

    protected abstract CommonMeetingService getMeetingService();

    protected abstract ReviewCommentsService<?> getReviewerCommentsService();
}

