/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.meeting;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.meeting.CommScheduleMinuteDocBase;
import org.kuali.kra.common.committee.meeting.GeneratedMeetingDocBase;
import org.kuali.kra.common.committee.meeting.MeetingActionBase;
import org.kuali.kra.common.committee.meeting.MeetingActionsActionBase;
import org.kuali.kra.common.committee.meeting.MeetingFormBase;
import org.kuali.kra.common.committee.meeting.MeetingHelperBase;
import org.kuali.kra.common.committee.meeting.ScheduleAgendaBase;
import org.kuali.kra.common.committee.print.CommitteeReportType;
import org.kuali.kra.common.committee.print.service.CommitteePrintingServiceBase;
import org.kuali.kra.common.committee.rule.event.CommitteeActionPrintCommitteeDocumentEvent;
import org.kuali.kra.common.committee.service.CommonCommitteeNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.meeting.CommScheduleMinuteDoc;
import org.kuali.kra.meeting.ScheduleAgenda;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.printing.util.PrintingUtils;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class MeetingActionsActionBase
extends MeetingActionBase {
    public ActionForward generateAgenda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        List printableArtifactList = this.getPrintableArtifacts(meetingHelper, this.getProtocolCorrespondenceAgendaTypeCodeHook());
        if (((Printable)printableArtifactList.get(0)).getXSLTemplates().isEmpty()) {
            GlobalVariables.getMessageMap().putError("meetingHelper.scheduleAgenda", "error.protocol.correspondence.template.not.set", new String[0]);
        } else {
            AttachmentDataSource dataStream = this.getCommitteePrintingService().print(printableArtifactList);
            if (dataStream.getContent() != null && dataStream.getContent().length > 0) {
                this.setFileDataProperties(dataStream, meetingHelper.getCommitteeSchedule().getId(), "Agenda");
                ScheduleAgendaBase agenda = this.getNewScheduleAgendaInstanceHook();
                int agendaNumber = meetingHelper.getScheduleAgendas().size() + 1;
                agenda.setAgendaName("Agenda For Schedule #  " + meetingHelper.getCommitteeSchedule().getId() + " Version " + agendaNumber);
                agenda.setAgendaNumber(Integer.valueOf(agendaNumber));
                this.saveGeneratedDoc(meetingHelper.getCommitteeSchedule().getId(), (GeneratedMeetingDocBase)agenda, dataStream.getContent());
                meetingHelper.setAgendaGenerationDate(new Date(agenda.getCreateTimestamp().getTime()));
                meetingHelper.getScheduleAgendas().add(agenda);
            }
        }
        return actionForward;
    }

    protected abstract ScheduleAgendaBase getNewScheduleAgendaInstanceHook();

    protected abstract String getProtocolCorrespondenceAgendaTypeCodeHook();

    private List<Printable> getPrintableArtifacts(MeetingHelperBase meetingHelper, String protocolCorrespondenceTypeCode) {
        AbstractPrint printable = this.getCommitteePrintingService().getCommitteePrintable(CommitteeReportType.SCHEDULE_TEMPLATE);
        CommitteeBase committee = meetingHelper.getCommitteeSchedule().getParentCommittee();
        printable.setPrintableBusinessObject((KraPersistableBusinessObjectBase)committee);
        HashMap<String, String> reportParameters = new HashMap<String, String>();
        reportParameters.put("committeeId", committee.getCommitteeId());
        reportParameters.put("scheduleId", meetingHelper.getCommitteeSchedule().getScheduleId());
        reportParameters.put("protoCorrespTypeCode", protocolCorrespondenceTypeCode);
        printable.setReportParameters(reportParameters);
        ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
        printableArtifactList.add((Printable)printable);
        return printableArtifactList;
    }

    private void setFileDataProperties(AttachmentDataSource dataStream, Long scheduleId, String type) {
        String fileName = type + "-For-Schedule-" + scheduleId + ".pdf";
        try {
            dataStream.setFileName(URLEncoder.encode(fileName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            dataStream.setFileName(fileName);
        }
        dataStream.setContentType("application/pdf");
    }

    public ActionForward generateMinutes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        List printableArtifactList = this.getPrintableArtifacts(meetingHelper, this.getProtocolCorrespondenceMinutesTypeCodeHook());
        if (((Printable)printableArtifactList.get(0)).getXSLTemplates().isEmpty()) {
            GlobalVariables.getMessageMap().putError("meetingHelper.meetingMinute", "error.protocol.correspondence.template.not.set", new String[0]);
        } else {
            AttachmentDataSource dataStream = this.getCommitteePrintingService().print(printableArtifactList);
            if (dataStream.getContent() != null && dataStream.getContent().length > 0) {
                this.setFileDataProperties(dataStream, meetingHelper.getCommitteeSchedule().getId(), "Minute");
                CommScheduleMinuteDocBase minuteDoc = this.getNewCommScheduleMinuteDocInstanceHook();
                minuteDoc.setMinuteName("Minute For Schedule #  " + meetingHelper.getCommitteeSchedule().getId() + " Version " + (meetingHelper.getMinuteDocs().size() + 1));
                minuteDoc.setMinuteNumber(Integer.valueOf(meetingHelper.getMinuteDocs().size() + 1));
                this.saveGeneratedDoc(meetingHelper.getCommitteeSchedule().getId(), (GeneratedMeetingDocBase)minuteDoc, dataStream.getContent());
                meetingHelper.getMinuteDocs().add(minuteDoc);
            }
        }
        return actionForward;
    }

    protected abstract CommScheduleMinuteDocBase getNewCommScheduleMinuteDocInstanceHook();

    protected abstract String getProtocolCorrespondenceMinutesTypeCodeHook();

    private void saveGeneratedDoc(Long scheduleId, GeneratedMeetingDocBase generatedMeetingDoc, byte[] pdfData) {
        generatedMeetingDoc.setScheduleIdFk(scheduleId);
        generatedMeetingDoc.setCreateTimestamp(((DateTimeService)KraServiceLocator.getService((String)"dateTimeService")).getCurrentTimestamp());
        generatedMeetingDoc.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
        generatedMeetingDoc.setPdfStore(pdfData);
        this.getBusinessObjectService().save((PersistableBusinessObject)generatedMeetingDoc);
    }

    protected abstract CommitteePrintingServiceBase getCommitteePrintingService();

    public ActionForward viewAgenda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        PrintableAttachment source = new PrintableAttachment(this);
        String scheduleId = request.getParameter("scheduleId");
        if (scheduleId != null) {
            String selectedLine = request.getParameter("line");
            selection = Integer.parseInt(selectedLine);
            Long schedule_id = Long.parseLong(scheduleId);
            List scheduleAgendas = this.getAgendaDoc(schedule_id);
            source.setContent(((ScheduleAgenda)scheduleAgendas.get(selection)).getPdfStore());
        } else {
            source.setContent(((ScheduleAgendaBase)meetingHelper.getScheduleAgendas().get(selection)).getPdfStore());
        }
        source.setContentType("application/pdf");
        source.setFileName("ScheduleAgendaBase.pdf");
        if (source.getContent() != null) {
            PrintingUtils.streamToResponse((AttachmentDataSource)source, (HttpServletResponse)response);
            return null;
        }
        return mapping.findForward("basic");
    }

    private List<ScheduleAgenda> getAgendaDoc(Long scheduleId) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("scheduleIdFk", scheduleId);
        return (List)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findMatchingOrderBy(ScheduleAgenda.class, fieldValues, "createTimestamp", true);
    }

    public ActionForward sendAgendaNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        ScheduleAgendaBase agenda = (ScheduleAgendaBase)((MeetingFormBase)form).getMeetingHelper().getScheduleAgendas().get(selection);
        this.getCommitteeNotificationService().generateNotification("213", agenda);
        return mapping.findForward("basic");
    }

    public ActionForward viewMinute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        PrintableAttachment source = new PrintableAttachment(this);
        String scheduleId = request.getParameter("scheduleId");
        if (scheduleId != null) {
            String selectedLine = request.getParameter("line");
            selection = Integer.parseInt(selectedLine);
            Long schedule_Id = Long.parseLong(scheduleId);
            List commScheduleMinutes = this.getMinuteDoc(schedule_Id);
            source.setContent(((CommScheduleMinuteDoc)commScheduleMinutes.get(selection)).getPdfStore());
        } else {
            source.setContent(((CommScheduleMinuteDocBase)meetingHelper.getMinuteDocs().get(selection)).getPdfStore());
        }
        source.setContentType("application/pdf");
        source.setFileName("MeetingMinute.pdf");
        PrintingUtils.streamToResponse((AttachmentDataSource)source, (HttpServletResponse)response);
        return null;
    }

    private List<CommScheduleMinuteDoc> getMinuteDoc(Long scheduleId) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("scheduleIdFk", scheduleId);
        return (List)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findMatchingOrderBy(CommScheduleMinuteDoc.class, fieldValues, "createTimestamp", true);
    }

    public ActionForward sendMinutesNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        CommScheduleMinuteDocBase minuteDoc = (CommScheduleMinuteDocBase)meetingHelper.getMinuteDocs().get(selection);
        this.getCommitteeNotificationService().generateNotification("215", minuteDoc);
        return mapping.findForward("basic");
    }

    public ActionForward viewCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        PrintableAttachment source = new PrintableAttachment(this);
        source.setContent(((ProtocolCorrespondence)meetingHelper.getCorrespondences().get(selection)).getCorrespondence());
        source.setContentType("application/pdf");
        source.setFileName("Correspondence-" + ((ProtocolCorrespondence)meetingHelper.getCorrespondences().get(selection)).getProtocolCorrespondenceType().getDescription() + ".pdf");
        PrintingUtils.streamToResponse((AttachmentDataSource)source, (HttpServletResponse)response);
        return null;
    }

    public ActionForward printRosterFutureSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean printFutureScheduledMeeting;
        Boolean printRooster;
        ActionForward actionForward = mapping.findForward("basic");
        CommitteeDocumentBase document = (CommitteeDocumentBase)this.getDocumentService().getByDocumentHeaderId(((MeetingFormBase)form).getMeetingHelper().getCommitteeSchedule().getParentCommittee().getCommitteeDocument().getDocumentNumber());
        if (this.applyRules((KualiDocumentEvent)new CommitteeActionPrintCommitteeDocumentEvent("", (Document)document, printRooster = ((MeetingFormBase)form).getMeetingHelper().getPrintRooster(), printFutureScheduledMeeting = ((MeetingFormBase)form).getMeetingHelper().getPrintFutureScheduledMeeting(), true))) {
            AttachmentDataSource dataStream;
            AbstractPrint printable;
            ArrayList<AbstractPrint> printableArtifactList = new ArrayList<AbstractPrint>();
            if (printRooster.booleanValue()) {
                printable = this.getCommitteePrintingService().getCommitteePrintable(CommitteeReportType.ROSTER);
                printable.setPrintableBusinessObject((KraPersistableBusinessObjectBase)document.getCommittee());
                document.getCommittee().setPrintRooster(printRooster);
                printableArtifactList.add(printable);
                ((MeetingFormBase)form).getMeetingHelper().setPrintRooster(Boolean.valueOf(false));
            }
            if (printFutureScheduledMeeting.booleanValue()) {
                printable = this.getCommitteePrintingService().getCommitteePrintable(CommitteeReportType.FUTURE_SCHEDULED_MEETINGS);
                printable.setPrintableBusinessObject((KraPersistableBusinessObjectBase)document.getCommittee());
                printableArtifactList.add(printable);
                document.getCommittee().setPrintRooster(printFutureScheduledMeeting);
                ((MeetingFormBase)form).getMeetingHelper().setPrintFutureScheduledMeeting(Boolean.valueOf(false));
            }
            if ((dataStream = this.getCommitteePrintingService().print(printableArtifactList)).getContent() != null) {
                PrintingUtils.streamToResponse((AttachmentDataSource)dataStream, (HttpServletResponse)response);
                actionForward = null;
            }
        }
        return actionForward;
    }

    private CommonCommitteeNotificationService getCommitteeNotificationService() {
        return (CommonCommitteeNotificationService)KraServiceLocator.getService(CommonCommitteeNotificationService.class);
    }

    private DocumentService getDocumentService() {
        return (DocumentService)KraServiceLocator.getService(DocumentService.class);
    }

    public abstract ActionForward regenerateCorrespondence(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    public ActionForward viewGeneratedCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        PrintableAttachment source = new PrintableAttachment(this);
        ProtocolCorrespondence correspondence = (ProtocolCorrespondence)meetingHelper.getRegeneratedCorrespondences().get(selection);
        source.setContent(correspondence.getCorrespondence());
        source.setContentType("application/pdf");
        source.setFileName("Correspondence-" + correspondence.getProtocolCorrespondenceType().getDescription() + ".pdf");
        PrintingUtils.streamToResponse((AttachmentDataSource)source, (HttpServletResponse)response);
        return null;
    }

    public ActionForward saveCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.correspondenceAction(mapping, form, true);
    }

    public ActionForward closeCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.correspondenceAction(mapping, form, false);
    }

    private ActionForward correspondenceAction(ActionMapping mapping, ActionForm form, boolean saveAction) {
        MeetingFormBase meetingForm = (MeetingFormBase)form;
        MeetingHelperBase meetingHelper = meetingForm.getMeetingHelper();
        List correspondences = meetingHelper.getRegeneratedCorrespondences();
        if (saveAction) {
            for (ProtocolCorrespondence correspondence : correspondences) {
                if (!correspondence.getFinalFlag()) continue;
                correspondence.setFinalFlagTimestamp(((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).getCurrentTimestamp());
            }
            this.getBusinessObjectService().save(correspondences);
        }
        for (ProtocolCorrespondence protocolCorrespondence : meetingHelper.getCorrespondences()) {
            protocolCorrespondence.setRegenerateFlag(false);
        }
        return mapping.findForward("actions");
    }
}

