/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.meeting;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.meeting.CommScheduleActItemBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.meeting.MeetingAddMinuteEventBase;
import org.kuali.kra.common.committee.meeting.ProtocolContingencyBase;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class MeetingAddMinuteRuleBase
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<MeetingAddMinuteEventBase> {
    private static final String NEW_COMM_SCHD_MINUTE = "meetingHelper.newCommitteeScheduleMinute";
    private static final String DOT = ".";
    private static final String GENERATE_ATTENDANCE_FIELD = "generateAttendance";
    private static final String PROTOCOL_ID_FK_FIELD = "protocolIdFk";
    private static final String PROTOCOL_CONTINGENCY_CODE_FIELD = "protocolContingencyCode";
    private static final String COMM_SCHD_MINUTE_ACT_ITEMS_ID_FK_FIELD = "commScheduleActItemsIdFk";

    public boolean processRules(MeetingAddMinuteEventBase event) {
        boolean isValid = true;
        CommitteeScheduleMinuteBase minute = event.getMeetingHelper().getNewCommitteeScheduleMinute();
        isValid &= this.validateFields(minute);
        if ("2".equals(minute.getMinuteEntryTypeCode())) {
            List attendances = event.getMeetingHelper().getCommitteeSchedule().getCommitteeScheduleAttendances();
            isValid &= this.validateAttendance(minute, attendances);
        } else if ("3".equals(minute.getMinuteEntryTypeCode())) {
            isValid &= this.validateProtocol(minute);
        } else if ("4".equals(minute.getMinuteEntryTypeCode())) {
            List items = event.getMeetingHelper().getCommitteeSchedule().getCommScheduleActItems();
            isValid &= this.validateActionItem(minute, items);
        }
        return isValid;
    }

    private boolean validateFields(CommitteeScheduleMinuteBase committeeScheduleMinute) {
        boolean isValid = true;
        GlobalVariables.getMessageMap().addToErrorPath(NEW_COMM_SCHD_MINUTE);
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)committeeScheduleMinute);
        GlobalVariables.getMessageMap().removeFromErrorPath(NEW_COMM_SCHD_MINUTE);
        return isValid &= GlobalVariables.getMessageMap().hasNoErrors();
    }

    private boolean validateAttendance(CommitteeScheduleMinuteBase committeeScheduleMinute, List<CommitteeScheduleAttendanceBase> attendances) {
        boolean isValid = true;
        if (committeeScheduleMinute.isGenerateAttendance() && attendances.isEmpty()) {
            this.reportError("meetingHelper.newCommitteeScheduleMinute.generateAttendance", "error.empty.attendance", new String[0]);
            isValid = false;
        }
        return isValid;
    }

    private boolean validateProtocol(CommitteeScheduleMinuteBase committeeScheduleMinute) {
        boolean isValid = true;
        if (committeeScheduleMinute.getProtocolIdFk() == null) {
            this.reportError("meetingHelper.newCommitteeScheduleMinute.protocolIdFk", "error.empty.protocol", new String[0]);
            isValid = false;
        }
        if (StringUtils.isNotBlank((String)committeeScheduleMinute.getProtocolContingencyCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(PROTOCOL_CONTINGENCY_CODE_FIELD, committeeScheduleMinute.getProtocolContingencyCode());
            if (this.getBusinessObjectService().findByPrimaryKey(this.getProtocolContingencyBOClassHook(), fieldValues) == null) {
                this.reportError("meetingHelper.newCommitteeScheduleMinute.protocolContingencyCode", "error.empty.protocol.contingency", new String[0]);
                isValid = false;
            }
        }
        return isValid;
    }

    protected abstract Class<? extends ProtocolContingencyBase> getProtocolContingencyBOClassHook();

    private boolean validateActionItem(CommitteeScheduleMinuteBase committeeScheduleMinute, List<CommScheduleActItemBase> commScheduleActItems) {
        boolean isValid = true;
        if (commScheduleActItems.isEmpty()) {
            this.reportError("meetingHelper.newCommitteeScheduleMinute.commScheduleActItemsIdFk", "error.empty.action.items", new String[0]);
            isValid = false;
        }
        if (committeeScheduleMinute.getCommScheduleActItemsIdFk() == null) {
            this.reportError("meetingHelper.newCommitteeScheduleMinute.commScheduleActItemsIdFk", "error.empty.action.items.description", new String[0]);
            isValid = false;
        }
        return isValid;
    }
}

