/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.meeting;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.meeting.MeetingAddOtherEvent;
import org.kuali.kra.common.committee.meeting.MemberPresentBean;
import org.kuali.kra.common.committee.meeting.OtherPresentBeanBase;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class MeetingAddOtherRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<MeetingAddOtherEvent> {
    private static final String NEWOTHERPRESENT_PERSONNAME = "meetingHelper.newOtherPresentBean.attendance.personName";
    private ErrorReporter errorReporter;

    public boolean processRules(MeetingAddOtherEvent event) {
        boolean rulePassed = true;
        this.errorReporter = new ErrorReporter();
        if (StringUtils.isBlank((String)event.getMeetingHelper().getNewOtherPresentBean().getAttendance().getPersonName())) {
            this.errorReporter.reportError(NEWOTHERPRESENT_PERSONNAME, "error.empty.person", new String[0]);
            rulePassed = false;
        } else {
            for (MemberPresentBean memberPresentBean : event.getMeetingHelper().getMemberPresentBeans()) {
                if (!this.isMemberPresent(memberPresentBean, event.getMeetingHelper().getNewOtherPresentBean())) continue;
                this.errorReporter.reportError(NEWOTHERPRESENT_PERSONNAME, "error.add.member.present", new String[]{event.getMeetingHelper().getNewOtherPresentBean().getAttendance().getPersonName()});
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    private boolean isMemberPresent(MemberPresentBean memberPresentBean, OtherPresentBeanBase otherPresentBean) {
        boolean isPresent = false;
        if (memberPresentBean.getAttendance().getNonEmployeeFlag() && otherPresentBean.getAttendance().getNonEmployeeFlag() && memberPresentBean.getAttendance().getPersonId().equals(otherPresentBean.getAttendance().getPersonId())) {
            isPresent = true;
        } else if (!memberPresentBean.getAttendance().getNonEmployeeFlag() && !otherPresentBean.getAttendance().getNonEmployeeFlag() && memberPresentBean.getAttendance().getPersonId().equals(otherPresentBean.getAttendance().getPersonId())) {
            isPresent = true;
        } else if (StringUtils.isNotBlank((String)memberPresentBean.getAttendance().getAlternateFor()) && StringUtils.isNotBlank((String)otherPresentBean.getAttendance().getPersonId()) && memberPresentBean.getAttendance().getAlternateFor().equals(otherPresentBean.getAttendance().getPersonId())) {
            isPresent = true;
        }
        return isPresent;
    }
}

