/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.meeting;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.document.authorization.CommitteeScheduleTaskBase;
import org.kuali.kra.common.committee.document.authorization.CommitteeTaskBase;
import org.kuali.kra.common.committee.meeting.CommScheduleActItemBase;
import org.kuali.kra.common.committee.meeting.CommScheduleMinuteDocBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttachmentsBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.meeting.MeetingFormBase;
import org.kuali.kra.common.committee.meeting.MemberAbsentBean;
import org.kuali.kra.common.committee.meeting.MemberPresentBean;
import org.kuali.kra.common.committee.meeting.OtherPresentBeanBase;
import org.kuali.kra.common.committee.meeting.ProtocolSubmittedBean;
import org.kuali.kra.common.committee.meeting.ScheduleAgendaBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class MeetingHelperBase
implements Serializable {
    private static final long serialVersionUID = 2363534404324211441L;
    private static final String FIELD_SEPARAATOR = "#f#";
    private static final String NAMESPACE = "KC-UNT";
    private MeetingFormBase form;
    private Date agendaGenerationDate;
    private CommitteeScheduleBase<?, ?, ?, ?> committeeSchedule;
    private List<CommitteeScheduleBase<?, ?, ?, ?>> committeeScheduleList;
    private List<ProtocolSubmittedBean> protocolSubmittedBeans;
    private CommScheduleActItemBase newOtherAction;
    private List<CommScheduleActItemBase> deletedOtherActions;
    private List<CommitteeScheduleAttendanceBase> deletedAttendances;
    private String tabLabel;
    private List<MemberPresentBean> memberPresentBeans;
    private List<MemberAbsentBean> memberAbsentBeans;
    private List<OtherPresentBeanBase> otherPresentBeans;
    private OtherPresentBeanBase newOtherPresentBean;
    private String absenteeList;
    private CommitteeScheduleMinuteBase<?, ?> newCommitteeScheduleMinute;
    private List<CommitteeScheduleMinuteBase<?, ?>> deletedCommitteeScheduleMinutes;
    private boolean jsDisabled = false;
    private boolean modifySchedule = false;
    private boolean viewSchedule = false;
    private List<ScheduleAgendaBase> scheduleAgendas;
    private List<CommScheduleMinuteDocBase> minuteDocs;
    private List<ProtocolCorrespondence> correspondences;
    private String reportType;
    private String viewId;
    private Boolean printRooster;
    private Boolean printFutureScheduledMeeting;
    private boolean hideReviewerName;
    private static String minutesSentMessage;
    private static String agendaSentMessage;
    private ProtocolCorrespondence protocolCorrespondence;
    private List<ProtocolCorrespondence> regeneratedCorrespondences;
    private CommitteeScheduleAttachmentsBase newCommitteeScheduleAttachments;
    private static final String AGENDA_SENT_MESSAGE = "message.disclosure.submit.thankyou";
    private static final String MINUTES_SENT_MESSAGE = "message.disclosure.submit.thankyou";
    private static final String MESSAGE_COMMITTEESCHEDULE_AGENDASENT = "message.committeeSchedule.agendaSent";
    private static final String MESSAGE_COMMITTEESCHEDULE_MINUTESSENT = "message.committeeSchedule.minutesSent";
    private transient KraAuthorizationService kraAuthorizationService;

    public MeetingHelperBase(MeetingFormBase form) {
        this.form = form;
        this.committeeSchedule = this.getNewCommitteeScheduleInstanceHook();
        this.protocolSubmittedBeans = new ArrayList();
        this.memberPresentBeans = new ArrayList();
        this.memberAbsentBeans = new ArrayList();
        this.otherPresentBeans = new ArrayList();
        this.newOtherAction = this.getNewCommScheduleActItemInstanceHook();
        this.newCommitteeScheduleMinute = this.getNewCommitteeScheduleMinuteInstanceHook();
        this.newCommitteeScheduleAttachments = this.getNewCommitteeScheduleAttachmentsInstanceHook();
        this.newOtherPresentBean = this.getNewOtherPresentBeanInstanceHook();
        this.scheduleAgendas = new ArrayList();
        this.minuteDocs = new ArrayList();
        this.correspondences = new ArrayList();
        this.printRooster = new Boolean(false);
        this.printFutureScheduledMeeting = new Boolean(false);
        this.initDeletedList();
    }

    protected abstract CommitteeScheduleAttachmentsBase getNewCommitteeScheduleAttachmentsInstanceHook();

    protected abstract OtherPresentBeanBase getNewOtherPresentBeanInstanceHook();

    protected abstract CommScheduleActItemBase getNewCommScheduleActItemInstanceHook();

    protected abstract CommitteeScheduleMinuteBase<?, ?> getNewCommitteeScheduleMinuteInstanceHook();

    protected abstract CommitteeScheduleBase<?, ?, ?, ?> getNewCommitteeScheduleInstanceHook();

    public MeetingFormBase getForm() {
        return this.form;
    }

    public void setForm(MeetingFormBase form) {
        this.form = form;
    }

    public CommScheduleActItemBase getNewOtherAction() {
        return this.newOtherAction;
    }

    public void setNewOtherAction(CommScheduleActItemBase newOtherAction) {
        this.newOtherAction = newOtherAction;
    }

    public String getTabLabel() {
        return this.tabLabel;
    }

    public void setTabLabel(String tabLabel) {
        this.tabLabel = tabLabel;
    }

    public CommitteeScheduleBase<?, ?, ?, ?> getCommitteeSchedule() {
        return this.committeeSchedule;
    }

    public void setCommitteeSchedule(CommitteeScheduleBase<?, ?, ?, ?> committeeSchedule) {
        this.committeeSchedule = committeeSchedule;
    }

    public Date getAgendaGenerationDate() {
        return this.agendaGenerationDate;
    }

    public void setAgendaGenerationDate(Date agendaGenerationDate) {
        this.agendaGenerationDate = agendaGenerationDate;
    }

    public List<CommScheduleActItemBase> getDeletedOtherActions() {
        return this.deletedOtherActions;
    }

    public void setDeletedOtherActions(List<CommScheduleActItemBase> deletedOtherActions) {
        this.deletedOtherActions = deletedOtherActions;
    }

    public List<ProtocolSubmittedBean> getProtocolSubmittedBeans() {
        return this.protocolSubmittedBeans;
    }

    public void setProtocolSubmittedBeans(List<ProtocolSubmittedBean> protocolSubmittedBeans) {
        this.protocolSubmittedBeans = protocolSubmittedBeans;
    }

    public List<MemberPresentBean> getMemberPresentBeans() {
        return this.memberPresentBeans;
    }

    public void setMemberPresentBeans(List<MemberPresentBean> memberPresentBeans) {
        this.memberPresentBeans = memberPresentBeans;
    }

    public List<MemberAbsentBean> getMemberAbsentBeans() {
        return this.memberAbsentBeans;
    }

    public void setMemberAbsentBeans(List<MemberAbsentBean> memberAbsentBeans) {
        this.memberAbsentBeans = memberAbsentBeans;
    }

    public List<OtherPresentBeanBase> getOtherPresentBeans() {
        return this.otherPresentBeans;
    }

    public void setOtherPresentBeans(List<OtherPresentBeanBase> otherPresentBeans) {
        this.otherPresentBeans = otherPresentBeans;
    }

    public OtherPresentBeanBase getNewOtherPresentBean() {
        return this.newOtherPresentBean;
    }

    public void setNewOtherPresentBean(OtherPresentBeanBase newOtherPresentBean) {
        this.newOtherPresentBean = newOtherPresentBean;
    }

    public String getAbsenteeList() {
        if (StringUtils.isBlank((String)this.absenteeList) && !this.memberAbsentBeans.isEmpty()) {
            this.absenteeList = this.initAbsenteeList();
        }
        return this.absenteeList;
    }

    public void setAbsenteeList(String absenteeList) {
        this.absenteeList = absenteeList;
    }

    private String initAbsenteeList() {
        String result = "";
        for (MemberAbsentBean memberAbsentBean : this.memberAbsentBeans) {
            if (StringUtils.isBlank((String)result)) {
                result = memberAbsentBean.getAttendance().getPersonId() + FIELD_SEPARAATOR + memberAbsentBean.getAttendance().getPersonName();
                continue;
            }
            result = result + "#m#" + memberAbsentBean.getAttendance().getPersonId() + FIELD_SEPARAATOR + memberAbsentBean.getAttendance().getPersonName();
        }
        return result;
    }

    public List<CommitteeScheduleAttendanceBase> getDeletedAttendances() {
        return this.deletedAttendances;
    }

    public void setDeletedAttendances(List<CommitteeScheduleAttendanceBase> deletedAttendances) {
        this.deletedAttendances = deletedAttendances;
    }

    public CommitteeScheduleMinuteBase getNewCommitteeScheduleMinute() {
        return this.newCommitteeScheduleMinute;
    }

    public void setNewCommitteeScheduleMinute(CommitteeScheduleMinuteBase<?, ?> newCommitteeScheduleMinute) {
        this.newCommitteeScheduleMinute = newCommitteeScheduleMinute;
    }

    public List<CommitteeScheduleMinuteBase<?, ?>> getDeletedCommitteeScheduleMinutes() {
        return this.deletedCommitteeScheduleMinutes;
    }

    public CommitteeScheduleAttachmentsBase getNewCommitteeScheduleAttachments() {
        return this.newCommitteeScheduleAttachments;
    }

    public void setNewCommitteeScheduleAttachments(CommitteeScheduleAttachmentsBase newCommitteeScheduleAttachments) {
        this.newCommitteeScheduleAttachments = newCommitteeScheduleAttachments;
    }

    public void setDeletedCommitteeScheduleMinutes(List<CommitteeScheduleMinuteBase<?, ?>> deletedCommitteeScheduleMinutes) {
        this.deletedCommitteeScheduleMinutes = deletedCommitteeScheduleMinutes;
    }

    protected void initDeletedList() {
        this.setDeletedOtherActions(new ArrayList());
        this.setDeletedCommitteeScheduleMinutes(new ArrayList());
        this.setDeletedAttendances(new ArrayList());
    }

    protected List<PersistableBusinessObject> getDeletedBos() {
        ArrayList<PersistableBusinessObject> deletedBos = new ArrayList<PersistableBusinessObject>();
        deletedBos.addAll(this.form.getMeetingHelper().getDeletedOtherActions());
        deletedBos.addAll(this.form.getMeetingHelper().getDeletedAttendances());
        deletedBos.addAll(this.form.getMeetingHelper().getDeletedCommitteeScheduleMinutes());
        return deletedBos;
    }

    protected void populateAttendancePreSave() {
        ArrayList<CommitteeScheduleAttendanceBase> attendances = new ArrayList<CommitteeScheduleAttendanceBase>();
        for (MemberPresentBean memberPresentBean : this.getMemberPresentBeans()) {
            memberPresentBean.getAttendance().setGuestFlag(false);
            attendances.add(memberPresentBean.getAttendance());
        }
        for (OtherPresentBeanBase otherPresentBean : this.getOtherPresentBeans()) {
            otherPresentBean.getAttendance().setGuestFlag(true);
            attendances.add(otherPresentBean.getAttendance());
        }
        this.setDeletedAttendances(this.committeeSchedule.getCommitteeScheduleAttendances());
        this.committeeSchedule.setCommitteeScheduleAttendances(attendances);
    }

    protected void sortAttendances() {
        if (!this.getMemberPresentBeans().isEmpty()) {
            Collections.sort(this.getMemberPresentBeans());
        }
        if (!this.getMemberAbsentBeans().isEmpty()) {
            Collections.sort(this.getMemberAbsentBeans());
        }
        if (!this.getOtherPresentBeans().isEmpty()) {
            Collections.sort(this.getOtherPresentBeans());
        }
    }

    public boolean isJsDisabled() {
        return this.jsDisabled;
    }

    public void setJsDisabled(boolean jsDisabled) {
        this.jsDisabled = jsDisabled;
    }

    public boolean hasViewModifySchedulePermission() {
        return this.canModifySchedule() || this.canViewSchedule() && this.form.isReadOnly();
    }

    public boolean canModifySchedule() {
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("modifySchedule", this.committeeSchedule.getParentCommittee());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    protected abstract CommitteeTaskBase getNewCommitteeTaskInstanceHook(String var1, CommitteeBase var2);

    public boolean getCanModifySchedule() {
        return this.canModifySchedule();
    }

    public boolean canViewSchedule() {
        CommitteeScheduleTaskBase task = this.getNewCommitteeScheduleTaskInstanceHook("viewSchedule", this.committeeSchedule.getParentCommittee(), this.committeeSchedule);
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    protected abstract CommitteeScheduleTaskBase getNewCommitteeScheduleTaskInstanceHook(String var1, CommitteeBase var2, CommitteeScheduleBase var3);

    public boolean getCanViewSchedule() {
        return this.canViewSchedule();
    }

    public boolean isModifySchedule() {
        return this.modifySchedule;
    }

    public void setModifySchedule(boolean modifySchedule) {
        this.modifySchedule = modifySchedule;
    }

    public boolean isViewSchedule() {
        return this.viewSchedule;
    }

    public void setViewSchedule(boolean viewSchedule) {
        this.viewSchedule = viewSchedule;
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public List<ScheduleAgendaBase> getScheduleAgendas() {
        return this.scheduleAgendas;
    }

    public void setScheduleAgendas(List<ScheduleAgendaBase> scheduleAgendas) {
        this.scheduleAgendas = scheduleAgendas;
    }

    public List<CommScheduleMinuteDocBase> getMinuteDocs() {
        return this.minuteDocs;
    }

    public void setMinuteDocs(List<CommScheduleMinuteDocBase> minuteDocs) {
        this.minuteDocs = minuteDocs;
    }

    public List<ProtocolCorrespondence> getCorrespondences() {
        return this.correspondences;
    }

    public void setCorrespondences(List<ProtocolCorrespondence> correspondences) {
        this.correspondences = correspondences;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public Boolean getPrintRooster() {
        return this.printRooster;
    }

    public void setPrintRooster(Boolean printRooster) {
        this.printRooster = printRooster;
    }

    public Boolean getPrintFutureScheduledMeeting() {
        return this.printFutureScheduledMeeting;
    }

    public void setPrintFutureScheduledMeeting(Boolean printFutureScheduledMeeting) {
        this.printFutureScheduledMeeting = printFutureScheduledMeeting;
    }

    public boolean isHideReviewerName() {
        return this.hideReviewerName;
    }

    public void setHideReviewerName(boolean hideReviewerName) {
        this.hideReviewerName = hideReviewerName;
    }

    public String getMinutesSentMessage() {
        if (minutesSentMessage == null) {
            minutesSentMessage = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(MESSAGE_COMMITTEESCHEDULE_MINUTESSENT);
        }
        return minutesSentMessage;
    }

    public String getAgendaSentMessage() {
        if (agendaSentMessage == null) {
            agendaSentMessage = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(MESSAGE_COMMITTEESCHEDULE_AGENDASENT);
        }
        return agendaSentMessage;
    }

    public ProtocolCorrespondence getProtocolCorrespondence() {
        return this.protocolCorrespondence;
    }

    public void setProtocolCorrespondence(ProtocolCorrespondence protocolCorrespondence) {
        this.protocolCorrespondence = protocolCorrespondence;
    }

    public List<ProtocolCorrespondence> getRegeneratedCorrespondences() {
        return this.regeneratedCorrespondences;
    }

    public void setRegeneratedCorrespondences(List<ProtocolCorrespondence> regeneratedCorrespondences) {
        this.regeneratedCorrespondences = regeneratedCorrespondences;
    }

    public boolean isIrbAdmin() {
        return this.getKraAuthorizationService().hasRole(GlobalVariables.getUserSession().getPrincipalId(), NAMESPACE, "IRB Administrator");
    }

    protected KraAuthorizationService getKraAuthorizationService() {
        if (this.kraAuthorizationService == null) {
            this.kraAuthorizationService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        }
        return this.kraAuthorizationService;
    }
}

