/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.meeting;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.meeting.MeetingPresentOtherOrVotingEvent;
import org.kuali.kra.common.committee.meeting.MemberAbsentBean;
import org.kuali.kra.common.committee.meeting.MemberPresentBean;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class MeetingPresentOtherOrVotingRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<MeetingPresentOtherOrVotingEvent> {
    private ErrorReporter errorReporter;

    public boolean processRules(MeetingPresentOtherOrVotingEvent event) {
        boolean rulePassed = true;
        this.errorReporter = new ErrorReporter();
        for (MemberPresentBean memberPresentBean : event.getMeetingHelper().getMemberPresentBeans()) {
            if (!this.isAlternateFor(memberPresentBean, event.getMemberAbsentBean())) continue;
            this.errorReporter.reportError("meetingHelper.memberAbsentBean.attendance.personId", "error.presnt.member.absent", new String[]{event.getMemberAbsentBean().getAttendance().getPersonName()});
            rulePassed = false;
        }
        return rulePassed;
    }

    private boolean isAlternateFor(MemberPresentBean memberPresentBean, MemberAbsentBean memberAbsentBean) {
        boolean isPresent = false;
        if (StringUtils.isNotBlank((String)memberPresentBean.getAttendance().getAlternateFor()) && StringUtils.isNotBlank((String)memberAbsentBean.getAttendance().getPersonId()) && memberPresentBean.getAttendance().getAlternateFor().equals(memberAbsentBean.getAttendance().getPersonId())) {
            isPresent = true;
        }
        return isPresent;
    }
}

