/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.notification;

import java.util.List;
import java.util.Map;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.notification.CommonCommitteeNotificationRoleQualifierService;
import org.kuali.kra.common.notification.NotificationContextBase;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.exception.UnknownRoleException;
import org.kuali.kra.common.notification.service.KcNotificationModuleRoleService;
import org.kuali.kra.common.notification.service.KcNotificationRoleQualifierService;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.util.EmailAttachment;
import org.springframework.util.CollectionUtils;

public class CommitteeNotificationContext
extends NotificationContextBase {
    private static final long serialVersionUID = 6642334312368480034L;
    private CommitteeBase committee;
    private CommitteeScheduleBase committeeSchedule;
    private String actionTypeCode;
    private String contextName;

    public CommitteeNotificationContext(CommitteeScheduleBase committeeSchedule, String actionTypeCode, String contextName, NotificationRenderer renderer) {
        super(renderer);
        this.committee = committeeSchedule.getParentCommittee();
        this.committeeSchedule = committeeSchedule;
        this.actionTypeCode = actionTypeCode;
        this.contextName = contextName;
        this.setNotificationService((KcNotificationService)KraServiceLocator.getService(KcNotificationService.class));
        this.setNotificationModuleRoleService((KcNotificationModuleRoleService)KraServiceLocator.getService(KcNotificationModuleRoleService.class));
        CommonCommitteeNotificationRoleQualifierService committeeNotificationRoleQualifierService = this.getCommitteeNotificationRoleQualifierService();
        this.setNotificationRoleQualifierService((KcNotificationRoleQualifierService)committeeNotificationRoleQualifierService);
        committeeNotificationRoleQualifierService.setCommitteeSchedule(this.committeeSchedule);
        committeeNotificationRoleQualifierService.setCommittee(this.committee);
    }

    public String getModuleCode() {
        return "11";
    }

    public String getDocumentNumber() {
        return this.committee.getCommitteeDocument().getDocumentNumber();
    }

    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void populateRoleQualifiers(NotificationTypeRecipient notificationRecipient) throws UnknownRoleException {
        if (CollectionUtils.isEmpty((Map)notificationRecipient.getRoleQualifiers())) {
            super.populateRoleQualifiers(notificationRecipient);
        }
    }

    public List<EmailAttachment> getEmailAttachments() {
        return null;
    }

    public CommonCommitteeNotificationRoleQualifierService getCommitteeNotificationRoleQualifierService() {
        return (CommonCommitteeNotificationRoleQualifierService)KraServiceLocator.getService(CommonCommitteeNotificationRoleQualifierService.class);
    }
}

