/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.rules;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipExpertiseBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.bo.CommitteeResearchAreaBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.lookup.keyvalue.CommitteeIdValuesFinderBase;
import org.kuali.kra.common.committee.rule.AddCommitteeMembershipRoleRule;
import org.kuali.kra.common.committee.rule.AddCommitteeMembershipRule;
import org.kuali.kra.common.committee.rule.event.AddCommitteeMembershipEvent;
import org.kuali.kra.common.committee.rule.event.AddCommitteeMembershipRoleEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleDateConflictEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleDeadlineEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleEventBase;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleTimeEvent;
import org.kuali.kra.common.committee.rules.CommitteeMembershipRule;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rule.event.KraDocumentEventBaseExtension;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CommitteeDocumentRuleBase
extends ResearchDocumentRuleBase
implements BusinessRuleInterface,
AddCommitteeMembershipRule,
AddCommitteeMembershipRoleRule {
    private static final String PROPERTY_NAME_TERM_START_DATE = "document.committeeList[0].committeeMemberships[%1$s].termStartDate";
    private static final String PROPERTY_NAME_TERM_END_DATE = "document.committeeList[0].committeeMemberships[%1$s].termEndDate";
    private static final String PROPERTY_NAME_ROLE_CODE_ADD = "committeeHelper.newCommitteeMembershipRoles[%1$s].membershipRoleCode";
    private static final String PROPERTY_NAME_ROLE_CODE = "document.committeeList[0].committeeMemberships[%1$s].membershipRoles[%2$s].membershipRoleCode";
    private static final String PROPERTY_NAME_ROLE_START_DATE = "document.committeeList[0].committeeMemberships[%1$s].membershipRoles[%2$s].startDate";
    private static final String PROPERTY_NAME_ROLE_END_DATE = "document.committeeList[0].committeeMemberships[%1$s].membershipRoles[%2$s].endDate";
    private static final String PROPERTY_NAME_RESEARCH_AREA_CODE = "committeeHelper.newCommitteeMembershipExpertise[%1$s].researchAreaCode";
    private static final Log LOG = LogFactory.getLog(CommitteeDocumentRuleBase.class);
    private static final String SEPERATOR = ".";
    private static final String PROPERTY_NAME_INACTIVE_AREAS_OF_EXPERTISE_PREFIX = "document.committeeList[0].committeeMemberships[%1$s].areasOfExpertise.inactive";
    private static final String COMMITTEE_ID_FIELD = "document.committeeList[0].committeeId";
    private static final String COMMITTEE_NAME_FIELD = "document.committeeList[0].committeeName";
    private static final String COMMITTEE_HOME_UNIT_NUMBER_FIELD = "document.committeeList[0].homeUnitNumber";
    private static final String REVIEW_TYPE_ERROR_PROPERTY_NAME = "document.committeeList[0].reviewTypeCode";
    private static final String INACTIVE_RESEARCH_AREAS_PREFIX = "document.committeeList[0].committeeResearchAreas.inactive";
    private static final boolean VALIDATION_REQUIRED = true;
    private static final boolean CHOMP_LAST_LETTER_S_FROM_COLLECTION_NAME = false;

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        boolean retval = true;
        return retval &= super.processCustomRouteDocumentBusinessRules(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(Document document) {
        boolean valid = true;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        this.getKnsDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively(document, this.getMaxDictionaryValidationDepth(), true, false);
        valid &= GlobalVariables.getMessageMap().hasNoErrors();
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        valid &= this.validateCommitteeId((CommitteeDocumentBase)document);
        valid &= this.validateUniqueCommitteeId((CommitteeDocumentBase)document);
        valid &= this.validateUniqueCommitteeName((CommitteeDocumentBase)document);
        valid &= this.validateHomeUnit((CommitteeDocumentBase)document);
        valid &= this.validateCommitteeTypeSpecificData((CommitteeDocumentBase)document);
        valid &= this.validateCommitteeMemberships((CommitteeDocumentBase)document);
        return valid &= this.processScheduleRules((CommitteeDocumentBase)document);
    }

    private boolean validateCommitteeTypeSpecificData(CommitteeDocumentBase document) {
        boolean valid = true;
        valid &= this.validateCommitteeResearchAreas(document.getCommittee());
        return valid &= this.validateReviewType(document.getCommittee());
    }

    private boolean validateCommitteeId(CommitteeDocumentBase document) {
        CommitteeBase committee = document.getCommittee();
        if (StringUtils.equalsIgnoreCase((String)committee.getCommitteeId(), (String)"DEFAULT")) {
            this.reportError(COMMITTEE_ID_FIELD, "error.committee.invalidId", new String[0]);
            return false;
        }
        return true;
    }

    private boolean validateUniqueCommitteeId(CommitteeDocumentBase document) {
        CommitteeBase committee = document.getCommittee();
        boolean valid = true;
        if (committee.getSequenceNumber() == 1 && (document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved())) {
            if (this.getCommitteeIds(document.getDocumentNumber()).contains(committee.getCommitteeId())) {
                valid = false;
            } else {
                try {
                    for (CommitteeDocumentBase workflowCommitteeDocument : this.getCommitteesDocumentsFromWorkflow(document.getDocumentNumber())) {
                        CommitteeBase workflowCommittee = workflowCommitteeDocument.getCommittee();
                        LOG.info((Object)("get doc content for doc " + workflowCommitteeDocument.getDocumentNumber()));
                        if (!StringUtils.equals((String)workflowCommittee.getCommitteeId(), (String)committee.getCommitteeId()) || workflowCommittee.getSequenceNumber() < committee.getSequenceNumber()) continue;
                        valid = false;
                    }
                }
                catch (WorkflowException e) {
                    LOG.info((Object)e.getMessage());
                }
            }
        }
        if (!valid) {
            this.reportError(COMMITTEE_ID_FIELD, "error.committee.duplicateId", new String[0]);
        }
        return valid;
    }

    private List<CommitteeDocumentBase> getCommitteesDocumentsFromWorkflow(String docNumber) throws WorkflowException {
        List documents = (List)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findAll(this.getCommitteeDocumentBOClassHook());
        ArrayList<CommitteeDocumentBase> result = new ArrayList<CommitteeDocumentBase>();
        for (CommitteeDocumentBase commDoc : documents) {
            if (commDoc.getCommitteeList() != null && commDoc.getCommitteeList().size() != 0 || !StringUtils.isBlank((String)commDoc.getCommitteeId()) || StringUtils.equals((String)commDoc.getDocumentNumber(), (String)docNumber)) continue;
            CommitteeDocumentBase workflowCommitteeDoc = (CommitteeDocumentBase)((DocumentService)KraServiceLocator.getService(DocumentService.class)).getByDocumentHeaderId(commDoc.getDocumentNumber());
            String content = ((RouteHeaderService)KraServiceLocator.getService(RouteHeaderService.class)).getContent(workflowCommitteeDoc.getDocumentHeader().getWorkflowDocument().getDocumentId()).getDocumentContent();
            workflowCommitteeDoc.getCommitteeList().add(this.populateCommitteeFromXmlDocumentContents(content));
            if (workflowCommitteeDoc.getDocumentHeader().getWorkflowDocument().isCanceled()) continue;
            result.add(workflowCommitteeDoc);
        }
        return result;
    }

    protected abstract Class<? extends CommitteeDocumentBase> getCommitteeDocumentBOClassHook();

    private List<String> getCommitteeIds(String docNumber) {
        ArrayList<String> result = new ArrayList<String>();
        List committeeDocss = (List)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findAll(this.getCommitteeDocumentBOClassHook());
        for (CommitteeDocumentBase committeeDoc : committeeDocss) {
            if (!StringUtils.isNotBlank((String)committeeDoc.getCommitteeId()) || result.contains(committeeDoc.getCommitteeId()) || !StringUtils.isNotBlank((String)committeeDoc.getDocStatusCode()) || committeeDoc.getDocStatusCode().equals("X") || StringUtils.equals((String)committeeDoc.getDocumentNumber(), (String)docNumber)) continue;
            result.add(committeeDoc.getCommitteeId());
        }
        return result;
    }

    private CommitteeBase populateCommitteeFromXmlDocumentContents(String xmlDocumentContents) {
        CommitteeBase committee = null;
        if (!StringUtils.isEmpty((String)xmlDocumentContents)) {
            committee = (CommitteeBase)this.getBusinessObjectFromXML(xmlDocumentContents, this.getCommitteeBOClassHook().getName());
        }
        return committee;
    }

    protected abstract Class<? extends CommitteeBase> getCommitteeBOClassHook();

    private PersistableBusinessObject getBusinessObjectFromXML(String xmlDocumentContents, String objectTagName) {
        String objXml = StringUtils.substringBetween((String)xmlDocumentContents, (String)("<" + objectTagName + ">"), (String)("</" + objectTagName + ">"));
        objXml = "<" + objectTagName + ">" + objXml + "</" + objectTagName + ">";
        PersistableBusinessObject businessObject = (PersistableBusinessObject)KRADServiceLocator.getXmlObjectSerializerService().fromXml(objXml);
        return businessObject;
    }

    private boolean validateUniqueCommitteeName(CommitteeDocumentBase document) {
        CommitteeBase committee = document.getCommittee();
        CommitteeIdValuesFinderBase committeeIdValuesFinder = this.getNewCommitteeIdValuesFinderInstanceHook();
        List committeeIdNamePairList = committeeIdValuesFinder.getKeyValues();
        for (KeyValue committeeIdNamePair : committeeIdNamePairList) {
            if (!StringUtils.equalsIgnoreCase((String)committeeIdNamePair.getValue(), (String)committee.getCommitteeName()) || !StringUtils.isNotBlank((String)committeeIdNamePair.getKey()) || StringUtils.equalsIgnoreCase((String)committeeIdNamePair.getKey(), (String)committee.getCommitteeId())) continue;
            this.reportError(COMMITTEE_NAME_FIELD, "error.committee.duplicateName", new String[0]);
            return false;
        }
        return true;
    }

    protected abstract CommitteeIdValuesFinderBase getNewCommitteeIdValuesFinderInstanceHook();

    private boolean validateHomeUnit(CommitteeDocumentBase document) {
        UnitService unitService;
        Unit homeUnit;
        boolean valid = true;
        String homeUnitNumber = document.getCommittee().getHomeUnitNumber();
        if (!StringUtils.isBlank((String)homeUnitNumber) && (homeUnit = (unitService = (UnitService)KraServiceLocator.getService(UnitService.class)).getUnit(homeUnitNumber)) == null) {
            valid = false;
            this.reportError(COMMITTEE_HOME_UNIT_NUMBER_FIELD, "error.invalid.unit", new String[]{homeUnitNumber});
        }
        return valid;
    }

    private boolean validateCommitteeMemberships(CommitteeDocumentBase committeeDocument) {
        boolean isValid = true;
        List committeeMemberships = committeeDocument.getCommittee().getCommitteeMemberships();
        for (CommitteeMembershipBase committeeMembership : committeeMemberships) {
            int membershipIndex = committeeMemberships.indexOf(committeeMembership);
            isValid &= this.isValidTermStartEndDates(committeeMembership, membershipIndex);
            isValid &= this.isValidRoles(committeeMembership, membershipIndex);
            if (isValid &= this.hasExpertise(committeeMembership, membershipIndex)) {
                isValid &= this.hasNoTermOverlap(committeeMemberships, committeeMembership, membershipIndex);
            }
            isValid &= this.checkResearchAreasForCommitteeMember(committeeMembership, membershipIndex);
        }
        return isValid;
    }

    private boolean hasNoTermOverlap(List<CommitteeMembershipBase> committeeMemberships, CommitteeMembershipBase committeeMembership, int membershipIndex) {
        boolean isValid = true;
        for (int i = 0; i < membershipIndex; ++i) {
            CommitteeMembershipBase tmpMember = committeeMemberships.get(i);
            if (!tmpMember.isSamePerson(committeeMembership) || committeeMembership.getTermStartDate() == null || committeeMembership.getTermEndDate() == null || tmpMember.getTermStartDate() == null || tmpMember.getTermEndDate() == null) continue;
            if (this.isWithinPeriod(committeeMembership.getTermStartDate(), tmpMember.getTermStartDate(), tmpMember.getTermEndDate())) {
                isValid = false;
                this.reportError(String.format(PROPERTY_NAME_TERM_START_DATE, membershipIndex), "error.committee.membership.person.duplicate", new String[]{tmpMember.getFormattedTermStartDate(), tmpMember.getFormattedTermEndDate()});
                continue;
            }
            if (!this.isWithinPeriod(committeeMembership.getTermEndDate(), tmpMember.getTermStartDate(), tmpMember.getTermEndDate())) continue;
            isValid = false;
            this.reportError(String.format(PROPERTY_NAME_TERM_END_DATE, membershipIndex), "error.committee.membership.person.duplicate", new String[]{tmpMember.getFormattedTermStartDate(), tmpMember.getFormattedTermEndDate()});
        }
        return isValid;
    }

    private boolean isValidTermStartEndDates(CommitteeMembershipBase committeeMembership, int membershipIndex) {
        boolean isValid = true;
        if (committeeMembership.getTermStartDate() != null && committeeMembership.getTermEndDate() != null && committeeMembership.getTermEndDate().before(committeeMembership.getTermStartDate())) {
            isValid = false;
            this.reportError(String.format(PROPERTY_NAME_TERM_END_DATE, membershipIndex), "error.committee.membership.termEndDate.before.termStartDate", new String[0]);
        }
        return isValid;
    }

    private boolean isValidRoles(CommitteeMembershipBase committeeMembership, int membershipIndex) {
        boolean isValid = true;
        List membershipRoles = committeeMembership.getMembershipRoles();
        isValid &= this.hasRoles(committeeMembership, membershipIndex);
        for (CommitteeMembershipRole membershipRole : membershipRoles) {
            int roleIndex = membershipRoles.indexOf(membershipRole);
            isValid &= this.isValidRoleStartEndDates(membershipRole, membershipIndex, roleIndex);
            if (!(isValid &= this.roleDatesWithinTermDates(committeeMembership, membershipRole, membershipIndex, roleIndex))) continue;
            isValid &= this.hasNoRoleOverlap(committeeMembership, membershipRole, membershipIndex, roleIndex);
        }
        return isValid;
    }

    private boolean hasRoles(CommitteeMembershipBase committeeMembership, int membershipIndex) {
        boolean hasExpertise = true;
        if (committeeMembership.getMembershipRoles().isEmpty()) {
            hasExpertise = false;
            this.reportError(String.format(PROPERTY_NAME_ROLE_CODE_ADD, membershipIndex), "error.committee.membership.role.missing", new String[0]);
        }
        return hasExpertise;
    }

    private boolean isValidRoleStartEndDates(CommitteeMembershipRole membershipRole, int membershipIndex, int roleIndex) {
        boolean isValid = true;
        if (membershipRole.getStartDate() != null && membershipRole.getEndDate() != null && membershipRole.getEndDate().before(membershipRole.getStartDate())) {
            isValid = false;
            this.reportError(String.format(PROPERTY_NAME_ROLE_END_DATE, membershipIndex, roleIndex), "error.committee.membership.roleEndDate.before.roleStartDate", new String[0]);
        }
        return isValid;
    }

    private boolean roleDatesWithinTermDates(CommitteeMembershipBase committeeMembership, CommitteeMembershipRole membershipRole, int membershipIndex, int roleIndex) {
        boolean isValid = true;
        if (committeeMembership.getTermStartDate() != null && committeeMembership.getTermEndDate() != null && membershipRole.getStartDate() != null && membershipRole.getEndDate() != null) {
            if (this.hasDateOutsideCommitteeMembershipTerm(committeeMembership, membershipRole.getStartDate())) {
                isValid = false;
                this.reportError(String.format(PROPERTY_NAME_ROLE_START_DATE, membershipIndex, roleIndex), "error.committee.membership.roleStartDate.outside.term", new String[0]);
            }
            if (this.hasDateOutsideCommitteeMembershipTerm(committeeMembership, membershipRole.getEndDate())) {
                isValid = false;
                this.reportError(String.format(PROPERTY_NAME_ROLE_END_DATE, membershipIndex, roleIndex), "error.committee.membership.roleEndDate.outside.term", new String[0]);
            }
        }
        return isValid;
    }

    private boolean hasDateOutsideCommitteeMembershipTerm(CommitteeMembershipBase committeeMembership, Date date) {
        boolean isOutside = false;
        if (committeeMembership.getTermStartDate() != null && committeeMembership.getTermEndDate() != null && date != null && (date.before(committeeMembership.getTermStartDate()) || date.after(committeeMembership.getTermEndDate()))) {
            isOutside = true;
        }
        return isOutside;
    }

    private boolean hasNoRoleOverlap(CommitteeMembershipBase committeeMembership, CommitteeMembershipRole membershipRole, int membershipIndex, int roleIndex) {
        boolean isValid = true;
        for (CommitteeMembershipRole tmpRole : committeeMembership.getMembershipRoles()) {
            if (roleIndex == committeeMembership.getMembershipRoles().indexOf(tmpRole) || !membershipRole.getMembershipRoleCode().equals(tmpRole.getMembershipRoleCode()) || !this.isWithinPeriod(membershipRole.getStartDate(), tmpRole.getStartDate(), tmpRole.getEndDate()) && !this.isWithinPeriod(membershipRole.getEndDate(), tmpRole.getStartDate(), tmpRole.getEndDate())) continue;
            isValid = false;
            this.reportError(String.format(PROPERTY_NAME_ROLE_CODE, membershipIndex, roleIndex), "error.committee.membership.role.duplicate", new String[0]);
        }
        return isValid;
    }

    private boolean isWithinPeriod(Date date, Date periodStart, Date periodEnd) {
        return !date.before(periodStart) && !date.after(periodEnd);
    }

    private boolean hasExpertise(CommitteeMembershipBase committeeMembership, int membershipIndex) {
        boolean hasExpertise = true;
        if (committeeMembership.getMembershipExpertise().isEmpty()) {
            hasExpertise = false;
            this.reportError(String.format(PROPERTY_NAME_RESEARCH_AREA_CODE, membershipIndex), "error.committee.membership.expertise.missing", new String[0]);
        }
        return hasExpertise;
    }

    public boolean checkResearchAreasForCommitteeMember(CommitteeMembershipBase committeeMember, int membershipIndex) {
        boolean inactiveFound = false;
        StringBuffer inactiveResearchAreaIndices = new StringBuffer();
        List cmes = committeeMember.getMembershipExpertise();
        if (CollectionUtils.isNotEmpty((Collection)cmes)) {
            int raIndex = 0;
            for (CommitteeMembershipExpertiseBase cme : cmes) {
                if (cme.getResearchArea() != null && !cme.getResearchArea().isActive()) {
                    inactiveFound = true;
                    inactiveResearchAreaIndices.append(raIndex).append(SEPERATOR);
                }
                ++raIndex;
            }
        }
        if (inactiveFound) {
            String committeeMemberInactiveAreasOfExpertiseErrorPropertyKey = String.format(PROPERTY_NAME_INACTIVE_AREAS_OF_EXPERTISE_PREFIX, membershipIndex) + SEPERATOR + inactiveResearchAreaIndices.toString();
            this.reportError(committeeMemberInactiveAreasOfExpertiseErrorPropertyKey, "error.committee.membership.expertise.inactive", new String[0]);
        }
        return !inactiveFound;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean retval = true;
        return retval &= super.processRunAuditBusinessRules(document);
    }

    public boolean processAddCommitteeMembershipBusinessRules(AddCommitteeMembershipEvent addCommitteeMembershipEvent) {
        return new CommitteeMembershipRule().processAddCommitteeMembershipBusinessRules(addCommitteeMembershipEvent);
    }

    public boolean processAddCommitteeMembershipRoleBusinessRules(AddCommitteeMembershipRoleEvent addCommitteeMembershipRoleEvent) {
        return new CommitteeMembershipRule().processAddCommitteeMembershipRoleBusinessRules(addCommitteeMembershipRoleEvent);
    }

    public boolean processRules(KraDocumentEventBaseExtension event) {
        boolean retVal = false;
        retVal = event.getRule().processRules(event);
        return retVal;
    }

    private boolean processScheduleRules(CommitteeDocumentBase committeeDocument) {
        boolean retval = true;
        CommitteeScheduleTimeEvent scheduleTimeEvent = new CommitteeScheduleTimeEvent("", committeeDocument, null, committeeDocument.getCommittee().getCommitteeSchedules(), CommitteeScheduleEventBase.ErrorType.HARDERROR);
        retval &= scheduleTimeEvent.getRule().processRules((KraDocumentEventBaseExtension)scheduleTimeEvent);
        CommitteeScheduleDateConflictEvent scheduleDateConfliceEvent = new CommitteeScheduleDateConflictEvent("", committeeDocument, null, committeeDocument.getCommittee().getCommitteeSchedules(), CommitteeScheduleEventBase.ErrorType.HARDERROR);
        retval &= scheduleDateConfliceEvent.getRule().processRules((KraDocumentEventBaseExtension)scheduleDateConfliceEvent);
        CommitteeScheduleDeadlineEvent scheduleDeadlineEvent = new CommitteeScheduleDeadlineEvent("", committeeDocument, null, committeeDocument.getCommittee().getCommitteeSchedules(), CommitteeScheduleEventBase.ErrorType.HARDERROR);
        return retval &= scheduleDeadlineEvent.getRule().processRules((KraDocumentEventBaseExtension)scheduleDeadlineEvent);
    }

    public boolean validateCommitteeResearchAreas(CommitteeBase committee) {
        boolean inactiveFound = false;
        StringBuffer inactiveResearchAreaIndices = new StringBuffer();
        List cras = committee.getCommitteeResearchAreas();
        if (CollectionUtils.isNotEmpty((Collection)cras)) {
            int raIndex = 0;
            for (CommitteeResearchAreaBase cra : cras) {
                if (!cra.getResearchAreas().isActive()) {
                    inactiveFound = true;
                    inactiveResearchAreaIndices.append(raIndex).append(SEPERATOR);
                }
                ++raIndex;
            }
        }
        if (inactiveFound) {
            String committeeResearchAreaInactiveErrorPropertyKey = "document.committeeList[0].committeeResearchAreas.inactive." + inactiveResearchAreaIndices.toString();
            new ErrorReporter().reportError(committeeResearchAreaInactiveErrorPropertyKey, "error.committee.researchArea.inactive", new String[0]);
        }
        return !inactiveFound;
    }

    public boolean validateReviewType(CommitteeBase committee) {
        boolean valid = true;
        if (StringUtils.isBlank((String)committee.getReviewTypeCode())) {
            new ErrorReporter().reportError(REVIEW_TYPE_ERROR_PROPERTY_NAME, "error.committee.reviewType.required", new String[0]);
            valid = false;
        }
        return valid;
    }
}

