/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.rules;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleDayEvent;
import org.kuali.kra.common.committee.rules.CommitteeScheduleDayRule;
import org.kuali.kra.common.committee.web.struts.form.schedule.MonthlyScheduleDetails;
import org.kuali.kra.common.committee.web.struts.form.schedule.ScheduleData;
import org.kuali.kra.common.committee.web.struts.form.schedule.StyleKey;
import org.kuali.kra.common.committee.web.struts.form.schedule.YearlyScheduleDetails;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class CommitteeScheduleDayRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<CommitteeScheduleDayEvent> {
    public static final String SCHEDULEDATA_MONTHLY_DAY = "committeeHelper.scheduleData.monthlySchedule.day";
    public static final String SCHEDULEDATA_YEARLY_DAY = "committeeHelper.scheduleData.yearlySchedule.day";

    public boolean processRules(CommitteeScheduleDayEvent event) {
        boolean rulePassed = true;
        ScheduleData scheduleData = event.getScheduleData();
        StyleKey key = StyleKey.valueOf((String)scheduleData.getRecurrenceType());
        switch (1.$SwitchMap$org$kuali$kra$common$committee$web$struts$form$schedule$StyleKey[key.ordinal()]) {
            case 1: {
                MonthlyScheduleDetails.optionValues monthOption = MonthlyScheduleDetails.optionValues.valueOf((String)scheduleData.getMonthlySchedule().getMonthOption());
                switch (1.$SwitchMap$org$kuali$kra$common$committee$web$struts$form$schedule$MonthlyScheduleDetails$optionValues[monthOption.ordinal()]) {
                    case 1: {
                        rulePassed = this.validateDay(scheduleData.getMonthlySchedule().getDay(), SCHEDULEDATA_MONTHLY_DAY);
                    }
                }
                break;
            }
            case 2: {
                YearlyScheduleDetails.yearOptionValues yearOption = YearlyScheduleDetails.yearOptionValues.valueOf((String)scheduleData.getYearlySchedule().getYearOption());
                switch (1.$SwitchMap$org$kuali$kra$common$committee$web$struts$form$schedule$YearlyScheduleDetails$yearOptionValues[yearOption.ordinal()]) {
                    case 1: {
                        rulePassed = this.validateDay(scheduleData.getYearlySchedule().getDay(), scheduleData.getYearlySchedule().getSelectedOption1Month(), SCHEDULEDATA_YEARLY_DAY);
                    }
                }
            }
        }
        return rulePassed;
    }

    private boolean validateDay(Integer day, String key) {
        boolean rulePassed = true;
        if (day != null && day.compareTo(31) > 0) {
            rulePassed = false;
            this.reportError(key, "error.committeeSchedule.day", new String[]{"31"});
        }
        return rulePassed;
    }

    private boolean validateDay(Integer day, String month, String key) {
        boolean rulePassed = true;
        int maxDay = StringUtils.equalsIgnoreCase((String)month, (String)"FEBRUARY") ? 29 : (StringUtils.equalsIgnoreCase((String)month, (String)"APRIL") || StringUtils.equalsIgnoreCase((String)month, (String)"JUNE") || StringUtils.equalsIgnoreCase((String)month, (String)"SEPTEMBER") || StringUtils.equalsIgnoreCase((String)month, (String)"NOVEMBER") ? 30 : 31);
        if (day != null && day.compareTo(maxDay) > 0) {
            rulePassed = false;
            this.reportError(key, "error.committeeSchedule.day", new String[]{"31"});
        }
        return rulePassed;
    }
}

