/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.rules;

import java.sql.Date;
import java.util.List;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleDeadlineEvent;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class CommitteeScheduleDeadlineDateRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<CommitteeScheduleDeadlineEvent> {
    public static final String ID = "document.committeeList[0].committeeSchedules[%1$s].protocolSubDeadline";

    public boolean processRules(CommitteeScheduleDeadlineEvent deadlineCommitteeScheduleEvent) {
        boolean rulePassed = true;
        List committeeSchedules = deadlineCommitteeScheduleEvent.getCommitteeSchedules();
        int count = 0;
        for (CommitteeScheduleBase committeeSchedule : committeeSchedules) {
            Date deadline = committeeSchedule.getProtocolSubDeadline();
            Date schedule = committeeSchedule.getScheduledDate();
            if (schedule != null && deadline != null && schedule.before(deadline)) {
                this.reportError(String.format(ID, count), "error.committeeSchedule.dealine", new String[]{deadline.toString(), schedule.toString()});
                rulePassed = false;
            }
            ++count;
        }
        return rulePassed;
    }
}

