/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.service.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommScheduleMinuteDocBase;
import org.kuali.kra.common.committee.meeting.ScheduleAgendaBase;
import org.kuali.kra.common.committee.notification.AgendaCreatedNotificationRenderer;
import org.kuali.kra.common.committee.notification.CommitteeNotificationContext;
import org.kuali.kra.common.committee.notification.MinutesCreatedNotificationRenderer;
import org.kuali.kra.common.committee.service.CommonCommitteeNotificationService;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.service.KcNotificationService;

public class CommitteeNotificationServiceImpl
implements CommonCommitteeNotificationService {
    private String committeeNotificationType;
    private KcNotificationService kcNotificationService;

    public String getCommitteeNotificationType() {
        return this.committeeNotificationType;
    }

    public void setCommitteeNotificationType(String committeeNotificationType) {
        this.committeeNotificationType = committeeNotificationType;
    }

    public void generateNotification(String notificationType, ScheduleAgendaBase agenda) {
        if (!StringUtils.equals((String)notificationType, (String)"213")) {
            throw new IllegalArgumentException(this.committeeNotificationType);
        }
        CommitteeScheduleBase committeeSchedule = agenda.getCommitteeSchedule();
        AgendaCreatedNotificationRenderer renderer = new AgendaCreatedNotificationRenderer(agenda, "action taken");
        CommitteeNotificationContext context = new CommitteeNotificationContext(committeeSchedule, notificationType, "Agenda Generated Notification", (NotificationRenderer)renderer);
        this.kcNotificationService.sendNotification((NotificationContext)context);
    }

    public void generateNotification(String notificationType, CommScheduleMinuteDocBase minuteDoc) {
        if (!StringUtils.equals((String)notificationType, (String)"215")) {
            throw new IllegalArgumentException(this.committeeNotificationType);
        }
        CommitteeScheduleBase committeeSchedule = minuteDoc.getCommitteeSchedule();
        MinutesCreatedNotificationRenderer renderer = new MinutesCreatedNotificationRenderer(minuteDoc, "action taken");
        CommitteeNotificationContext context = new CommitteeNotificationContext(committeeSchedule, notificationType, "Minutes Generated Notification", (NotificationRenderer)renderer);
        this.kcNotificationService.sendNotification((NotificationContext)context);
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }
}

