/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.service.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.common.committee.service.CommitteeScheduleAttendanceServiceBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public abstract class CommitteeScheduleAttendanceServiceImplBase<CSRV extends CommitteeServiceBase<CMT, CS>, CMT extends CommitteeBase<CMT, CD, CS>, CD extends CommitteeDocumentBase<CD, CMT, CS>, CS extends CommitteeScheduleBase<CS, CMT, ?, ?>>
implements CommitteeScheduleAttendanceServiceBase {
    private CSRV committeeService;
    private ParameterService parameterService;

    public void setCommitteeService(CSRV committeeService) {
        this.committeeService = committeeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public Set<String> getVotingMembersPresent(String committeeId, String scheduleId) {
        HashSet<String> attendedMembers = new HashSet<String>();
        CommitteeBase committee = this.committeeService.getCommitteeById(committeeId);
        CommitteeScheduleBase schedule = this.committeeService.getCommitteeSchedule(committee, scheduleId);
        List attendances = schedule.getCommitteeScheduleAttendances();
        for (CommitteeScheduleAttendanceBase attendance : attendances) {
            attendedMembers.add(attendance.getPersonId());
        }
        String memberId = null;
        String votingMemberType = this.parameterService.getParameterValueAsString(this.getCommitteeDocumentClassBOHook(), "COMMITTEE_VOTING_MEMBERSHIP_TYPE_CODE");
        for (CommitteeMembershipBase member : committee.getCommitteeMemberships()) {
            memberId = member.getRolodexId() != null ? member.getRolodexId().toString() : member.getPersonId();
            if (!StringUtils.isNotBlank((String)memberId) || member.getMembershipTypeCode().equals(votingMemberType)) continue;
            attendedMembers.remove(memberId);
        }
        return attendedMembers;
    }

    protected abstract Class<CD> getCommitteeDocumentClassBOHook();

    public Set<String> getActualVotingMembersPresent(String committeeId, String scheduleId) {
        HashSet<String> attendedMembers = new HashSet<String>();
        CommitteeBase committee = this.committeeService.getCommitteeById(committeeId);
        CommitteeScheduleBase schedule = this.committeeService.getCommitteeSchedule(committee, scheduleId);
        List attendances = schedule.getCommitteeScheduleAttendances();
        for (CommitteeScheduleAttendanceBase attendance : attendances) {
            if (attendance.getGuestFlag()) continue;
            attendedMembers.add(attendance.getPersonId());
        }
        return attendedMembers;
    }

    public int getActualVotingMembersCount(String committeeId, String scheduleId) {
        return this.getActualVotingMembersPresent(committeeId, scheduleId).size();
    }
}

