/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.bo.ScheduleStatus;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttachmentsBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.service.CommitteeScheduleServiceBase;
import org.kuali.kra.common.committee.service.impl.CommitteeScheduleServiceImplBase;
import org.kuali.kra.common.committee.web.struts.form.schedule.DailyScheduleDetails;
import org.kuali.kra.common.committee.web.struts.form.schedule.MonthlyScheduleDetails;
import org.kuali.kra.common.committee.web.struts.form.schedule.ScheduleData;
import org.kuali.kra.common.committee.web.struts.form.schedule.StyleKey;
import org.kuali.kra.common.committee.web.struts.form.schedule.YearlyScheduleDetails;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewableBase;
import org.kuali.kra.scheduling.expr.util.CronSpecialChars;
import org.kuali.kra.scheduling.sequence.DefaultScheduleSequence;
import org.kuali.kra.scheduling.sequence.ScheduleSequence;
import org.kuali.kra.scheduling.sequence.TrimDatesScheduleSequenceDecorator;
import org.kuali.kra.scheduling.sequence.WeekScheduleSequenceDecorator;
import org.kuali.kra.scheduling.service.ScheduleService;
import org.kuali.kra.scheduling.util.Time24HrFmt;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class CommitteeScheduleServiceImplBase<CS extends CommitteeScheduleBase<CS, CMT, ?, CSM>, CMT extends CommitteeBase<CMT, ?, CS>, CSM extends CommitteeScheduleMinuteBase<CSM, CS>>
implements CommitteeScheduleServiceBase<CS, CMT, CSM> {
    private static final Log LOG = LogFactory.getLog(CommitteeScheduleServiceImplBase.class);
    private static final String COLON = ":";
    private static final String DESCRIPTION = "description";
    private static final String SCHEDULED = "Scheduled";
    private static final String PROTOCOL_ID_FIELD = "protocolIdFk";
    private static final String SCHEDULE_ID_FIELD = "scheduleIdFk";
    private static final String COMM_SCHEDULE_MINUTES_FIELD = "commScheduleMinutesId";
    private static final String ENTRY_NUMBER_FIELD = "entryNumber";
    private static final String SUBMISSION_ID_FIELD = "submissionIdFk";
    private static final String COMM_SCHEDULE_MINUTES_ID_PROPERTY = "commScheduleMinutesId";
    private BusinessObjectService businessObjectService;
    private ScheduleService scheduleService;
    private ReviewCommentsService<?> reviewCommentsService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setScheduleService(ScheduleService scheduleService) {
        this.scheduleService = scheduleService;
    }

    public void setReviewCommentsService(ReviewCommentsService<?> reviewCommentsService) {
        this.reviewCommentsService = reviewCommentsService;
    }

    public Boolean isCommitteeScheduleDeletable(CS committeeSchedule) {
        boolean retVal = false;
        retVal = this.isProtocolAssignedToScheduleDate(committeeSchedule) == false;
        return retVal;
    }

    protected Boolean isProtocolAssignedToScheduleDate(CS committeeSchedule) {
        boolean retVal = true;
        List list = committeeSchedule.getProtocols();
        if (null == list || list.size() == 0) {
            retVal = false;
        }
        return retVal;
    }

    public void addSchedule(ScheduleData scheduleData, CMT committee) throws ParseException {
        List dates = null;
        Date dtEnd = null;
        int frequency = 0;
        int day = 0;
        CronSpecialChars[] weekdays = null;
        CronSpecialChars weekOfMonth = null;
        CronSpecialChars dayOfWeek = null;
        CronSpecialChars month = null;
        Time24HrFmt time = this.getTime24hFmt((java.util.Date)scheduleData.getScheduleStartDate(), scheduleData.getTime().findMinutes());
        Date dt = scheduleData.getScheduleStartDate();
        StyleKey key = StyleKey.valueOf((String)scheduleData.getRecurrenceType());
        block0 : switch (1.$SwitchMap$org$kuali$kra$common$committee$web$struts$form$schedule$StyleKey[key.ordinal()]) {
            case 1: {
                dates = this.scheduleService.getScheduledDates((java.util.Date)dt, (java.util.Date)dt, time, null);
                break;
            }
            case 2: {
                DailyScheduleDetails.optionValues dailyoption = DailyScheduleDetails.optionValues.valueOf((String)scheduleData.getDailySchedule().getDayOption());
                switch (1.$SwitchMap$org$kuali$kra$common$committee$web$struts$form$schedule$DailyScheduleDetails$optionValues[dailyoption.ordinal()]) {
                    case 1: {
                        dtEnd = scheduleData.getDailySchedule().getScheduleEndDate();
                        day = scheduleData.getDailySchedule().getDay();
                        dates = this.scheduleService.getIntervalInDaysScheduledDates((java.util.Date)dt, (java.util.Date)dtEnd, time, Integer.valueOf(day));
                        break;
                    }
                    case 2: {
                        dtEnd = scheduleData.getDailySchedule().getScheduleEndDate();
                        weekdays = ScheduleData.convertToWeekdays((String[])scheduleData.getDailySchedule().getDaysOfWeek());
                        WeekScheduleSequenceDecorator scheduleSequence = new WeekScheduleSequenceDecorator((ScheduleSequence)new TrimDatesScheduleSequenceDecorator((ScheduleSequence)new DefaultScheduleSequence()), Integer.valueOf(1), Integer.valueOf(weekdays.length));
                        dates = this.scheduleService.getScheduledDates((java.util.Date)dt, (java.util.Date)dtEnd, time, weekdays, (ScheduleSequence)scheduleSequence);
                    }
                }
                break;
            }
            case 3: {
                dtEnd = scheduleData.getWeeklySchedule().getScheduleEndDate();
                if (CollectionUtils.isNotEmpty((Collection)scheduleData.getWeeklySchedule().getDaysOfWeek())) {
                    weekdays = ScheduleData.convertToWeekdays((String[])scheduleData.getWeeklySchedule().getDaysOfWeek().toArray(new String[scheduleData.getWeeklySchedule().getDaysOfWeek().size()]));
                }
                WeekScheduleSequenceDecorator scheduleSequence = new WeekScheduleSequenceDecorator((ScheduleSequence)new TrimDatesScheduleSequenceDecorator((ScheduleSequence)new DefaultScheduleSequence()), scheduleData.getWeeklySchedule().getWeek(), Integer.valueOf(weekdays.length));
                dates = this.scheduleService.getScheduledDates((java.util.Date)dt, (java.util.Date)dtEnd, time, weekdays, (ScheduleSequence)scheduleSequence);
                break;
            }
            case 4: {
                MonthlyScheduleDetails.optionValues monthOption = MonthlyScheduleDetails.optionValues.valueOf((String)scheduleData.getMonthlySchedule().getMonthOption());
                switch (1.$SwitchMap$org$kuali$kra$common$committee$web$struts$form$schedule$MonthlyScheduleDetails$optionValues[monthOption.ordinal()]) {
                    case 1: {
                        dtEnd = scheduleData.getMonthlySchedule().getScheduleEndDate();
                        day = scheduleData.getMonthlySchedule().getDay();
                        frequency = scheduleData.getMonthlySchedule().getOption1Month();
                        dates = this.scheduleService.getScheduledDates((java.util.Date)dt, (java.util.Date)dtEnd, time, Integer.valueOf(day), Integer.valueOf(frequency), null);
                        break;
                    }
                    case 2: {
                        dtEnd = scheduleData.getMonthlySchedule().getScheduleEndDate();
                        weekOfMonth = ScheduleData.getWeekOfMonth((String)scheduleData.getMonthlySchedule().getSelectedMonthsWeek());
                        dayOfWeek = ScheduleData.getDayOfWeek((String)scheduleData.getMonthlySchedule().getSelectedDayOfWeek());
                        frequency = scheduleData.getMonthlySchedule().getOption2Month();
                        dates = this.scheduleService.getScheduledDates((java.util.Date)dt, (java.util.Date)dtEnd, time, dayOfWeek, weekOfMonth, Integer.valueOf(frequency), null);
                    }
                }
                break;
            }
            case 5: {
                YearlyScheduleDetails.yearOptionValues yearOption = YearlyScheduleDetails.yearOptionValues.valueOf((String)scheduleData.getYearlySchedule().getYearOption());
                switch (1.$SwitchMap$org$kuali$kra$common$committee$web$struts$form$schedule$YearlyScheduleDetails$yearOptionValues[yearOption.ordinal()]) {
                    case 1: {
                        dtEnd = scheduleData.getYearlySchedule().getScheduleEndDate();
                        month = ScheduleData.getMonthOfWeek((String)scheduleData.getYearlySchedule().getSelectedOption1Month());
                        day = scheduleData.getYearlySchedule().getDay();
                        frequency = scheduleData.getYearlySchedule().getOption1Year();
                        dates = this.scheduleService.getScheduledDates((java.util.Date)dt, (java.util.Date)dtEnd, time, month, Integer.valueOf(day), Integer.valueOf(frequency), null);
                        break block0;
                    }
                    case 2: {
                        dtEnd = scheduleData.getYearlySchedule().getScheduleEndDate();
                        weekOfMonth = ScheduleData.getWeekOfMonth((String)scheduleData.getYearlySchedule().getSelectedMonthsWeek());
                        dayOfWeek = ScheduleData.getDayOfWeek((String)scheduleData.getYearlySchedule().getSelectedDayOfWeek());
                        month = ScheduleData.getMonthOfWeek((String)scheduleData.getYearlySchedule().getSelectedOption2Month());
                        frequency = scheduleData.getYearlySchedule().getOption2Year();
                        dates = this.scheduleService.getScheduledDates((java.util.Date)dt, (java.util.Date)dtEnd, time, weekOfMonth, dayOfWeek, month, Integer.valueOf(frequency), null);
                    }
                }
            }
        }
        ArrayList skippedDates = new ArrayList();
        scheduleData.setDatesInConflict(skippedDates);
        this.addScheduleDatesToCommittee(dates, committee, scheduleData.getPlace(), skippedDates);
    }

    protected Time24HrFmt getTime24hFmt(java.util.Date date, int min) throws ParseException {
        java.util.Date dt = DateUtils.round((java.util.Date)date, (int)5);
        dt = DateUtils.addMinutes((java.util.Date)dt, (int)min);
        GregorianCalendar cl = new GregorianCalendar();
        cl.setTime(dt);
        StringBuffer sb = new StringBuffer();
        String str = sb.append(cl.get(11)).append(COLON).append(cl.get(12)).toString();
        return new Time24HrFmt(str);
    }

    protected void addScheduleDatesToCommittee(List<java.util.Date> dates, CMT committee, String location, List<Date> skippedDates) {
        for (java.util.Date date : dates) {
            Date sqldate = new Date(date.getTime());
            if (!this.isDateAvailable(committee.getCommitteeSchedules(), sqldate).booleanValue()) {
                skippedDates.add(sqldate);
                continue;
            }
            CommitteeScheduleBase committeeSchedule = this.getNewCommiteeScheduleInstanceHook();
            committeeSchedule.setScheduledDate(sqldate);
            committeeSchedule.setPlace(location);
            committeeSchedule.setTime(new Timestamp(date.getTime()));
            int daysToAdd = committee.getAdvancedSubmissionDaysRequired();
            Date sqlDate = this.calculateAdvancedSubmissionDays(date, Integer.valueOf(daysToAdd));
            committeeSchedule.setProtocolSubDeadline(sqlDate);
            committeeSchedule.setCommittee(committee);
            ScheduleStatus defaultStatus = this.getDefaultScheduleStatus();
            committeeSchedule.setScheduleStatusCode(defaultStatus.getScheduleStatusCode());
            committeeSchedule.setScheduleStatus(defaultStatus);
            committee.getCommitteeSchedules().add(committeeSchedule);
        }
    }

    protected abstract CS getNewCommiteeScheduleInstanceHook();

    protected Boolean isDateAvailable(List<CS> committeeSchedules, Date date) {
        boolean retVal = true;
        for (CommitteeScheduleBase committeeSchedule : committeeSchedules) {
            Date scheduledDate = committeeSchedule.getScheduledDate();
            if (scheduledDate == null || !DateUtils.isSameDay((java.util.Date)scheduledDate, (java.util.Date)date)) continue;
            retVal = false;
            break;
        }
        return retVal;
    }

    protected Date calculateAdvancedSubmissionDays(java.util.Date startDate, Integer days) {
        java.util.Date deadlineDate = DateUtils.addDays((java.util.Date)startDate, (int)(-days.intValue()));
        return new Date(deadlineDate.getTime());
    }

    protected ScheduleStatus getDefaultScheduleStatus() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(DESCRIPTION, SCHEDULED);
        List scheduleStatuses = (List)this.businessObjectService.findMatching(ScheduleStatus.class, fieldValues);
        return (ScheduleStatus)scheduleStatuses.get(0);
    }

    public List<CSM> getMinutesByProtocol(Long protocolId) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put(PROTOCOL_ID_FIELD, protocolId);
        List minutes = (List)this.businessObjectService.findMatchingOrderBy(this.getCommitteeScheduleMinuteBOClassHook(), fieldValues, ENTRY_NUMBER_FIELD, true);
        return minutes;
    }

    protected abstract Class<CSM> getCommitteeScheduleMinuteBOClassHook();

    public List<CSM> getMinutesBySchedule(Long scheduleId) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        ArrayList<CommitteeScheduleMinuteBase> permittedMinutes = new ArrayList<CommitteeScheduleMinuteBase>();
        fieldValues.put(SCHEDULE_ID_FIELD, scheduleId);
        List minutes = (List)this.businessObjectService.findMatchingOrderBy(this.getCommitteeScheduleMinuteBOClassHook(), fieldValues, ENTRY_NUMBER_FIELD, true);
        for (CommitteeScheduleMinuteBase minute : minutes) {
            if (!this.reviewCommentsService.getReviewerCommentsView((ProtocolReviewableBase)minute)) continue;
            permittedMinutes.add(minute);
        }
        return permittedMinutes;
    }

    public CSM getCommitteeScheduleMinute(Long committeeScheduleId) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("commScheduleMinutesId", committeeScheduleId);
        List minutes = (List)this.businessObjectService.findMatching(this.getCommitteeScheduleMinuteBOClassHook(), fieldValues);
        if (minutes.size() == 1) {
            return (CSM)((CommitteeScheduleMinuteBase)minutes.get(0));
        }
        return null;
    }

    public List<CSM> getMinutesByProtocolSubmission(Long submissionID) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        ArrayList<CommitteeScheduleMinuteBase> permittedMinutes = new ArrayList<CommitteeScheduleMinuteBase>();
        fieldValues.put(SUBMISSION_ID_FIELD, submissionID);
        List minutes = (List)this.businessObjectService.findMatchingOrderBy(this.getCommitteeScheduleMinuteBOClassHook(), fieldValues, ENTRY_NUMBER_FIELD, true);
        for (CommitteeScheduleMinuteBase minute : minutes) {
            if (!this.reviewCommentsService.getReviewerCommentsView((ProtocolReviewableBase)minute)) continue;
            permittedMinutes.add(minute);
        }
        return permittedMinutes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadAttachment(KraPersistableBusinessObjectBase attachmentDataSource, HttpServletResponse response) throws Exception {
        CommitteeScheduleAttachmentsBase committeScheduleAttachments = this.getNewCommitteeScheduleAttachmentsInstanceHook();
        byte[] data = null;
        String contentType = null;
        String fileName = null;
        if (attachmentDataSource.getClass().isInstance(committeScheduleAttachments)) {
            committeScheduleAttachments = (CommitteeScheduleAttachmentsBase)attachmentDataSource;
            data = committeScheduleAttachments.getData();
            contentType = committeScheduleAttachments.getContentType();
            fileName = committeScheduleAttachments.getFileName();
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(data.length);
            baos.write(data);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)contentType, (ByteArrayOutputStream)baos, (String)fileName);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (IOException ioEx) {}
        }
    }

    protected abstract CommitteeScheduleAttachmentsBase getNewCommitteeScheduleAttachmentsInstanceHook();
}

