/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.web.struts.form;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeBatchCorrespondenceBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipExpertiseBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.document.authorization.CommitteeScheduleTaskBase;
import org.kuali.kra.common.committee.document.authorization.CommitteeTaskBase;
import org.kuali.kra.common.committee.service.CommitteeScheduleServiceBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.common.committee.web.struts.form.CommitteeFormBase;
import org.kuali.kra.common.committee.web.struts.form.schedule.ScheduleData;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CommitteeHelperBase
implements Serializable {
    private static final long serialVersionUID = 1744329032797755384L;
    private static final String BATCH_CORRESPONDENCE_PANEL_TITLE = "Batch Correspondence";
    private CommitteeFormBase committeeForm;
    private boolean modifyCommittee = false;
    private CommitteeMembershipBase newCommitteeMembership;
    private List<CommitteeMembershipRole> newCommitteeMembershipRoles;
    private List<CommitteeMembershipExpertiseBase> newCommitteeMembershipExpertise;
    private ScheduleData scheduleData;
    private String generateBatchCorrespondenceTypeCode;
    private Date generateStartDate;
    private Date generateEndDate;
    private List<CommitteeBatchCorrespondenceBase> generateBatchCorrespondence;
    private String historyBatchCorrespondenceTypeCode;
    private Date historyStartDate;
    private Date historyEndDate;
    private List<CommitteeBatchCorrespondenceBase> batchCorrespondenceHistory;
    private Boolean printRooster;
    private Boolean printFutureScheduledMeeting;
    private boolean modifySchedule = false;
    private boolean viewSchedule = false;
    private List<Boolean> viewSpecificSchedule;
    private boolean performAction = false;
    private boolean showActiveMembersOnly = true;
    private int memberIndex;

    public CommitteeHelperBase(CommitteeFormBase committeeForm) {
        this.committeeForm = committeeForm;
        this.newCommitteeMembership = this.getNewCommitteeMembershipInstanceHook();
        this.newCommitteeMembershipRoles = new ArrayList();
        this.setScheduleData(new ScheduleData());
        this.setGenerateBatchCorrespondence(new ArrayList());
        this.setBatchCorrespondenceHistory(new ArrayList());
        this.memberIndex = -1;
    }

    protected abstract CommitteeMembershipBase getNewCommitteeMembershipInstanceHook();

    public CommitteeBase<?, ?, ?> getCommittee() {
        return this.committeeForm.getCommitteeDocument().getCommittee();
    }

    public void prepareView() {
        if (this.committeeForm.getCommitteeDocument().getDocumentHeader().getWorkflowDocument().isFinal() || this.committeeForm.getCommitteeDocument().getDocumentHeader().getWorkflowDocument().isEnroute() || this.committeeForm.getCommitteeDocument().getDocumentHeader().getWorkflowDocument().isCanceled()) {
            this.modifyCommittee = false;
            CommitteeBase activeCommittee = this.getCommitteeService().getCommitteeById(this.getCommittee().getCommitteeId());
            if (activeCommittee != null && activeCommittee.getId().equals(this.getCommittee().getId())) {
                this.modifySchedule = this.canModifySchedule();
                this.viewSchedule = this.canViewSchedule();
                this.viewSpecificSchedule = this.canViewSpecificSchedule();
            } else {
                this.modifySchedule = false;
                this.viewSchedule = false;
                this.viewSpecificSchedule = this.canNotViewSpecificSchedule();
            }
        } else {
            this.modifyCommittee = this.canModifyCommittee();
            this.modifySchedule = false;
            this.viewSchedule = false;
            this.viewSpecificSchedule = this.canNotViewSpecificSchedule();
        }
        this.prepareCommitteeScheduleDeleteView();
        this.performAction = this.canPerformAction();
    }

    private void prepareCommitteeScheduleDeleteView() {
        boolean flag = false;
        CommitteeScheduleServiceBase service = this.getCommitteeScheduleService();
        for (CommitteeScheduleBase committeeSchedule : this.getSortedCommitteeScheduleList()) {
            flag = service.isCommitteeScheduleDeletable(committeeSchedule);
            committeeSchedule.setDelete(flag);
        }
    }

    private CommitteeScheduleServiceBase getCommitteeScheduleService() {
        return (CommitteeScheduleServiceBase)KraServiceLocator.getService((Class)this.getCommitteeScheduleServiceClassHook());
    }

    protected abstract Class<? extends CommitteeScheduleServiceBase> getCommitteeScheduleServiceClassHook();

    public boolean canModifyCommittee() {
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("modifyCommittee", this.getCommittee());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    private CommitteeServiceBase getCommitteeService() {
        return (CommitteeServiceBase)KraServiceLocator.getService((Class)this.getCommitteeServiceClassHook());
    }

    protected abstract Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook();

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public boolean getModifyCommittee() {
        return this.modifyCommittee;
    }

    public void setModifyCommittee(boolean modifyCommittee) {
        this.modifyCommittee = modifyCommittee;
    }

    public CommitteeMembershipBase getNewCommitteeMembership() {
        return this.newCommitteeMembership;
    }

    public void setNewCommitteeMembership(CommitteeMembershipBase newCommitteeMembership) {
        this.newCommitteeMembership = newCommitteeMembership;
    }

    public List<CommitteeMembershipRole> getNewCommitteeMembershipRoles() {
        while (this.committeeForm.getCommitteeDocument().getCommittee().getCommitteeMemberships().size() > this.newCommitteeMembershipRoles.size()) {
            this.newCommitteeMembershipRoles.add(this.newCommitteeMembershipRoles.size(), new CommitteeMembershipRole());
        }
        return this.newCommitteeMembershipRoles;
    }

    public void setNewCommitteeMembershipRoles(List<CommitteeMembershipRole> newCommitteeMembershipRoles) {
        this.newCommitteeMembershipRoles = newCommitteeMembershipRoles;
    }

    public List<CommitteeMembershipExpertiseBase> getNewCommitteeMembershipExpertise() {
        while (this.committeeForm.getCommitteeDocument().getCommittee().getCommitteeMemberships().size() > this.newCommitteeMembershipExpertise.size()) {
            this.newCommitteeMembershipExpertise.add(this.newCommitteeMembershipExpertise.size(), this.getNewCommitteeMembershipExpertiseInstanceHook());
        }
        return this.newCommitteeMembershipExpertise;
    }

    protected abstract CommitteeMembershipExpertiseBase getNewCommitteeMembershipExpertiseInstanceHook();

    public void setNewCommitteeMembershipExpertise(List<CommitteeMembershipExpertiseBase> newCommitteeMembershipExpertise) {
        this.newCommitteeMembershipExpertise = newCommitteeMembershipExpertise;
    }

    public ScheduleData getScheduleData() {
        return this.scheduleData;
    }

    public void setScheduleData(ScheduleData scheduleData) {
        this.scheduleData = scheduleData;
    }

    public String getGenerateBatchCorrespondenceTypeCode() {
        return this.generateBatchCorrespondenceTypeCode;
    }

    public void setGenerateBatchCorrespondenceTypeCode(String generateBatchCorrespondenceTypeCode) {
        this.generateBatchCorrespondenceTypeCode = generateBatchCorrespondenceTypeCode;
    }

    public Date getGenerateStartDate() {
        return this.generateStartDate;
    }

    public void setGenerateStartDate(Date generateStartDate) {
        this.generateStartDate = generateStartDate;
    }

    public Date getGenerateEndDate() {
        return this.generateEndDate;
    }

    public void setGenerateEndDate(Date generateEndDate) {
        this.generateEndDate = generateEndDate;
    }

    public String getHistoryBatchCorrespondenceTypeCode() {
        return this.historyBatchCorrespondenceTypeCode;
    }

    public void setHistoryBatchCorrespondenceTypeCode(String historyBatchCorrespondenceTypeCode) {
        this.historyBatchCorrespondenceTypeCode = historyBatchCorrespondenceTypeCode;
    }

    public Date getHistoryStartDate() {
        return this.historyStartDate;
    }

    public void setHistoryStartDate(Date historyStartDate) {
        this.historyStartDate = historyStartDate;
    }

    public Date getHistoryEndDate() {
        return this.historyEndDate;
    }

    public void setHistoryEndDate(Date historyEndDate) {
        this.historyEndDate = historyEndDate;
    }

    public List<CommitteeBatchCorrespondenceBase> getGenerateBatchCorrespondence() {
        return this.generateBatchCorrespondence;
    }

    public void setGenerateBatchCorrespondence(List<CommitteeBatchCorrespondenceBase> generateBatchCorrespondence) {
        this.generateBatchCorrespondence = generateBatchCorrespondence;
    }

    public List<CommitteeBatchCorrespondenceBase> getBatchCorrespondenceHistory() {
        Collections.sort(this.batchCorrespondenceHistory);
        return this.batchCorrespondenceHistory;
    }

    public void setBatchCorrespondenceHistory(List<CommitteeBatchCorrespondenceBase> batchCorrespondenceHistory) {
        this.batchCorrespondenceHistory = batchCorrespondenceHistory;
    }

    public Boolean getPrintRooster() {
        return this.printRooster;
    }

    public void setPrintRooster(Boolean printRooster) {
        this.printRooster = printRooster;
    }

    public Boolean getPrintFutureScheduledMeeting() {
        return this.printFutureScheduledMeeting;
    }

    public void setPrintFutureScheduledMeeting(Boolean printFutureScheduledMeeting) {
        this.printFutureScheduledMeeting = printFutureScheduledMeeting;
    }

    public void resetBatchCorrespondenceHistory(CommitteeFormBase committeeForm) {
        this.setBatchCorrespondenceHistory(null);
        committeeForm.setTabStates(new HashMap());
        committeeForm.getTabStates().put(WebUtils.generateTabKey((String)BATCH_CORRESPONDENCE_PANEL_TITLE), "OPEN");
    }

    public void setMemberIndex(int memberIndex) {
        this.memberIndex = memberIndex;
    }

    public int getMemberIndex() {
        return this.memberIndex;
    }

    public void prepareFilterDatesView(java.util.Date startDate, java.util.Date endDate) {
        startDate = DateUtils.addDays((java.util.Date)startDate, (int)-1);
        endDate = DateUtils.addDays((java.util.Date)endDate, (int)1);
        Date scheduleDate = null;
        for (CommitteeScheduleBase committeeSchedule : this.getSortedCommitteeScheduleList()) {
            scheduleDate = committeeSchedule.getScheduledDate();
            if (scheduleDate != null && scheduleDate.after(startDate) && scheduleDate.before(endDate)) {
                committeeSchedule.setFilter(true);
                continue;
            }
            committeeSchedule.setFilter(false);
        }
    }

    public void resetFilterDatesView() {
        for (CommitteeScheduleBase committeeSchedule : this.getSortedCommitteeScheduleList()) {
            committeeSchedule.setFilter(true);
        }
        this.getScheduleData().setFilterStartDate(null);
        this.getScheduleData().setFilerEndDate(null);
    }

    public boolean canModifySchedule() {
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("modifySchedule", this.getCommittee());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    public boolean canViewSchedule() {
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("viewSchedule", this.getCommittee());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    public List<Boolean> canViewSpecificSchedule() {
        ArrayList<Boolean> canViewSchedule = new ArrayList<Boolean>();
        for (CommitteeScheduleBase committeeSchedule : this.getCommittee().getCommitteeSchedules()) {
            CommitteeScheduleTaskBase task = this.getNewCommitteeScheduleTaskInstanceHook("viewSchedule", committeeSchedule.getParentCommittee(), committeeSchedule);
            canViewSchedule.add(this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task));
        }
        return canViewSchedule;
    }

    protected abstract CommitteeScheduleTaskBase getNewCommitteeScheduleTaskInstanceHook(String var1, CommitteeBase var2, CommitteeScheduleBase var3);

    public List<Boolean> canNotViewSpecificSchedule() {
        ArrayList<Boolean> canNotViewSchedule = new ArrayList<Boolean>();
        for (CommitteeScheduleBase committeeSchedule : this.getCommittee().getCommitteeSchedules()) {
            canNotViewSchedule.add(false);
        }
        return canNotViewSchedule;
    }

    public boolean canPerformAction() {
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("performCommitteeActions", this.getCommittee());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    protected abstract CommitteeTaskBase getNewCommitteeTaskInstanceHook(String var1, CommitteeBase var2);

    public boolean isModifySchedule() {
        return this.modifySchedule;
    }

    public void setModifySchedule(boolean modifySchedule) {
        this.modifySchedule = modifySchedule;
    }

    public boolean isViewSchedule() {
        return this.viewSchedule;
    }

    public void setViewSchedule(boolean viewSchedule) {
        this.viewSchedule = viewSchedule;
    }

    public List<Boolean> getViewSpecificSchedule() {
        return this.viewSpecificSchedule;
    }

    public boolean isPerformAction() {
        return this.performAction;
    }

    public boolean isShowActiveMembersOnly() {
        return this.showActiveMembersOnly;
    }

    public void setShowActiveMembersOnly(boolean showActiveMembersOnly) {
        this.showActiveMembersOnly = showActiveMembersOnly;
    }

    public void flagInactiveMembers() {
        for (CommitteeMembershipBase committeeMembership : this.committeeForm.getCommitteeDocument().getCommittee().getCommitteeMemberships()) {
            if (!committeeMembership.isActive()) {
                committeeMembership.setWasInactiveAtLastSave(true);
                continue;
            }
            committeeMembership.setWasInactiveAtLastSave(false);
        }
    }

    private List<CommitteeScheduleBase> getSortedCommitteeScheduleList() {
        List committeeSchedules = this.committeeForm.getCommitteeDocument().getCommittee().getCommitteeSchedules();
        Collections.sort(committeeSchedules);
        return committeeSchedules;
    }
}

